#pragma once
/*
  ==============================================================================

   Copyright 2005-11 by Satoshi Fujiwara.

   async can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   async is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with async; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "exception.h"
namespace sf {
struct audio_base : boost::noncopyable
{
  virtual ~audio_base() {};
  virtual bool is_enabled () const  = 0;
  /// TEhĐ
  virtual void play_buffer(BYTE* buffer) = 0;
  virtual void stop() = 0;
  virtual void reset() = 0;
  virtual uint32_t get_buffer_byte_size () const  = 0;
  virtual win32_error_exception* const result()  = 0;
};
}

