package tcp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

import lib.log.logWriter;

public class TcpClient extends Thread{
    public byte[] allResponseBytes = null;
    public ArrayList<byte[]> responseBytes = null;

    private int portNum;
    private String hostName;
    /**
     * 
     * @param portNum
     * @param hostName
     */
    public TcpClient(int portNum, String hostName) {
        this.portNum = portNum;
        this.hostName = hostName;
    }

    /**  T[o[փNGX𑗐M   */
    private ArrayList<String> requestHeader = null;

    public void setRequestHeader(ArrayList<String> requestHeader) {
        this.requestHeader = requestHeader;
    }

    public void run() {
        logWriter log = new logWriter("./logs/TcpClient.log");

        Socket socket = null;
        InputStream instr = null;
        OutputStream outstr = null;

        //w̃|[gɑ΂āA\Pbg𐶐܂ 
        try{
            System.out.println("w肵T[oƃ|[gɐڑ܂");
            socket = new Socket(hostName, portNum);

            instr = socket.getInputStream();
            outstr = socket.getOutputStream();
            responseBytes = new ArrayList<byte[]>();

            log.logWriteStr("[requestHeader]");
            log.logWriteStrList(requestHeader);

            // NGXg̑M
            for(String req:requestHeader) {
                outstr.write((req + "\r\n").getBytes());
            }
            int allByte = 0;
            while(true) {
                byte[] b = new byte[100000];
                int recvSize = instr.read(b);
                if(recvSize < 0) {
                    break;
                }
                byte[] buff = new byte[recvSize];
                for(int i = 0;i < recvSize;i++) {
                    buff[i] = b[i];
                }
                responseBytes.add(buff);
                allByte += recvSize;
            }
            allResponseBytes = new byte[allByte];
            int seek = 0;
            for(byte[] b:responseBytes) {
                String str = new String(b);
                System.out.println(str);
                for(int j = 0;j < b.length;j++) {
                    if(seek >= allByte) {
                        break;
                    }
                    allResponseBytes[seek] = b[j];
                    seek++;
                }
            }

            outstr.close();
            instr.close();
            socket.close();

            log.logWriteStr("[responseBytes]");
            log.logWriteByteList(responseBytes);

        } catch(Exception e){
            e.printStackTrace();
            System.out.println("G[I");
        } finally {
            try {
                instr.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.close();
    }

}
