package http;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;

import http.HttpConstValue;
import http.RequestObj;
import reflect.action.Action;
import tcp.TcpServer;
import tcp.TcpClient;
import lib.log.logWriter;
import lib.property.EasyIni;
import startupAction.reflect_test;

/**
 * TcpServerNXgpHTTP𐧌䂷NX
 * C^[tFCX HTPPConstValue
 */
public class HttpServer extends Thread implements HttpConstValue{

    /** ~߂󂯂tO */
    public boolean doStop = true;

    /** "/"̃fBNg */
    private String rootDirPath = null;
    /** ڑ|[gԍ */
    private int port_num = 0;

    private ArrayList classList = null;

    private RequestObj request = null;

    /**
     * ݒt@C̃Zbg
     * @param path
     */
    public void setConfigFilePath(String path) {
        this.iniObj = new EasyIni(path);
    }

    private EasyIni iniObj = null;

    private boolean pryFlg = false;

    public void setPcyFlag(boolean flag) {
        pryFlg = flag;
    }
    private int proxyPortNum = 80;
    public void setProxyPortNum(String num) {
        proxyPortNum = Integer.parseInt(num);
    }
    private String proxyHost = null;
    public void setProxyHost(String host) {
        this.proxyHost = host;
    }

    /**
     * [gfBNgw
     * @param path [gfBNg
     */
    public void setRootDirPath(String path) {
        this.rootDirPath = path;
    }

    /**
     * |[gԍ𕶎琔lɃZbg
     * @param num |[gԍ
     */
    public void setPortNum(String num) {
        port_num = Integer.parseInt(num);
    }

    /**
     * ʃNXstart\bhĂяoƎsXbh
     */
    public void run() {
        logWriter log = new logWriter("./logs/HttpServer.log");
        TcpServer svrTh = new TcpServer(port_num);
        System.out.println("Server start in " + port_num);

        // T[o[ƓɗオNX
        //reflectStartUPAction();

        // Xbh̊Jn
        svrTh.start();
        doStop = true;

        // doStopfalse܂Ŏs
        while(doStop) {
            try {
                Thread.sleep(1);
            } catch (InterruptedException e) {}
            if(svrTh.isGotReq) {
                svrTh.isGotReq = false;
                // NGXg͂
                request = new RequestObj();
                request.setRequestHeader(svrTh.requestHeader);

                log.logWriteStr("[svrTh.requestHeader at " +
                editTimeForLog(System.currentTimeMillis()) + "]");
                log.logWriteStrList(svrTh.requestHeader);
                // vLVgpꍇ
                if(pryFlg) {
                    TcpClient cltTh = new TcpClient(proxyPortNum, proxyHost);

                    cltTh.setRequestHeader(svrTh.requestHeader);
                    cltTh.start();
                        try {
                            cltTh.join();
                        } catch (InterruptedException e) {}
                    svrTh.responseBytes = cltTh.responseBytes;
                    log.logWriteStr("[svrTh.responseByte at " +
                    		editTimeForLog(System.currentTimeMillis()) + "]");
                    log.logWriteByteList(svrTh.responseBytes);

                    svrTh.interrupt();
                // ʏ̃NGXgꍇ
                } else {
                    svrTh.responseBytes = analyze(request);
                    log.logWriteStr("[svrTh.responseBytes at " +
                    		editTimeForLog(System.currentTimeMillis()) + "]");
                    log.logWriteByteList(svrTh.responseBytes);
                    svrTh.interrupt();
                }
            }
        }
        log.close();
        svrTh.socketClose();
        svrTh.continuos = false;
        System.out.println("Server stop");
    }
    /**
     * 󂯎NGXguEUɕԂX|X쐬
     * @param requestHeader uEŨNGXge
     * @return uEUւ̃X|X
     */
    private ArrayList<byte[]> analyze(RequestObj request) {
        String responseStr = "";
        ArrayList<byte[]> responseBytes = new ArrayList<byte[]>();
        try {
            if(request.getErrorLevel() != 200) {
                throw new Exception(request.getErrorMsg());
            }
            String ext = request.getExtention();
            String path = rootDirPath + request.getPath();
            path = path.replaceAll("\\\\", "/");

            File file = new File(path);

            if(ext.equals(".do")) {
                responseBytes = cgiGetHtml(request);
            }
            // NGXgΏۃt@C݂s
            else if(file.exists()) {
                //t@CǂݍރXg[
                FileInputStream fis = new FileInputStream(path);
                byte[] b = new byte[(int)file.length()];
                fis.read(b);

                String CrtDate = editTimeZone(System.currentTimeMillis());
                String LastMod = editTimeZone(file.lastModified());
                responseStr += "HTTP/1.1 200 OK\r\n";
                responseStr += "Date: " + CrtDate + " GMT\r\n";
                responseStr += "Last-Modified: " + LastMod + " GMT\r\n";
                responseStr += "ETag:\"45aa-707-3c19898c\"r\n";
                responseStr += "Accept-Ranges: bytes\r\n";
                responseStr += "Content-Length: " + file.length() + "\r\n";
                responseStr += "Connection: Keep-Alive\r\n";

                // t@C̊gq𔻒f
                if (ext.equals(".jpg")) {
                    responseStr += "Content-Type: image/jpeg\r\n";
                } else if(ext.equals(".png")) {
                    responseStr += "Content-Type: image/png\r\n";
                } else if(ext.equals(".css")) {
                    responseStr += "Content-Type: text/css\r\n";
                } else if(ext.equals(".js")) {
                    responseStr += "Content-Type: text/javascript\r\n";
                } else if(ext.equals(".html") || ext.equals(".htm")) {
                    responseStr += "Content-Type: text/html\r\n";
                }else {
                    responseStr += "Content-Type: text/plain\r\n";
                }

                responseStr += "\r\n";
                responseBytes.add(responseStr.getBytes());

                responseBytes.add(b);
                //responseBytes.add("\r\n".getBytes());

                fis.close();

            // NGXgΏۃt@C݂Ȃ404G[
            } else {
                responseStr += "HTTP/1.1 404 NG\r\n";
                responseStr += "\r\n";
                responseStr +=  path + " was not found\r\n";
                responseStr += "\r\n";
                responseBytes.add(responseStr.getBytes());
            }
            return responseBytes;

        } catch(Exception e) {
            e.printStackTrace();
            responseStr += "HTTP/1.1 500 NG";
            responseStr += "\r\n\r\n";
            responseStr +=  "internal Server error";
            responseStr += "\r\n\r\n";
            responseBytes.add(responseStr.getBytes());
            return responseBytes;
        }
    }
    /**
     * VXetHTTPwb_pɏҏW
     */
    public String editTimeZone(long milliSecound) {
        SimpleDateFormat sdf;
        sdf = new SimpleDateFormat("EEE d MMM yyyy HH mm ss", Locale.US);
        String editedDate = sdf.format(new Date(milliSecound));
        return editedDate;
    }

    /**
     * VXetOpɏҏW
     */
    public String editTimeForLog(long milliSecound) {
        SimpleDateFormat sdf;
        sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
        String editedDate = sdf.format(new Date(milliSecound));
        return editedDate;
    }

    /**
     * tNVT[oNɋN
     */
    public void reflectStartUPAction() {
        classList = new ArrayList<reflect_test>();
        Class cls = null;
        try {
            cls = Class.forName("startupAction.reflect_test");
            Method method = cls.getMethod("start", null);
            // s
            // method.invoke(cls.newInstance(),null);
        } catch(Exception e) {
            e.printStackTrace();
        }
        classList.add(cls);
    }
    /**
     * CGIT[o[ŎsB
     * @param request
     * @return
     */
    public ArrayList<byte[]> cgiGetHtml(RequestObj request) throws Exception{
        ArrayList<byte[]> responseBytes = new ArrayList<byte[]>();
        String path = request.getPath();
        String responseStr = "";
        path = path.replace(".do", "");
        path = path.replace("\\", "/");
        String PackageName = iniObj.getPro(path);
        if(PackageName != null) {
        	StringBuffer str = executeCgi(request, PackageName);
            byte[] b = null;
            try {
                b = str.toString().getBytes("utf-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String date = editTimeZone(System.currentTimeMillis());
            responseStr += "HTTP/1.1 200 OK\r\n";
            responseStr += "Date: " + date + " GMT\r\n";
            responseStr += "Last-Modified: " + date + " GMT\r\n";
            responseStr += "ETag:\"45aa-707-3c19898c\"r\n";
            responseStr += "Accept-Ranges: bytes\r\n";
            responseStr += "Content-Length: " + b.length + "\r\n";
            responseStr += "Connection: close\r\n";
            responseStr += "Content-Type: text/html\r\n";
            responseStr += "\r\n";
            responseBytes.add(responseStr.getBytes());
            responseBytes.add(b);
            responseBytes.add("\r\n\r\n".getBytes());
        } else {
            responseStr += "HTTP/1.1 404 NG\r\n";
            responseStr += "\r\n";
            responseStr +=  path + " was not found\r\n";
            responseStr += "\r\n";
            responseBytes.add(responseStr.getBytes());
        }
        return responseBytes;
    }
    private StringBuffer executeCgi(RequestObj request, String PackageName)
    		throws Exception{
	    Class<Action> cls = null;
	    StringBuffer str = null;

        cls = (Class<Action>)Class.forName(PackageName);
        Method method = cls.getMethod("execute", RequestObj.class);
        // s
        str = (StringBuffer)method.invoke(cls.newInstance(),request);

        return str;
    }

}
