//RoomInfomationCollecionNX
module.exports = function()
{
	var _this = this;
	var config = require("./configure.js");
	var MySQLPool = new require("./mysql_pool.js");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	var collection = {};
	this.Get = function(rno){
		return collection[rno];
	}
	this.IsContains = function(rno){
		return rno in collection;
	};
	this.GetMessage = function(){
		var retval = new Array();
		for(var rno in collection)
		{
			item={};
			item.applyflag = !_this.Get(rno).IsVolatile();
			item.password = collection[rno].password;
			if(item.password == null)
				item.password = "";
			item.hiddenlog = collection[rno].hiddenlog;
			retval.push(item);
		}
		return retval;
	};
	this.GetKeys = function(){
		var retval = {};
		for(var rno in collection)
		{
			retval[rno] = {};
		}
		return retval;
	}
	this.Update = function(data,callfunc){
		Clear();
		var async = require("async");
		async.waterfall([
			function(next){
				pool.query("TRUNCATE TABLE rooms",null,next);
			},
			function(result,next){
				var util = require("util");
				console.log(util.inspect(data));
				var items = new Array();
				var config = data.config;
				for(var i = 0; i < config.length; i++)
				{
					var rno = Number(config[i].applyflag);
					if(isNaN(rno))
						continue;
					var password,romonly;
					if(typeof(config[rno].password)=="undefined")
						password = null;
					else if(config[rno].password == "")
						password = null;
					else
						password = config[rno].password;
					if(typeof(config[rno].hiddenlog)=="undefined")
						romonly = false;
					else
						romonly = config[rno].hiddenlog == "romonly";

					Add(rno,password,romonly);
					items.push(new Array(rno,password,romonly));
				}
				pool.query("INSERT INTO rooms VALUES ?",[items],callfunc);
			}
		],callfunc);
	}
	function GetRoomList(callback){
		Clear();
		var async = require("async");
		async.waterfall([
			function(next){
				pool.query("SELECT * FROM rooms",null,next);
			},
			function(result,next){
				for(var i = 0; i < result.length; i++)
				{
					//MySQLłTINYINTgĂ
					Add(result[i].number,result[i].password,result[i].hiddenlog != 0);
				}
				next(null,null);
			}
		],callback);
	}
	function Clear(){
		collection = {};
		var config = require("./configure.js");
		for(var i = 0; i < config.max_room_number; i++)
			Add(i,null,null);
	};
	function Add(rno,pass,hiddenlogflag){
		collection[rno] = new RoomInfomation(pass,hiddenlogflag);
		if(pass != null)
			collection[rno].owner = $system_name;
	};
	var $gc_interval_id = setInterval(function(){
		for(var rno in _this.rom_list)
			collection[rno].GCRomList();
	},$gc_time_interval);
	GetRoomList();
}

//RoomInfomationNX
function RoomInfomation(pass,hiddenlogflag)
{
	var _this = this;
	this.password = pass;
	this.rom_list = {};
	this.authed_list = {};
	this.owner = null;
	this.time = null;
	this.hiddenlog = hiddenlogflag;
	this.GetConfig = function(){
		var roomconfig = {};
		if(_this.IsVolatile() == false)
		{
			if(_this.IsFixedPassword())
				roomconfig.type = 2;
			else if(_this.IsHiddenLogFromRom())
				roomconfig.type = 3;
			else
				roomconfig.type = 1;
			roomconfig.IsOwned = !_this.IsFirstAuth();
		}else{
			roomconfig.type = 0;
		}
		return roomconfig;
	}
	this.IsVolatile = function(){
		return _this.owner == null &&
			_this.password == null &&
			_this.time == null &&
			_this.hiddenlog == null;
	}
	this.GetRomCount = function(){
		var count = 0;
		for(var key in _this.rom_list)
			count++;
		return count;
	};
	this.AddRom = function(ip){
		var date = new Date();
		_this.rom_list[ip] = {time:date.getTime()};
	};
	this.RemoveRom = function(ip){
		delete _this.rom_list[ip];
	};
	this.Reset = function(owner){
		var date = new Date();
		var time = date.getTime();
		_this.password = null;
		_this.authed_list = {};
		_this.owner = owner;
		_this.time = time;
	};
	this.IsFirstAuth = function(){
		return _this.owner == null;
	};
	this.IsAuthed = function(name){
		return name == _this.owner ||
			name in _this.authed_list;
	};
	this.IsHiddenLogFromRom = function(){
		return _this.hiddenlog;
	};
	this.IsFixedPassword = function(){
		return _this.owner == $system_name;
	};
	this.IsOwner = function(name){
		return _this.owner == name;
	};
	this.IsTimeout = function(){
		var date = new Date();
		var current_time = date.getTime();
		return !_this.IsFixedPassword() &&
			current_time - _this.time >= $reset_password_diff;
	};
	this.RemoveAuth = function(name)
	{
		delete _this.authed_list[name];
	};
	this.Auth = function(name,password){
		if(_this.password != password)
			return false;
		var date = new Date();
		var time = date.getTime();
		_this.time = time;
		_this.authed_list[name] = "";
		return true;
	};
	this.SetPassword = function(owner,password){
		if(owner == _this.owner &&
			!_this.IsFixedPassword() &&
			!_this.IsHiddenLogFromRom())
		{
			var date = new Date();
			_this.time = date.getTime();
			_this.password = password;
			return true;
		}
		return false;
	};
	this.GCRomList = function(){
		var date = new Date();
		var current_time = date.getTime();
		for(var ip in _this.rom_list)
		{
			if(current_time - _this.rom_list[ip].time >= $gc_time_interval)
				delete _this.rom_list[ip];
		}
	};
}
