﻿var config = require("./configure.js");
var resource = require("./resources.js");
var util = require("util");
var async = require("async");
var security = require("./security.js");
var ejs = require("ejs");
require("date-utils");

var collection = new ProfileCollection();

module.exports = function(app){
	app.get("/profile",list_proc);
	app.get("/profile/admin",admin_proc);
	app.post("/profile/admin",admin_postproc);
	app.get("/profile/detail",detail_proc);
	app.post("/profile/detail",detail_postproc);
	app.post("/profile/edit",edit_postproc); 
	app.get("/profile/registor",registor_proc); 
	app.post("/profile/registor",registor_postproc); 
};

function admin_proc(req, res)
{
	var info = new security.SessionInfomation(true);
	req.session.items = info;
	async.waterfall([
		function(callback){
			PrepaerListAsync(req,callback);
		}
	],function(err,result){
		if(err != null)
			RenderMessage(res,err,info);
		else{
			result.token = req.session._csrf;
			res.setHeader("X-FRAME-OPTIONS","DENY");
			res.render("profile/admin",result);
		}
	});
}

function admin_postproc(req,res)
{
	async.waterfall([
		function(cb){
			if(typeof(req.body.removeall) != "undefined")
				collection.ClearAsync(cb);
			if(typeof(req.body.remove) != "undefined")
				collection.RemoveRangeAsync(req.body.names,cb);
		}
	],function(err,result){
		if(err != null)
			RenderMessage(res,err,req.session.items);
		else
			RenderMessage(res,resource.success_remove,req.session.items);
	});
}

function list_proc(req, res)
{
	if(typeof(req.session.items) != "undefined")
		req.session.items.admin = false;
	async.waterfall([
		function(cb){
			PrepaerListAsync(req,cb);
		}
	],function(err,result){
		if(err != null)
			RenderMessage(res,err,req.session.items);
		else
			res.render("profile/list",result);
	});
}

function PrepaerListAsync(req,callback)
{
	var limit = config.db_limit;
	var start = 0;
	var parttern = "";
	if(typeof(req.query.start) != "undefined")
		start = parseInt(req.query.start);
	if(typeof(req.query.limit) != "undefined")
		limit = parseInt(req.query.limit);

	async.waterfall([
		function(cb){
			if(typeof(req.query.search) != "undefined")
			{
				parttern = req.query.search;
				collection.FindByNameAsync(parttern,start,limit,cb);
			}else{
				collection.ToArrayAsync(start,limit,cb);
			}
		}
	],function(err,result){
		if(err != null){
			callback(err,null);
		}else{
			var next = start + limit;
			var prev = start - limit;
			if(prev < 0)
				prev = 0;
			for(var i = 0; i < result.length; i++)
				result[i].lastmodified = result[i].lastmodified.toFormat("YYYY/MM/DD HH:MI:SS");
			callback(null,{list:result,search:parttern,next:next,prev:prev,limit:limit});
		}
	});
}

function detail_proc(req, res)
{
	if(typeof(req.query.name) == "undefined")
	{
		RenderMessage(res,resource.invaild_parameter,req.session.items);
		return;
	}

	if(typeof(req.session.items) == "undefined")
		req.session.items = new security.SessionInfomation(false);

	async.waterfall([
		function(cb){
			collection.GetAsync(req.query.name,cb);
		},
	],function(err,result){
		if(err != null)
			RenderMessage(res,err,req.session.items);
		else if(result.length == 0)
			RenderMessage(res,resource.notfound_name,req.session.items);
		else{
			res.setHeader("X-FRAME-OPTIONS","DENY");
			res.render("profile/detail",{list:result,alias:config.alias,token:req.session._csrf,admin:req.session.items.admin});
		}
	});
}

function detail_postproc(req, res)
{
	if(typeof(req.body.remove) != "undefined"){
		async.waterfall([
			function(cb){
				if(typeof(req.session.items) != "undefined" && req.session.items.admin)
					cb(null,true);
				else
					collection.AuthAsync(req.body.name,req.body.password,cb);
			},
			function(result,cb){
				if(result)
					collection.RemoveAsync(req.body.name,cb);
				else
					cb(null,null);
			}
		],function(err,result){
			if(err != null)
				RenderMessage(res,err,req.session.items);
			else if(result == null)
				RenderMessage(res,resource.unmatch_password,req.session.items);
			else
				RenderMessage(res,resource.success_remove,req.session.items);
		});
	}else if(typeof(req.body.edit) != "undefined"){
		async.waterfall([
			function(cb){
				if(typeof(req.session.items) != "undefined" && req.session.items.admin)
					cb(null,true);
				else
					collection.AuthAsync(req.body.name,req.body.password,cb);
			},
			function(result,cb){
				if(result)
					collection.GetAsync(req.body.name,cb);
				else
					cb(null,null);
			}
		],function(err,result){
			if(err != null){
				RenderMessage(res,err,req.session.items);
			}else if(result != null){
				res.setHeader("X-FRAME-OPTIONS","DENY");
				res.render("profile/edit",{list:result,token:req.session._csrf,alias:config.alias});
			}else{
				RenderMessage(res,resource.unmatch_password,req.session.items);
			}
		});
	}else{
		RenderMessage(res,resource.invaild_parameter,req.session.items);
	}
}

function edit_postproc(req, res)
{
	if(typeof(req.body.name) == "undefined")
	{
		RenderMessage(res,resource.invaild_parameter,req.session.items);
		return;
	}else if(typeof(req.body.edit) != "undefined"){
		var validator = new Validator();
		var result = validator.Validate(req.body,config.alias,true);
		if(result.length > 0)
		{
			RenderMessage(res,result,req.session.items);
			return;
		}
		async.waterfall([
			function(cb){
				collection.UpdatAsync(req.body.name,req.body,cb);
			},
		],function(err,result){
			if(err != null)
				RenderMessage(res,err,req.session.items);
			else
				RenderMessage(res,resource.success_edit,req.session.items);
		});
	}else{
		RenderMessage(res,resource.invaild_parameter,req.session.items);
	}
}

function registor_postproc(req, res)
{
	if(typeof(req.body.registor) != "undefined"){
		var validator = new Validator();
		var result = validator.Validate(req.body,config.alias,false);
		if(result.length > 0)
		{
			RenderMessage(res,result,req.session.items);
			return;
		}
		async.waterfall([
			function(cb){
				collection.AddAsync(req.body,cb);
			}
		],function(err,result){
			if(err != null)
				RenderMessage(res,err,req.session.items);
			else
				RenderMessage(res,resource.success_registor,req.session.items);
		});
	}else{
		RenderMessage(resource.invaild_parameter,req.session.items);
	}
}

function registor_proc(req, res)
{
	if(typeof(req.session.items) == "undefined")
		req.session.items = new security.SessionInfomation(false);

	res.setHeader("X-FRAME-OPTIONS","DENY");
	res.render("profile/registor",{token:req.session._csrf,alias:config.alias});
}

function RenderMessage(res,msg,info)
{
	if(typeof(msg) == "string")
		msg = new Array(msg);
	if(typeof(info) == "undefined" || typeof(info.admin) == "undefined")
		res.render("profile/message",{message:msg,admin:false});
	else
		res.render("profile/message",{message:msg,admin:info.admin});
}

//
// ProfileCollectionクラス
//
function ProfileCollection()
{
	var MySQLPool = new require("./mysql_pool.js");
	var murmurhash = require("murmurhash");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	this.AuthAsync = function(name,password,cb){
		async.waterfall([
			function(next){
				pool.query("SELECT password FROM profilelist WHERE name_hash = ? and name = ?",[murmurhash.v3(name),name],next);
			},
			function(result,next){
				if(result[0].password == md5_hex(password))
					next(null,true);
				else
					next(null,false);
			}
		],cb);
	}
	this.GetAsync = function(name,cb){
		pool.query("SELECT * FROM profilelist WHERE name_hash = ? and name = ?",[murmurhash.v3(name),name],cb);
	}
	this.AddAsync = function(data,cb){
		var item = GetItem(data);;
		pool.query("INSERT INTO profilelist SET ?",[item],cb);
	}
	this.UpdatAsync = function(name,data,cb){
		var item = GetItem(data);
		pool.query("UPDATE profilelist SET ? WHERE name_hash = ? and name = ?",[item,murmurhash.v3(name),name],cb);
	}
	this.ClearAsync = function(cb){
		pool.query("TRUNCATE TABLE profilelist",null,cb);
	}
	this.RemoveRangeAsync = function(names,cb){
		pool.query("DELETE FROM profilelist WHERE name IN (?)",[names],cb);
	}
	this.RemoveAsync = function(name,cb){
		pool.query("DELETE FROM profilelist WHERE name_hash = ? and name = ?",[murmurhash.v3(name),name],cb);
	}
	this.FindByNameAsync = function(pattern,start,count,cb){
		pool.query("SELECT * FROM profilelist WHERE name LIKE ? LIMIT ?,?",[pattern+"%",start,count],cb);
	}
	this.ToArrayAsync = function(start,count,cb){
		pool.query("SELECT name,lastmodified FROM profilelist LIMIT ?,?",[start,count],cb);
	}

	var crypto = require("crypto");
	function md5_hex(src)
	{
		var md5 = crypto.createHash('md5');
		md5.update(src, 'utf8');
	return md5.digest('hex');
	}

	function GetItem(data,newpw)
	{
		var item = {
			name_hash:murmurhash.v3(data.name),
			lastmodified:new Date(),
		};
		for(var key in config.alias)
		{
			if(typeof(config.alias[key].nodefinetable) != "undefined" && 
				config.alias[key].nodefinetable)
				continue;
			if(config.alias[key].visible_edit)
			{
				if(config.alias[key].type == "password")
				{
					if(data[key] != "")
						item[key] = md5_hex(data[key]);
				}
				else if(data[key] == "" && typeof(config.alias[key].defaultvalue) != "undefined")
				{
					item[key] = config.alias[key].defaultvalue;
				}
				else
				{
					item[key] = data[key];
				}
			}
		}
		return item;
	}
}

//
// Validatorクラス
//
function Validator()
{
	//
	// バリテーションを行う。
	// エラーがあった場合は真。そうでない場合は偽を返す
	//
	// @body バリテーションの対象となる連想配列
	// @alias バリテーションを行う要素のリスト
	// @editflag 編集時なら真
	this.Validate = function(body,alias,editflag){
		var result = new Array();
		for(var key in alias)
		{
			if(alias[key].visible_edit == false)
				continue;
			var message;
			if(typeof(alias[key].isnotempty) != "undefined" &&
				alias[key].isnotempty && body[key] == "")
					message = resource.is_not_empty;
			else if(typeof(alias[key].isnotemptyonregistor) != "undefined" &&
				alias[key].isnotemptyonregistor && body[key] == "" &&
				!editflag)
					message = resource.is_not_empty;
			else if(typeof(alias[key].mustmatchitem) != "undefined" &&
				body[key] != body[alias[key].mustmatchitem])
					message = util.format(resource.must_match_item,alias[alias[key].mustmatchitem].name); 
			else
				message = IsValidate(body[key],alias[key].type,alias[key].rule);
			if(message != null)
				result.push(alias[key].name + "：" + message);
		}
		return result;
	}
	function IsValidate(data,type,rule){
		if(typeof(data) == "undefined")
			throw "data is undefined";
		if(typeof(type) == "undefined")
			throw "type is undefined";

		var result = null;

		switch(type)
		{
			case "text":
			case "textarea":
			case "password":
				if(typeof(data) != "string")
					result = resource.is_not_string;
				break;
			case "number":
				if(data.match(/[^0-9]/g))
					result = resource.is_not_number;
				break;
			case "mail":
				if(data != "" && !data.match(/^[A-Za-z0-9]+[\w\-\+]+@[\w\.-]+\.\w{2,}$/))
					result = resource.is_not_mail;
				break;
		}

		if(typeof(rule) == "function")
			result = rule(data,type);

		return result;
	}
}
