﻿
//
//設定
//
var config = require("./configure.js");
//
//
//
$secret = "5514EA2B-C9B2-4D65-8D81-1F33A180A0C2";	//cookie用秘密鍵


// Server
var express = require("express");
var app = express();
var http = require("http");
var RedisStore = require("connect-redis")(express);
var sessionStore = new RedisStore({
	host:config.redisHost,
	port:config.redisPort,
	pass:config.redisPassword
});

// Configuration

app.configure(function(){
	app.disabled("view cache");
	app.set("view options", { layout: false })
	app.set("views", __dirname + "/public");
	app.set("view engine", "ejs");
	app.use(express.bodyParser());
	app.use(express.methodOverride());
	app.use(express.cookieParser($secret));
	app.use(express.session({
		store:sessionStore,
		cookie: { httpOnly: false }
	}));
	app.use(express.csrf());
	app.use(app.router);
	app.use(express.static(__dirname + "/public"));
});

app.configure("development", function(){
  app.use(express.errorHandler({ dumpExceptions: true, showStack: true })); 
});

app.configure("production", function(){
  app.use(express.errorHandler()); 
});

var async = require("async");
var fs = require("fs");

async.waterfall([
	function(next){
		fs.exists("inited",function(exists){
			next(null,exists);
		});
	},
	function(exists,next){
		if(exists)
			next(null);
		else
			fs.open("inited","a",function(err,fd){
				fs.closeSync(fd);
				var init = require("./init");
				init(next);
			});
	}
	],function(err){
		if(err != null)
		{
			console.log(err);
			process.exit();
		}
		var server = http.createServer(app).listen(config.port);
		console.log("Express server listening on port %d in %s mode", config.port, app.settings.env);
		
		require("./chat")(app,server,express,sessionStore);
		
		if(config.enable_profile)
			require("./profile")(app);
	});
