//IPBANNX
module.exports = function()
{
	var config = require("./configure.js");
	var MySQLPool = new require("./mysql_pool.js");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	var collection = {};
	this.IsBaned = function(ip){
		return collection[ip] == "r";
	}
	this.IsBlockedToWrite = function(ip){
		return ip in collection;
	}
	this.GetText = function(){
		var text = "";
		for(var key in collection)
		{
			if(collection[key] == "")
				text += key + "\r\n";
			else
				text += key + ":" + collection[key] + "\r\n";
		}
		return text;
	}
	this.Update = function(text,callfunc){
		collection = {};
		var async = require("async");
		async.waterfall([
			function(next){
				pool.query("TRUNCATE TABLE ipbanlist",null,next);
			},
			function(result,next){
				var items = new Array();
				lines = text.split("\r\n");
				for(var i = 0; i < lines.length; i++)
				{
					var token = lines[i].split(":");
					var ip = token[0];
					if(ip == "")
						continue;
					if(token.length == 1)
						collection[ip] = "";
					else
						collection[ip] = token[1];
					items.push(new Array(ip,collection[ip]));
				}
				pool.query("INSERT INTO ipbanlist VALUES ?",[items],next);
			},
		],callfunc);
	}
	function GetIpBanList(callfunc)
	{
		var async = require("async");
		async.waterfall([
			function(next){
				pool.query("SELECT * FROM ipbanlist",null,next);
			},
			function(result,next){
				for(var i = 0; i < result.length; i++)
					collection[result[i].ip] = result[i].type;
				next(null,null);
			},
		],callfunc);
	}
	GetIpBanList();
}
