﻿var util = require("util");
var config = require("./configure.js");

module.exports = function(callback){
	var async = require("async");
	
	var MySQLPool = new require("./mysql_pool.js");
	var pool = new MySQLPool({
				host     : config.db_host,
				user     : config.db_user,
				password : config.db_password,
				port     : config.db_port,
				database : config.db_name,
			});
	
	if("name_hash" in config.alias)
	{
		if(config.alias["name_hash"].type != "unsignednumber")
			throw "name_hashの型はunsignednumberでなければなりません";
	}else{
		throw "name_hashが存在しません";
	}
	
	if("name" in config.alias)
	{
		if(config.alias["name"].type != "text")
			throw "nameの型はtextでなければなりません";
	}else{
		throw "nameが存在しません";
	}
	
	if("password" in config.alias)
	{
		if(config.alias["password"].type != "password")
			throw "nameの型はpasswordでなければなりません";
	}else{
		throw "passwordが存在しません";
	}
	
	if("lastmodified" in config.alias)
	{
		if(config.alias["lastmodified"].type != "datetime")
			throw "lastmodifiedの型はtextでなければなりません";
	}else{
		throw "lastmodifiedが存在しません";
	}
	
	async.waterfall([
		function(next){
			var query = GetDropTableQuery("profilelist"); 
			pool.query(query,null,next);
		},
		function(result,next){
			var query = GetCreateQuery(config.alias,"profilelist"); 
			pool.query(query,null,next);
		},
		function(result,next){
			var query = GetDropTableQuery("ipbanlist"); 
			pool.query(query,null,next);
		},
		function(result,next){
			var def = {
				ip:{
					type : "text",
					length : 64,
					primary : true,
				},
				type:{
					type : "text",
					length : 1,
					primary : true,
				},
			};
			var query = GetCreateQuery(def,"ipbanlist"); 
			pool.query(query,null,next);
		},
		function(result,next){
			var query = GetDropTableQuery("rooms"); 
			pool.query(query,null,next);
		},
		function(result,next){
			var def = {
				number:
					{
						type : "unsignednumber",
						length:2,
						isnotempty : true,
						primary : true,
					},
				password:{
					type : "text",
					length : 16,
				},
				hiddenlog:{
					type : "bool",
				},
			};
			var query = GetCreateQuery(def,"rooms"); 
			pool.query(query,null,next);
		},
	],callback);
}

function GetDropTableQuery(tablename)
{
	var result = util.format("DROP TABLE IF EXISTS %s;",tablename);

	console.log(result);

	return result;
}

function GetCreateQuery(def,tablename)
{
	var result = "CREATE TABLE " + tablename + "(";
	for(key in def)
	{
		if(typeof(def[key].nodefinetable) != "undefined" && def[key].nodefinetable)
			continue;
		switch(def[key].type)
		{
			case "text":
				result += util.format("%s VARCHAR(%d) ",key,def[key].length);
				break;
			case "number":
				result += util.format("%s %s ",key,GetIntType(def[key].length));
				break;
			case "unsignednumber":
				result += util.format("%s %s UNSIGNED ",key,GetIntType(def[key].length));
				break;
			case "mail":
				result += util.format("%s VARCHAR(%d) ",key,def[key].length);
				break;
			case "password":
				result += util.format("%s VARCHAR(%d) ",key,def[key].length);
				break;
			case "textarea":
				result += util.format("%s TEXT ",key);
				break;
			case "bool":
				result += util.format("%s BOOL ",key);
				break
			case "datetime":
				result +=  util.format("%s DATETIME ",key);
				break;
			default:
				throw util.format("invaild %s type:%s",key,def[key].type);
		}
		if(typeof(def[key].isnotempty) != "undefined" && def[key].isnotempty)
			result += " NOT NULL ";
		result += ",";
	}

	for(key in def)
	{
		if(typeof(def[key].primary) != "undefined" && def[key].primary)
		{
			result += util.format("PRIMARY KEY(%s)",key);
			break;
		}
	}
	result += ");";

	console.log(result);

	return result;
}

function GetIntType(len)
{
	switch(len)
	{
		case 1:
			return "TINYINT";
		case 2:
			return "SMALLINT";
		case 4:
			return "INT";
	}
	console.log(len);
	throw "Invaild Length";
}
