/*
  spin ޥ
  Satofumi KAMIMURA
  $Id$
*/

#if !MONITOR
#include <runCtrl.h>
#else
#include <mRunCtrl.h>
#endif
#include <pathUtils.h>
#include <stdio.h>
#include <stdlib.h>

using namespace VXV;


int main(int argc, char *argv[]) {
  try {
#if !MONITOR
    RunCtrl run;
#else
    mRunCtrl run;
    vmonitor::show();
#endif
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }

    CoordinateCtrl local;
    local.setOwnCrdToCrd(&run, Position(1000, 1000, deg(0)));
    run.followLine(Position(0, 0, deg(0)), &local);
    VXV::Delay(6000);
    run.stop();

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
