/*
  ^CX^v̕\
  Satofumi KAMIMURA
  $Id$
*/

#include "runCtrl.h"
#include <stdio.h>
#include <stdlib.h>


static void printTicks(TicksCtrlInterface& module, int n) {
  for (int i = 0; i < n; ++i) {
    printf("ticks: %ld\n", module.getModuleTicks());
  }
}


int main(int argc, char *argv[]) {
  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.what());
      exit(1);
    }

    printTicks(run, 5);

    printf("\ncall adjustTicks(0)\n");
    run.adjustOwnTicks(0);
    printTicks(run, 5);

    printf("\ncall adjustTicks(1000)\n");
    run.adjustOwnTicks(1000);
    printTicks(run, 5);

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
