var config = {
    url: "http://localhost/trac/SampleProject/login/xmlrpc",
    username: "admin",
    password: "admin"
};
var xhr = new ActiveXObject("Msxml2.ServerXMLHTTP");
var tickets = [];
var futures = {};
var timeoutid = 0;
function tracXmlRpc (xml) {
    xhr.open("POST", config.url, false, config.username, config.password);
    xhr.setRequestHeader("content-type", "application/xml");
    xhr.send(xml.xml);
    var result = xhr.responseXML
    if (result.getElementsByTagName("fault").length != 0) throw new Error(result.text);
    return result;
}
function ticketQuery (id) {
    var xml = new ActiveXObject("Msxml2.DOMDocument");
    xml.appendChild(xml.createProcessingInstruction("xml", "version='1.0'"));
    var methodCall = xml.appendChild(xml.createElement("methodCall"));
    methodCall.appendChild(xml.createElement("methodName")).text = "ticket.query";
    var params = methodCall.appendChild(xml.createElement("params"));
    params.appendChild(xml.createElement("param")).appendChild(xml.createElement("string")).text = "id=" + id;
    return tracXmlRpc(xml);
}
function ticketUpdate (id, comments) {
    var xml = new ActiveXObject("Msxml2.DOMDocument");
    xml.appendChild(xml.createProcessingInstruction("xml", "version='1.0'"));
    var methodCall = xml.appendChild(xml.createElement("methodCall"));
    methodCall.appendChild(xml.createElement("methodName")).text = "ticket.update";
    var params = methodCall.appendChild(xml.createElement("params"));
    params.appendChild(xml.createElement("param")).appendChild(xml.createElement("int")).text = id;
    params.appendChild(xml.createElement("param")).appendChild(xml.createElement("string")).text = comments;
    return tracXmlRpc(xml);
}
function parseComments (comments) {
    var see = comments.match(/\[see\s*#(\d+)\s*\]/mg);
    var result = [];
    if (see != null) for (var i = 0, n = see.length; i < n; ++i) result.push(see[i].match(/\d+/));
    return result;
}
function ensureTicketExists (id) {
    for (var i = 0, n = tickets.length; i < n; ++i) if (tickets[i] == id) return false;
    var res = ticketQuery(id);
    if (res.getElementsByTagName("int").length == 0) throw new Error("#" + id + " not found.");
    tickets.push(id);
    return true;
}
function BeforeCheckin(d, u, r, v, l, c) {
    var id = parseComments(c);
    if (id.length == 0) throw new Error("チケット番号を指定してください。例: [see #42].");
    for (var i = 0, n = id.length; i < n; ++i) ensureTicketExists(id[i]);
}
function AfterCheckin(d, u, r, v, l, c) {
    alert("c/i: " + r + ";" + v);
    var a = "c/i: " + r.replace(/\s+$/g, "") + ";" + ("" + v).replace(/\s+$/g, "") + " (" + u.replace(/\s+$/g, "") + ")\r\n";
    if (futures[c] == undefined) {
        futures[c] = a;
        if (timeoutid != 0) clearTimeout(timeoutid);
        timeoutid = setTimeout("ticketUpdateFuture()", 3000);
    } else {
        futures[c] += a;
    }
}
function ticketUpdateFuture() {
    if (timeoutid != 0) clearTimeout(timeoutid);
    timeoutid = 0;
    for (c in futures) {
        if (c == undefined) continue;
        var id = parseComments(c);
        for (var i = 0, n = id.length; i < n; ++i) {
            ticketUpdate(id[i], futures[c] + c);
            alert("#" + id[i] + " updated");
        }
        delete futures[c];
        break;
    }
}
// function BeforeAdd(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("BeforeAdd"); }
function AfterAdd(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("add: " + Spec + ";" + VersionNumber); }
// function BeforeCheckout(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("BeforeCheckout"); }
function AfterCheckout(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("c/o: " + Spec + ";" + VersionNumber); }
// function BeforeCheckin(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("BeforeCheckin"); }
// function AfterCheckin(SrcSafeIni, UserName, Spec, VersionNumber, Local, Comment) { alert("C/i: " + Spec + ";" + VersionNumber); }
// function BeforeUndoCheckout(SrcSafeIni, UserName, Spec, VersionNumber, Local) { alert("BeforeUndoCheckout"); }
function AfterUndoCheckout(SrcSafeIni, UserName, Spec, VersionNumber, Local) { alert("undo: " + Spec + ";" + VersionNumber); }
// function BeforeRename(SrcSafeIni, UserName, Spec, VersionNumber, NewName) { alert("BeforeRename"); }
function AfterRename(SrcSafeIni, UserName, Spec, VersionNumber, OldName) { alert("rename: " + Spec + ";" + VersionNumber + "←" + OldName); }
// function BeforeBranch(SrcSafeIni, UserName, Spec, VersionNumber, Comment) { alert("BeforeBranch"); }
function AfterBranch(SrcSafeIni, UserName, Spec, VersionNumber, Comment) { alert("branch: " + Spec + ";" + VersionNumber); }
