#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>
#include <shellapi.h>

#include <string>

#include "exception.h"

struct NotifyArea {
private:
	NOTIFYICONDATA *notifyicondata;
public:
	NotifyArea(void) : notifyicondata(nullptr) { }
	~NotifyArea(void) { ClearIcon(); }
	void ClearIcon(void) {
		if (notifyicondata) {
			::Shell_NotifyIcon(NIM_DELETE, notifyicondata);
		}
	}
	void SetIcon(NOTIFYICONDATA *const n) {
		if (notifyicondata != n) {
			if (notifyicondata) {
				if (!::Shell_NotifyIcon(NIM_DELETE, notifyicondata)) {
					throw _win32_error(::GetLastError());
				}
			}
			if (n) {
				if (!::Shell_NotifyIcon(NIM_ADD, notifyicondata = n)) {
					throw _win32_error(::GetLastError());
				}
			}
		} else {
			if (!::Shell_NotifyIcon(NIM_MODIFY, notifyicondata)) {
				throw _win32_error(::GetLastError());
			}
		}
	}
};
