#pragma once

#include <string>
#include <list>
#include <sstream>

inline void strcopy(const std::wstring &src, wchar_t *dst, size_t dstsize) {
	if (dstsize > 0) {
		wchar_t *p = dst;
		wchar_t *q = dst + dstsize - 1;
		for (auto i = src.begin(); (i != src.end()) && (p < q); ++i, ++p) {
			*p = *i;
		}
		*p = L'\0';
	}
}

struct InfoList {
private:
	struct Mssg {
		const std::wstring text;
		unsigned int count;
		Mssg(std::wstring s) : text(s), count(1) { }
	};
	std::list<Mssg> mssgs;

	std::wstring GetText(void) const {
		std::wostringstream result;
		for (auto i = mssgs.begin(); i != mssgs.end(); ++i) {
			if (!result.str().empty()) {
				result << L"\r\n";
			}
			result << i->text;
			if (i->count > 1) {
				result << L" x" << i->count;
			}
		}
		return result.str();
	}
public:
	const size_t MaxLength;

	std::wstring AddText(std::wstring text) {
		if (text.empty()) {
			//
		} else if (mssgs.empty() || (mssgs.back().text != text)) {
			mssgs.push_back(Mssg(text));
		} else {
			++(mssgs.back().count);
		}
		std::wstring result;
		while (!mssgs.empty()) {
			result = GetText();
			if (result.length() < MaxLength) return result;
			mssgs.pop_front();
		}
		return std::wstring();
	}

	InfoList(size_t maxLength) : MaxLength(maxLength) { }
};
