#pragma once

#if !defined(WIN32_LEAN_AND_MEAN)
#	define WIN32_LEAN_AND_MEAN
#endif
#if !defined(VC_EXTRALEAN)
#	define VC_EXTRALEAN
#endif
#if !defined(STRICT)
#	define STRICT
#endif

#include <windows.h>
#include <comdef.h>

inline void _com_check(const HRESULT hr) { if (FAILED(hr)) throw _com_error(hr); }

template<typename T> inline void _com_check(const HRESULT hr, T u) {
	if (FAILED(hr)) {
		_com_ptr_t<_com_IIID<ISupportErrorInfo, &IID_ISupportErrorInfo>> s;
		HRESULT h;
		h = u->QueryInterface(&s);
		if (FAILED(h)) throw _com_error(hr);
		h = s->InterfaceSupportsErrorInfo(u.GetIID());
		if (h != S_OK) throw _com_error(hr);
		_com_ptr_t<_com_IIID<IErrorInfo, &IID_IErrorInfo>> e;
		h = ::GetErrorInfo(0, &e);
		if (FAILED(h)) throw _com_error(hr);
		throw _com_error(hr, e.Detach());
	}
}

struct _win32_error : _com_error {
	explicit _win32_error(const DWORD gle) throw () : _com_error(HRESULT_FROM_WIN32(gle)), GetLastError(gle) { }
	const DWORD GetLastError;
};
