#pragma once

#include "StdAfx.h"

#include <comdef.h>
#include <comip.h>

#include "SSAPI.h"
#include "exception.h"
#include "unknown.h"
#include "EventHandlerImpl.h"

class EventHandler : public IClassFactory, public UnknownImpl {
public:
	HRESULT __stdcall QueryInterface(REFIID riid, void **ppv) throw() try {
		if (!ppv) throw _com_error(E_POINTER);
		*ppv = nullptr;
		if (::IsEqualIID(riid, IID_IUnknown)) { 
			*ppv = static_cast<IUnknown *>(this);
		} else if (::IsEqualIID(riid, IID_IClassFactory)) {
			*ppv = static_cast<IClassFactory *>(this);
		} else {
			throw _com_error(E_NOINTERFACE);
		}
		this->AddRef();
		return S_OK;
	} catch (_com_error &hr) {
		return hr.Error();
	} catch (...) {
		return E_UNEXPECTED;
	}

	ULONG __stdcall AddRef(void) throw() { return UnknownImpl::AddRef(); }

	ULONG __stdcall Release(void) throw() { return UnknownImpl::Release(); }

	HRESULT __stdcall CreateInstance(IUnknown *pUnkOuter, REFIID riid, void **ppv) throw() try {
		if (!ppv) throw _com_error(E_POINTER);
		*ppv = nullptr;
		if (pUnkOuter) throw _com_error(CLASS_E_NOAGGREGATION);
		EventHandlerImpl *instance = new EventHandlerImpl();
		instance->AddRef();
		HRESULT hr = instance->QueryInterface(riid, ppv);
		instance->Release();
		return hr;
	} catch (_com_error &hr) {
		return hr.Error();
	} catch (...) {
		return E_UNEXPECTED;
	}
	
	HRESULT __stdcall LockServer(BOOL fLock) throw() try {
		return S_OK;
	} catch (_com_error &hr) {
		return hr.Error();
	} catch (...) {
		return E_UNEXPECTED;
	}
};
