/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __TCHAR_H__
#define __TCHAR_H__


#include "windef.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* ja:基本 */
#ifdef UNICODE
# define _T(utf8str) w32ldr_tchar_to_wc(utf8str)
typedef gint16  TCHAR,  *TPCHAR,  *TLPCHAR,  *TCHAR_PTR;
typedef guint16 TUCHAR, *TPUCHAR, *TLPUCHAR, *TUCHAR_PTR;
#else /* not UNICODE */
# define _T(utf8str) w32ldr_tchar_to_mb(utf8str)
typedef gint8   TCHAR,  *TPCHAR,  *TLPCHAR,  *TCHAR_PTR;
typedef guint8  TUCHAR, *TPUCHAR, *TLPUCHAR, *TUCHAR_PTR;
#endif /* not UNICODE */
/* ja:文字列 */
typedef TCHAR           *PTSTR,   *LPTSTR;
typedef CONST TCHAR     *PCTSTR,  *LPCTSTR;


/*  ja:UTF-8をMultiByteに変換する
    utf8str,UTF-8
        RET,MultiByte                                                       */
gchar *
w32ldr_tchar_to_mb (gchar *utf8str);


/*  ja:UTF-8をUTF-16に変換する
    utf8str,UTF-8
        RET,UTF-16                                                          */
gunichar2 *
w32ldr_tchar_to_wc (gchar *utf8str);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __TCHAR_H__ */
