/*
    avicore
    copyright (c) 1999-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Wave                                                                        *
*                                                                             *
******************************************************************************/
#ifndef __WAVE_H__
#define __WAVE_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif


#define WAVE_FORMAT_PCM 1


#define WFX_SIZE 18


#ifdef USE_GCC


typedef struct WaveFormatEx_Tag {
	guint16 format_tag __attribute__((packed));
	guint16 channels __attribute__((packed));
	guint32 samples_per_sec __attribute__((packed));
	guint32 average_bytes_per_sec __attribute__((packed));
	guint16 block_align __attribute__((packed));
	guint16 bits_per_sample __attribute__((packed));
	guint16 size __attribute__((packed));
} WaveFormatEx;


#else


typedef struct { guint8 dummy[WFX_SIZE]; } WaveFormatEx;


#endif


/******************************************************************************
*                                                                             *
* ¤Υޥ                                                                *
*                                                                             *
******************************************************************************/
#define wfx_get_format_tag(wfx) GUINT16_FROM_LE(*(guint16 *)(wfx))
#define wfx_get_channels(wfx) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(wfx)+2))
#define wfx_get_samples_per_sec(wfx)										\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(wfx)+4))
#define wfx_get_average_bytes_per_sec(wfx)									\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(wfx)+8))
#define wfx_get_block_align(wfx)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(wfx)+12))
#define wfx_get_bits_per_sample(wfx)										\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(wfx)+14))
#define wfx_get_size(wfx) GUINT16_FROM_LE(*(guint16 *)((guint8 *)(wfx)+16))
#define wfx_set_format_tag(wfx,format_tag)									\
								(*(guint16 *)(wfx))=GUINT16_TO_LE(format_tag))
#define wfx_set_channels(wfx,channels)										\
					(*(guint16 *)((guint8 *)(wfx)+2)=GUINT16_TO_LE(channels))
#define wfx_set_samples_per_sec(wfx,samples_per_sec)						\
			(*(guint32 *)((guint8 *)(wfx)+4)=GUINT32_TO_LE(samples_per_sec))
#define wfx_set_average_bytes_per_sec(wfx,average_bytes_per_sec)			\
		(*(guint32 *)((guint8 *)(wfx)+8)=GUINT32_TO_LE(average_bytes_per_sec))
#define wfx_set_block_align(wfx,block_align)								\
				(*(guint16 *)((guint8 *)(wfx)+12)=GUINT16_TO_LE(block_align))
#define wfx_set_bits_per_sample(wfx,bits_per_sample)						\
			(*(guint16 *)((guint8 *)(wfx)+14)=GUINT16_TO_LE(bits_per_sample))
#define wfx_set_size(wfx,size)												\
						(*(guint16 *)((guint8 *)(wfx)+16)=GUINT16_TO_LE(size))


/******************************************************************************
*                                                                             *
* Waveޥ                                                                  *
*                                                                             *
******************************************************************************/
/*	WaveFormatEx¤ΤȤ³ǡΥХȿ
	wfx,WaveFormatEx¤ΤؤΥݥ
	RET,Хȿ															*/
#define wf_header_bytes(wfx) (wfx_get_size(wfx)+WFX_SIZE)


#ifdef __cplusplus
}
#endif
#endif
