/*
    avicore
    copyright (c) 2000-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "avibase.h"
#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif


/******************************************************************************
*                                                                             *
* Խؿ(줿)                                                            *
*                                                                             *
******************************************************************************/
/*	AVI
	avi_edit,AVIԽϥɥ
	   start,Ϥ륵ץֹ
	 samples,ץ
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_delete(AviEdit *avi_edit,const gint start,const gint samples)
{
	gint i,j=0,samples_n;
	AviFile *p,*q,*r;

	/* Ȱ֤ȥץĴ */
	if (avi_edit==NULL || start<0)
		return FALSE;
	samples_n=MIN(avi_edit->length-start,samples);
	if (samples_n<=0 || avi_edit->length<=samples_n)
		return FALSE;
	/* å */
	for (i=0;i<AVI_EDIT_CACHE && avi_edit->buf[i]!=NULL;i++)
		if (start<=avi_edit->pos[i] && avi_edit->pos[i]<start+samples_n) {
			g_free(avi_edit->buf[i]);
			avi_edit->buf[i]=NULL;
		} else if (start+samples_n<=avi_edit->pos[i]) {
			avi_edit->pos[i]-=samples_n;
		}
	for (i=0;i<AVI_EDIT_CACHE;i++)
		if (avi_edit->buf[i]!=NULL) {
			avi_edit->pos[j]=avi_edit->pos[i];
			avi_edit->buf[j]=avi_edit->buf[i];
			j++;
		}
	while (j<AVI_EDIT_CACHE)
		avi_edit->buf[j++]=NULL;

	avi_split_file(avi_edit,start);/* AVIեʬ䤹 */
	p=avi_edit->file;
	if (start+samples_n<avi_edit->length) {
		/* ֤ʬ䤹 */
		avi_split_file(avi_edit,start+samples_n);
		q=avi_edit->file;
	} else {
		/* ޤǺ */
		q=NULL;
	}
	/* ֤˰ư */
	while (start-1<avi_edit->offset && avi_edit->file->prev!=NULL) {
		avi_edit->file=avi_edit->file->prev;
		avi_edit->offset-=avi_edit->file->length;
	}
	while (p!=q) {
		if (avi_edit->file==p)
			avi_edit->file=avi_edit->file->next;
		if (p->prev!=NULL)
			p->prev->next=p->next;
		if (p->next!=NULL)
			p->next->prev=p->prev;
		r=p->next;
		avi_release_file(p);
		p=r;
	}
	/* ץ򸺤餹 */
	avi_edit->length-=samples_n;
	return TRUE;
}


/*	AVI򥳥ԡ
	avi_edit,AVIԽϥɥ
	   start,ԡϤ륵ץֹ
	 samples,ץ
	     RET,AVIԽϥɥ,NULL:顼									*/
AviEdit *avi_copy(AviEdit *avi_edit,const gint start,const gint samples)
{
	gint start_n,samples_n;
	AviEdit *avi_copy;
	AviFile *avi_file;

	/* Ȱ֤ȥץĴ */
	if (avi_edit==NULL || start<0)
		return NULL;
	samples_n=MIN(avi_edit->length-start,samples);
	if (samples_n<=0 || avi_edit->length<samples_n)
		return NULL;

	avi_get_file(avi_edit,start);/* AVIե */

	/*  */
	avi_copy=g_malloc(sizeof(AviEdit));
	avi_copy->offset=0;
	avi_copy->type=avi_edit->type;	/* streamtypeAUDIO/streamtypeVIDEO */
	avi_copy->length=0;				/* ץ */
	avi_copy->rate=avi_edit->rate;
	avi_copy->scale=avi_edit->scale;	/* ratescale=1ô֤Υե졼 */
	avi_copy->file=NULL;
	/* ӥǥͭ */						/* ŸΥեޥå */
	avi_copy->bmih=avi_edit->bmih!=NULL?g_memdup(avi_edit->bmih,
										bm_header_bytes(avi_edit->bmih)):NULL;
	g_memset(avi_copy->buf,0,AVI_EDIT_CACHE*sizeof(gpointer));/* å */
	/* ǥͭ */					/* ŸΥեޥå */
	avi_copy->wfx=avi_edit->wfx!=NULL?g_memdup(avi_edit->wfx,
										wf_header_bytes(avi_edit->wfx)):NULL;

	start_n=start;
	while (samples_n>0) {
		/* ԡ */
		avi_file=g_malloc(sizeof(AviFile));

		if (avi_edit->file->fd!=-1) {
			if ((avi_file->fd=open(avi_edit->file->name,O_RDONLY))==-1)
				avi_file->fd=dup(avi_edit->file->fd);
			else
				flock(avi_file->fd,LOCK_SH);
		} else {
			avi_file->fd=-1;
		}
		avi_file->data=avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL
									?g_memdup(avi_edit->file->data,
									bm_image_bytes(avi_edit->file->bmih)):NULL;
		avi_file->name=g_strdup(avi_edit->file->name);
		avi_file->start=start_n-avi_edit->offset+avi_edit->file->start;
		avi_file->length
			=MIN(avi_edit->file->length-(start_n-avi_edit->offset),samples_n);
		avi_file->entries=avi_edit->file->entries;
		avi_file->param=avi_edit->file->param;
		avi_file->index=g_memdup(avi_edit->file->index,
									avi_edit->file->entries*sizeof(AviIndex));
		avi_file->handler=avi_edit->file->handler;
		avi_file->bmih=avi_edit->file->bmih!=NULL
												?g_memdup(avi_edit->file->bmih,
								bm_header_bytes(avi_edit->file->bmih)):NULL;
		avi_file->wfx=avi_edit->file->wfx!=NULL?g_memdup(avi_edit->file->wfx,
									wf_header_bytes(avi_edit->file->wfx)):NULL;
		/* ꥹȤ */
		avi_copy->length+=avi_file->length;
		avi_file->prev=avi_copy->file;
		avi_file->next=NULL;
		if (avi_copy->file!=NULL) {
			avi_copy->file->next=avi_file;
			avi_copy->offset+=avi_copy->file->length;
		}
		avi_copy->file=avi_file;
		/*  */
		if (avi_edit->file->next!=NULL) {
			avi_edit->offset+=avi_edit->file->length;
			avi_edit->file=avi_edit->file->next;
		}
		start_n+=avi_file->length;
		samples_n-=avi_file->length;
	}
	return avi_copy;
}


/*	AVIŽդ
	avi_dst,ŽդAVIԽϥɥ
	    pos,Žդ륵ץֹ
	avi_src,ŽդAVIԽϥɥ
	    RET,TRUE:ｪλ,FALSE:顼										*/
gboolean avi_paste(AviEdit *avi_dst,const gint pos,AviEdit *avi_src)
{
	gint i,length;
	AviFile *p,*q;

	/* 㤦ޤϰϳʤХ顼 */
	if (avi_dst==NULL || avi_src==NULL || avi_dst->type!=avi_src->type
											|| pos<0 || avi_dst->length<pos)
		return FALSE;
	if (avi_dst->type==streamtypeAUDIO) {
		/* ǥ */
		length=wf_header_bytes(avi_dst->wfx);
		if (length!=wf_header_bytes(avi_src->wfx)
							|| g_memcmp(avi_dst->wfx,avi_src->wfx,length)!=0)
			return FALSE;/* եޥåȤۤʤ */
	}
	/* å */
	for (i=0;i<AVI_EDIT_CACHE && avi_dst->buf[i]!=NULL;i++)
		if (pos<=avi_dst->pos[i])
			avi_dst->pos[i]+=avi_src->length;
	if (pos<avi_dst->length) {
		/* Žդ֤ʬ䤹 */
		avi_split_file(avi_dst,pos);
		p=avi_dst->file->prev;
		q=avi_dst->file;
	} else {
		/* Žդ */
		while (avi_dst->file->next!=NULL) {
			avi_dst->offset+=avi_dst->file->length;
			avi_dst->file=avi_dst->file->next;
		}
		p=avi_dst->file;
		q=NULL;
	}
	/* Ƭذư */
	while (avi_src->file->prev!=NULL)
		avi_src->file=avi_src->file->prev;
	avi_src->file->prev=p;
	if (p!=NULL)
		p->next=avi_src->file;
	/* ذư */
	while (avi_src->file->next!=NULL)
		avi_src->file=avi_src->file->next;
	avi_src->file->next=q;
	if (q!=NULL)
		q->prev=avi_src->file;
	/* ꥹȤΥեåȤꤹ */
	if (pos<=avi_dst->offset)
		avi_dst->offset+=avi_src->length;
	/* ץäŽդ˴ */
	avi_dst->length+=avi_src->length;
	g_free(avi_src->bmih);
	for (i=0;i<AVI_EDIT_CACHE;i++)
		g_free(avi_src->buf[i]);
	g_free(avi_src->wfx);
	g_free(avi_src);
	/* Ŭ */
	if (p!=NULL && p->name!=NULL && p->next->name!=NULL
									&& g_strcmp(p->name,p->next->name)==0
									&& p->start+p->length==p->next->start) {
		p->length+=p->next->length;
		p=p->next;
		if (avi_dst->file==p) {
			avi_dst->file=avi_dst->file->prev;
			avi_dst->offset-=avi_dst->file->length;
		}
		if (p->prev!=NULL)
			p->prev->next=p->next;
		if (p->next!=NULL)
			p->next->prev=p->prev;
		avi_release_file(p);
	}
	if (q!=NULL && q->name!=NULL && q->prev->name!=NULL
								&& g_strcmp(q->name,q->prev->name)==0
								&& q->prev->start+q->prev->length==q->start) {
		if (avi_dst->file==q) {
			avi_dst->file=avi_dst->file->prev;
			avi_dst->offset-=avi_dst->file->length;
		}
		q->prev->length+=q->length;
		if (q->prev!=NULL)
			q->prev->next=q->next;
		if (q->next!=NULL)
			q->next->prev=q->prev;
		avi_release_file(q);
	}
	return TRUE;
}
