package gnu.rfb.server;

import gnu.awt.Rectangle;

import java.util.*;
import java.io.*;

/**
* Manages a group of RFB clients with individual properties.
**/

public class RFBClients
{
	//
	// Construction
	//
	
	public RFBClients()
	{
	}
	
	//
	// Operations
	//
	
	public boolean isEmpty()
	{
		return clients.isEmpty();
	}
	
	public void addClient( RFBClient client )
	{
		clients.put( client, new Hashtable<String,Object>() );
	}
	
	public void removeClient( RFBClient client )
	{
		clients.remove( client );
	}
	
	public void closeAll()
	{
		RFBClient client;
		for( Enumeration<RFBClient> e = elements(); e.hasMoreElements(); )
		{
			client = (RFBClient) e.nextElement();
			try
			{
				client.close();
			}
			catch( IOException x )
			{
			}
		}
		
		clients.clear();
	}
	
	public Enumeration<RFBClient> elements()
	{
		return clients.keys();
	}
	
	public void setQueue( RFBClient client, Vector<Rectangle> queue ) {
		setProperty(client, "queue", queue);
	}

	public void setState( RFBClient client, Object state ) {
		setProperty(client, "events", state);
	}

	@Deprecated
	public void setProperty( RFBClient client, String key, Object value )
	{
		Hashtable<String,Object> properties = (Hashtable<String,Object>) clients.get( client );
		if( properties == null )
			return;
		
		properties.put( key, value );	
	}
	
	public Vector<Rectangle> getQueue( RFBClient client ) {
		return (Vector<Rectangle>)getProperty( client, "queue" );
	}
	
	public Object getState( RFBClient client ) {
		return getProperty( client, "events" );
	}
	
	@Deprecated
	public Object getProperty( RFBClient client, String key )
	{
		Hashtable<String,Object> properties = (Hashtable<String,Object>) clients.get( client );
		if( properties == null )
			return null;
		
		return properties.get( key );	
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	// Private

	Hashtable<RFBClient,Hashtable<String,Object>> clients = new Hashtable<RFBClient,Hashtable<String,Object>>();
}
