#ifndef UNDOMGR_H
#define UNDOMGR_H

#include <QUndoStack>
#include <QColor>
#include <QFont>
#include <QPointF>

class Scene;
class Node;


class UndoMgr : public QUndoStack
{
	Q_OBJECT

public:
	UndoMgr(QObject *parent = 0);
	~UndoMgr();

private:
	
};
//----------------------------------------------------------------------
//	m[h폜
class UndoDeleteNodeCommand : public QUndoCommand
{
public:
	UndoDeleteNodeCommand(Scene *scene, Node *node);
	~UndoDeleteNodeCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	폜ꂽm[h
	int		m_index;			//	Ԗڂ̌Z킩 (0..*)
};
#if 0
//	em[hǉ
class UndoAddParentNodeCommand : public QUndoCommand
{
public:
	UndoAddParentNodeCommand(Scene *scene, Node *node, int index);
	~UndoAddParentNodeCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_parentNode;		//	m[h̐em[h
	Node	*m_node;			//	m[h
	int		m_index;			//	Ԗڂ̌Z킩 (0..*)
};
#endif
//	m[hǉ
class UndoAddNodeCommand : public QUndoCommand
{
public:
	UndoAddNodeCommand(Scene *scene, Node *node, int index);
	~UndoAddNodeCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	폜ꂽm[h
	int		m_index;			//	Ԗڂ̌Z킩 (0..*)
};
//	m[hړ
class UndoMoveNodeUpCommand : public QUndoCommand
{
public:
	UndoMoveNodeUpCommand(Scene *scene, Node *node);
	~UndoMoveNodeUpCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	ړm[h
};
//	m[hړ
class UndoMoveNodeDownCommand : public QUndoCommand
{
public:
	UndoMoveNodeDownCommand(Scene *scene, Node *node);
	~UndoMoveNodeDownCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	ړm[h
};
//	m[hWύX
class UndoChangeNodePosCommand : public QUndoCommand
{
public:
	UndoChangeNodePosCommand(Scene *scene, Node *node, const QPointF &pos)
		: m_scene(scene), m_node(node), m_pos(pos)
	{}
	~UndoChangeNodePosCommand() {};
	
public:
	void	undo() { undoRedo(); }
	void	redo() { undoRedo(); }

protected:
	void	undoRedo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	ړm[h
	QPointF	m_pos;				//	ʒu
};
//	m[hړ
class UndoMoveNodeCommand : public QUndoCommand
{
public:
	UndoMoveNodeCommand(Scene *scene, Node *node,
						Node *sp, bool, int si, Node *dp, bool = true, int di = -1);
	~UndoMoveNodeCommand() {};
	
public:
	void	undo();
	void	redo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	ړm[h
	Node	*m_srcPN;			//	ړem[h
	bool	m_srcIsRS;			//	m[h̉EH
	int		m_srcIx;			//	ړqԍi0..*j
	Node	*m_dstPN;			//	ړem[h
	bool	m_dstIsRS;			//	m[h̉EH
	int		m_dstIx;			//	ړqԍi0..*j
};
//	NύX
class UndoLinkNodeCommand : public QUndoCommand
{
public:
	UndoLinkNodeCommand(Scene *scene, Node *node, const QString &linkText);
	~UndoLinkNodeCommand() {};
	
public:
	void	undo() { undoRedo(); }
	void	redo() { undoRedo(); }

protected:
	void	undoRedo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	m[h
	QString	m_linkText;
};
//	wiFύX
class UndoColorNodeCommand : public QUndoCommand
{
public:
	UndoColorNodeCommand(Scene *scene, Node *node, QColor color)
		: m_scene(scene), m_node(node), m_color(color) {}
	~UndoColorNodeCommand() {};
	
public:
	void	undo() { undoRedo(); }
	void	redo() { undoRedo(); }

protected:
	void	undoRedo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	m[h
	QColor	m_color;
};
//	tHgύX
class UndoFontNodeCommand : public QUndoCommand
{
public:
	UndoFontNodeCommand(Scene *scene, Node *node, QFont font, bool macro = false)
		: m_scene(scene), m_node(node), m_font(font), m_macro(macro) {}
	~UndoFontNodeCommand() {};
	
public:
	void	undo() { undoRedo(); }
	void	redo() { undoRedo(); }

protected:
	void	undoRedo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	m[h
	QFont	m_font;
	bool	m_macro;
};
//----------------------------------------------------------------------
//	m[heLXgC
class UndoEditNodeTextCommand : public QUndoCommand
{
public:
	UndoEditNodeTextCommand(Scene *scene, Node *node,
						const QString &text)
		: m_scene(scene)
		, m_node(node)
		, m_text(text)
		{}
	~UndoEditNodeTextCommand() {};
	
public:
	void	undo() { doUndoRedo(); }
	void	redo() { doUndoRedo(); }

protected:
	void	doUndoRedo();

private:
	Scene	*m_scene;
	Node	*m_node;			//	ړm[h
	QString	m_text;
};

#endif // UNDOMGR_H
