#include <QtGui>
#include "View.h"
#include "Scene.h"
#include <QDebug>

View::View(QGraphicsScene * scene, QWidget *parent)
	: QGraphicsView(scene, parent)
	//, m_scale(1.0)
{
	m_rotateAngle = 0;
	//scale(m_scale, m_scale);
	//setAcceptDrops(true);		//	hbvt for t@Chbv
	//setAcceptDrops(false);		//	hbvt֎~
}

View::~View()
{

}
//	zoomIn/Outi{s{j
void View::viewScale(qreal s)
{
	scale(s, s);
	//qDebug() << transform();
	QTransform tf = transform();
	const qreal m11 = tf.m11();
	showMessage(tr("view scale:%1%").arg(m11*100), 5*1000);
}
void View::viewRotateReset()
{
	QTransform ctf = transform();
	QTransform tf;
	tf.scale(ctf.m11(), ctf.m22());		//	XP[͂̂܂
	setTransform(tf);
}
void View::viewScaleReset()
{
	QTransform tf = transform();
	tf.scale(1/tf.m11(), 1/tf.m22());
	setTransform(tf);
}
void View::viewZoomIn()
{
	viewScale(1.05);
}
void View::viewZoomOut()
{
	viewScale(1/1.05);
}
void View::viewAutoZoom()
{
	QRectF br = dynamic_cast<Scene *>(scene())->nodeBoundingRect();
}
void View::wheelEvent ( QWheelEvent * event )
{
	const bool ctrl = (event->modifiers() & Qt::ControlModifier) != 0;
	const bool shift = (event->modifiers() & Qt::ShiftModifier) != 0;
	const bool alt = (event->modifiers() & Qt::AltModifier) != 0;
	if( !alt && ctrl && !shift ) {
		//qDebug() << event->delta();
		const qreal s = event->delta() > 0 ? 1.05 : 1/1.05;
		viewScale(s);
		return;
	}
	if( !alt && !ctrl && shift ) {		//	Z̉]
		m_rotateAngle = event->delta() > 0 ? 5 : -5;
#if 0
		QTransform tf = transform();
		tf.rotate(m_rotateAngle, Qt::YAxis);
		setTransform(tf);
#else
		rotate(m_rotateAngle);
#endif
		//showMessage(tr("rotate %1 degrees").arg(m_rotateAngle));
		return;
	}
	if( !alt && ctrl && shift ) {		//	Ỷ]
		m_rotateAngle = event->delta() > 0 ? 5 : -5;
		QTransform tf = transform();
		tf.rotate(m_rotateAngle, Qt::YAxis);
		setTransform(tf);
		return;
	}
	if( alt && shift && !ctrl ) {		//	X̉]
		m_rotateAngle = event->delta() > 0 ? 5 : -5;
		QTransform tf = transform();
		tf.rotate(m_rotateAngle, Qt::XAxis);
		setTransform(tf);
		return;
	}
	QGraphicsView::wheelEvent( event );
	//event->ignore();
}
void View::fullScreen(bool b)
{
	if( b )
		viewport()->showFullScreen();
	else
		viewport()->showNormal();
}
#if 0
void View::dragEnterEvent ( QDragEnterEvent * event )
{
	if( event->mimeData()->hasFormat("text/uri-list") ) {
		event->acceptProposedAction();
		qDebug() << "View::dragEnterEvent()";
		event->accept();
	}
}
void View::dragMoveEvent ( QDragEnterEvent * event )
{
	qDebug() << "View::dragMoveEvent()";
	if( event->mimeData()->hasFormat("text/uri-list") ) {
		event->acceptProposedAction();
		event->accept();
		qDebug() << "View::dragMoveEvent() accept()";
	}
}
void View::dropEvent ( QDropEvent * event )
{
	qDebug() << "View::dropEvent()";
	QList<QUrl> fileList = event->mimeData()->urls();
	foreach(QUrl url, fileList) {
		QString filePath = QDir::toNativeSeparators(url.toLocalFile());
		qDebug() << filePath;
	}
}
#endif
