#include "SingleApplication.h"
#include <QtGui>
//#ifdef	WIN32
//#include <windows.h>
//#endif

SingleApplication::SingleApplication(int &argc, char *argv[], const QString uniqKeyString)
	: m_connected(false), m_uniqKeyString(uniqKeyString), QApplication(argc, argv)
{
	connect(&m_localServer, SIGNAL(newConnection()), this, SLOT(onAccepted()));
}

bool SingleApplication::isFirstApp()
{
	m_localSocket.connectToServer(m_uniqKeyString);
	if( m_localSocket.waitForConnected(200) ) {
		return false;
	} else {
		m_localServer.listen(m_uniqKeyString);
		return true;
	}
}
void SingleApplication::onAccepted()
{
	QLocalSocket *sock = m_localServer.nextPendingConnection();
	connect(sock, SIGNAL(readyRead()), this, SLOT(readBuffer()));
	connect(sock, SIGNAL(disconnected()), sock, SLOT(deleteLater()));
}

void SingleApplication::readBuffer()
{
	QLocalSocket *sock = qobject_cast<QLocalSocket *>(sender());
	QByteArray ba = sock->readAll();
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	QString buff = codec->toUnicode(ba);
	emit onRecieved(buff);
}
//	ŏɋNꂽCX^XփbZ[WM
void SingleApplication::sendMessage(const QString &text)
{
	m_localSocket.write(text.toUtf8());
	m_localSocket.flush();
	if( !m_localSocket.waitForBytesWritten(1000) ) {
		//	operation timed out, or an error occurred
		return;
	}
}
