/*
 * @file  dest.c
 * @brief the realserver information management component 
 * @brief it operates realserver infomation struct
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include "logger_wrapper.h"
#include "l7vs_dest.h"

/*!
 * create struct dest
 * @param[in]   *addr     sockaddr_in
 * @param[in]   weight    source int
 * @param[in]   forward   forward type
 * @return      struct l7vs_dest *
 */
struct l7vs_dest *
l7vs_dest_create(struct sockaddr_in *addr, int weight, enum l7vs_dest_forward_type forward)
{
        char dest_str[DEBUG_STR_LEN] = {0};
        struct l7vs_dest *dest;
	char addr_str[DEBUG_STR_LEN] = {0};


        if (LOG_LV_DEBUG == logger_get_log_level(LOG_CAT_L7VSD_REAL_SERVER)) {
		l7vs_dest_sockaddr_in_c_str(addr_str,addr);
                LOGGER_PUT_LOG_DEBUG(LOG_CAT_L7VSD_REAL_SERVER,9,
                        "in_function: struct l7vs_dest * l7vs_dest_create"
                        "(struct sockaddr_in *addr, int weight, enum l7vs_dest_forward_type forward)"
                        "addr = %s, weight = %d, forward = %d",
                        addr_str, weight, forward);
        }

        dest = (struct l7vs_dest *)malloc(sizeof(*dest));
        if (dest == NULL) {
		LOGGER_PUT_LOG_ERROR(LOG_CAT_L7VSD_SYSTEM_MEMORY,7,"dest create : Could not allocate memory");
                return dest;
        }

        if (LOG_LV_DEBUG == logger_get_log_level(LOG_CAT_L7VSD_SYSTEM_MEMORY)) {
                LOGGER_PUT_LOG_DEBUG(LOG_CAT_L7VSD_SYSTEM_MEMORY,1,
                        "in_function l7vs_dest_create:allocate memory"
			" : size=%ld , pointer=%p",
                        sizeof(*dest),dest);
        }

        dest->addr = *addr;
        dest->weight = weight;
        dest->forward = forward;
        dest->nactive = dest->ninact = 0;

        l7vs_dest_c_str(dest_str, dest);
        LOGGER_PUT_LOG_INFO(LOG_CAT_L7VSD_REAL_SERVER,3,"RealServer Information: %s",dest_str);

        if (LOG_LV_DEBUG == logger_get_log_level(LOG_CAT_L7VSD_REAL_SERVER)) {
                l7vs_dest_c_str(dest_str, dest);
                LOGGER_PUT_LOG_DEBUG(LOG_CAT_L7VSD_REAL_SERVER,10,
                        "pointer_assign: dest=%s",
                        dest_str);
        }


#if 0
        mss = l7vs_dest_get_mss(addr);
        if (mss < 0) {
                free(dest);
                return NULL;
        }
        dest->mss = mss;
#endif
	

        return dest;
}

/*!
 * destroy struct dest
 * @param[in]   *dest   l7vs_dest
 * @return      void
 */
void
l7vs_dest_destroy(struct l7vs_dest *dest)
{
        char dest_str[DEBUG_STR_LEN] = {0};

       	if (LOG_LV_DEBUG == logger_get_log_level(LOG_CAT_L7VSD_REAL_SERVER)) {
               	l7vs_dest_c_str(dest_str, dest);
                LOGGER_PUT_LOG_DEBUG(LOG_CAT_L7VSD_REAL_SERVER,11,
                        "in_function: void l7vs_dest_create(struct l7vs_dest *dest)"
			"dest = %s",
                        dest_str);
       	}

        l7vs_dest_c_str(dest_str, dest);
        LOGGER_PUT_LOG_INFO(LOG_CAT_L7VSD_REAL_SERVER,4,"RealServer Information: %s",dest_str);

        free(dest);
	dest = NULL;
}

/*!
 * create struct l7vs_dest_arg
 * @param[in]   *dest  l7vs_dest
 * @param[in]   *darg  l7vs_dest_arg
 * @return      void
 */
void
l7vs_dest_to_arg(struct l7vs_dest *dest, struct l7vs_dest_arg *darg)
{
	if(darg != NULL && dest != NULL)
	{
        	darg->addr = dest->addr;
        	darg->weight = dest->weight;
        	darg->forward = dest->forward;
        	darg->nactive = dest->nactive;
        	darg->ninact = dest->ninact;
	}
       	if (LOG_LV_DEBUG == logger_get_log_level(LOG_CAT_L7VSD_REAL_SERVER)) {
                	char dest_str[DEBUG_STR_LEN] = {0};
                	char darg_str[DEBUG_STR_LEN] = {0};
                	l7vs_dest_c_str(dest_str, dest);
                	l7vs_darg_c_str(darg_str, darg);
                	LOGGER_PUT_LOG_DEBUG(LOG_CAT_L7VSD_REAL_SERVER,12,
			"in_function: void l7vs_dest_to_arg(struct l7vs_dest *dest, struct l7vs_dest_arg *darg)"
                        "dest=%s: "
			"darg=%s",
                       	dest_str,darg_str);
       	}
}

