/*!
 * @file l7vs_dest.h
 * @brief RealServer component.
 * @brief 
 *
 *
 */

#ifndef	L7VS_DEST_H
#define	L7VS_DEST_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include "logger_wrapper.h"

// ! real-server forward type
enum	l7vs_dest_forward_type{
	L7VS_DEST_FORWARD_MASQ		= 0,	//!  Masquarade
	L7VS_DEST_FORWARD_TPROXY	= 1	//!  Transparent Proxy
};

//
// ! real-server datatype
//
//
struct	l7vs_dest{
	struct sockaddr_in           addr;    //! sockaddr
	int                          weight;  //! schedule weight use
	enum l7vs_dest_forward_type  forward; //! forward mode
	int                          nactive; //! nactive
	int                          ninact;  //! ninactive
};

//
// ! real-server datatype, external representation
//
//
struct	l7vs_dest_arg{
	struct sockaddr_in           addr;
	int                          weight;
	enum l7vs_dest_forward_type  forward;
	int                          nactive;
	int                          ninact;
};

//
// functions.
//
extern	struct l7vs_dest*	l7vs_dest_create( struct sockaddr_in*, int, enum l7vs_dest_forward_type );
extern	void			l7vs_dest_destroy( struct l7vs_dest* );
extern	void			l7vs_dest_to_arg( struct l7vs_dest*, struct l7vs_dest_arg* );

/*!
 * serialize struct sockaddr_in
 * @param[out]  ret     serialized string
 * @param[in]   dest    source sockaddr_in
 * @return      void
 */
inline	void	l7vs_dest_sockaddr_in_c_str(char* ret, const struct sockaddr_in* addr)
{
        if (!addr) {
                snprintf(ret, DEBUG_STR_LEN, "(nil)");
                return;
        }

        snprintf(ret, DEBUG_STR_LEN,
                "sockaddr_in="
                "{sin_addr=%s: "
                "sin_port=%d}"
                , inet_ntoa(addr->sin_addr)
                , ntohs(addr->sin_port));
}


/*!
 * serialize struct l7vs_dest
 * @param[out]  ret     serialized string
 * @param[in]   dest    source l7vs_dest
 * @return      void
 */
inline	void	l7vs_dest_c_str(char *ret,const struct l7vs_dest *dest)
{
	char addr_str[DEBUG_STR_LEN];

	if(!dest){
		snprintf(ret, DEBUG_STR_LEN, "(nil)");
		return;
	}

	l7vs_dest_sockaddr_in_c_str(addr_str,&(dest->addr));
	snprintf(ret, DEBUG_STR_LEN,
		"dest = %p: "
		"addr = %s: "
		"weight= %d: "
		"forward= %d: "
		"nactive= %d: "
		"ninact= %d: ",
		dest,
		addr_str,
		dest->weight,
		dest->forward,
		dest->nactive,
		dest->ninact);
}

/*!
 * serialize struct l7vs_darg
 * @param[out]  ret     serialized string
 * @param[in]   dest    source l7vs_dest_arg
 * @return      void
 */
inline	void	l7vs_darg_c_str(char *ret,const struct l7vs_dest_arg *darg)
{
	char addr_str[DEBUG_STR_LEN];

	if(!darg){
		snprintf(ret, DEBUG_STR_LEN, "(nil)");
		return;
	}

	l7vs_dest_sockaddr_in_c_str(addr_str,&(darg->addr));
	snprintf(ret, DEBUG_STR_LEN,
		"addr = %s: "
		"weight= %d: "
		"forward= %d: "
		"nactive= %d: "
		"ninact= %d: ",
		addr_str,
		darg->weight,
		darg->forward,
		darg->nactive,
		darg->ninact);
}

#endif	//L7VS_DEST_H
