/*!
 * @file @l7vs_iom.h
 * @bried Iom is controlled.  
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2005  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/
#ifndef	L7VS_IOM_H
#define	L7VS_IOM_H

// I/O multiplexing support
//#define	L7VS_IOMUX_READ         0x0001
//#define L7VS_IOMUX_WRITE        0x0002
//#define L7VS_IOMUX_EXCEPT       0x0004

enum	iomaction{
	iom_read	= 0,
	iom_write	= 1,
	iom_hup		= 3
};

enum	iomstatus{
	iomux_none	= 0,
	iomux_create,
	iomux_disabled,

	//config_common
	iomux_config_init,					//! config before initialize
	iomux_config_initialized,				//! config was initialized
	iomux_config_command_waiting,				//! command waiting
	iomux_config_command_response_sent,			//! command response sent
	iomux_config_signal_received,				//! signal received
	iomux_config_destroyed,					//! config finishing process was executed

	//config_list_vs
	iomux_config_command_list_vs_received,			//! LIST_VS command received
	iomux_config_command_list_vs_succeeded,			//! LIST_VS command succeeded

	//config_list_rs
	iomux_config_command_list_rs_received,			//! LIST_RS command received
	iomux_config_command_list_rs_vs_found,			//! virtual service was found
	iomux_config_command_list_rs_succeeded,			//! LIST_RS command succeeded

	//config_add_vs
	iomux_config_command_add_vs_received,			//! ADD_VS command received
	iomux_config_command_add_vs_vs_not_found,		//! virtual service was not found
	iomux_config_command_add_vs_lsock_not_found,		//! listening socket was not found
	iomux_config_command_add_vs_lsock_created,		//! listening socket was created
	iomux_config_command_add_vs_lsock_got,			//! listening socket got
	iomux_config_command_add_vs_protomod_not_found,		//! protocol module was not found
	iomux_config_command_add_vs_protomod_loaded,		//! protocol module was loaded
	iomux_config_command_add_vs_protomod_got,		//! protocol module got
	iomux_config_command_add_vs_sched_not_found,		//! schedule module was not found
	iomux_config_command_add_vs_sched_loaded,		//! schedule module was loaded
	iomux_config_command_add_vs_sched_got,			//! schedule module got
	iomux_config_command_add_vs_pmod_created,		//! protocol module was created
	iomux_config_command_add_vs_dup_checked,		//! virtual service duplication check done
	iomux_config_command_add_vs_vs_created,			//! virtual service has created
	iomux_config_command_add_vs_succeeded,			//! ADD_VS command succeeded

	//config_del_vs
	iomux_config_command_del_vs_received,			//! DEL_VS command received
	iomux_config_command_del_vs_vs_found,			//! virtual service was found
	iomux_config_command_del_vs_dest_destroyed,		//! destination was destroyed
	iomux_config_command_del_vs_succeeded,			//! DELVS command succeeded

	//config_edit_vs
	iomux_config_command_edit_vs_received,			//! EDIT_VS command received
	iomux_config_command_edit_vs_vs_found,			//! virtual serveice was found
	iomux_config_command_edit_vs_sched_not_found,		//! schedule module not found
	iomux_config_command_edit_vs_sched_loaded,		//! schedule module was loaded
	iomux_config_command_edit_vs_sched_got,			//! schedule module got
	iomux_config_command_edit_vs_succeeded,			//! EDIT_VS command succeeded

	//config_add_rs
	iomux_config_command_add_rs_received,			//! ADD_RS command received
	iomux_config_command_add_rs_vs_found,			//! virtual servece was found
	iomux_config_command_add_rs_rs_not_found,		//! real server was not found
	iomux_config_command_add_rs_succeeded,			//! ADD_RS command succeeded

	//config_del_rs
	iomux_config_command_del_rs_received,			//! DEL_RS command recdeived
	iomux_config_command_del_rs_vs_found,			//! virtual service was found
	iomux_config_command_del_rs_rs_found,			//! real service was found
	iomux_config_command_del_rs_succeeded,			//! DEL_RS command succeeed

	//config_edit_rs
	iomux_config_command_edit_rs_received,			//! EDIT_RS command received
	iomux_config_command_edit_rs_rs_found,			//! real service found
	iomux_config_command_edit_rs_vs_found,			//! virtual service found
	iomux_config_command_edit_rs_succeeded,			//! EDIT_RS command succeeded

	//config_flush_vs
	iomux_config_command_flush_vs_received,			//! FLUSH_VS command received
	iomux_config_command_flush_vs_succeeded,		//! FLUSH_VS command succeeded

	//config_sync_initialize
	iomux_config_command_sync_initialize_received,		//! SYNC_INIT command received
	iomux_config_command_sync_initialize_succeeded,		//! SYNC_INIT command succeeded

	//config_sync_initialize
	iomux_config_command_sync_finalize_received,		//! SYNC_FINI command received
	iomux_config_command_sync_finalize_succeeded,		//! SYNC_FINI command succeeded

	//config_error
	iomux_config_command_recv_error,			//! command receive error
	iomux_config_command_nomem_error,			//! no memory error
	iomux_config_command_novs_error,			//! virtual service was not found error
	iomux_config_command_nors_error,			//! real server was not found error
	iomux_config_command_vs_exist_error,			//! virtual service already exist error
	iomux_config_command_rs_exist_error,			//! real service already exist error
	iomux_config_command_nosock_error,			//! listening socket was not found error
	iomux_config_command_noprotomod_error,			//! protocol module was not found error
	iomux_config_command_nosched_error,			//! scheduler module was not found error
	iomux_config_command_vs_create_error,			//! virtual service create error
	iomux_config_command_set_qos_error,			//! set qos error
	iomux_config_command_set_sorry_server_error,		//! set sorry server error

	//lsock_initialize
	iomux_lsock_init,					//! listening socket before initialize
	iomux_lsock_initalized,					//! listening socket was initialized

	//lsock_create
	iomux_lsock_not_found,					//! listening socket was not found
	iomux_lsock_created,					//! listening socket was created
	iomux_lsock_got,					//! listening socket got

	//lsock_connect_waiting
	iomux_lsock_connect_waiting,				//! wait for client connection
	iomux_lsock_accepted,					//! listening socket was accepted
	iomux_lsock_conn_created,				//! connection was created

	//lsock_destroy
	iomux_lsock_released,					//! listeing socket was released
	iomux_lsock_destroyed,					//! listeing socket was destroyed

	//lsock_error
	iomux_lsock_create_error,				//! listening socket error
	iomux_lsock_conn_create_error,				//! create conn error

	//conn_initialize
	iomux_conn_init,					//! connection befor initialize
	iomux_conn_created,					//! connection was created

	//conn_data_excahnge
	iomux_conn_receive_ready,				//! data receive ready
	iomux_conn_receiving,					//! data receiving now 
	iomux_conn_received,					//! data receiving finished
	iomux_conn_send_ready,					//! data sending ready
	iomux_conn_send_ready_busy,				//! data sending ready and was connected
	iomux_conn_sending,					//! data sending
	iomux_conn_sending_busy,				//! data sending and  was connected
	iomux_conn_sent,					//! data sent
	iomux_conn_sent_busy,					//! data send and was connected

	//conn_data_read_control
	iomux_conn_block,					//! can not receive nor sent becase of buffer in use
	iomux_conn_busy,					//! connect action happened during block state

	//conn_process_status
	iomux_conn_dest_absent,					//! destination was absent
	iomux_conn_dest_decided,				//! destination was decided
	iomux_conn_service_selected,				//! virtual service was selected
	iomux_conn_rs_connected,				//! real server was connected
	iomux_conn_rsdata_modified,				//! data from real server was modified

	//conn_disconnected
	iomux_conn_disconnected,				//! connection was disconnected

	//conn_destroy
	iomux_conn_destroyed,					//! connection was destroyed

	//conn_error
	iomux_conn_create_error,				//! create connection error
	iomux_conn_buffer_realloc_error,			//! buffer re-allocation error

	iomux_conn_receive_error,				//! data receive error
	iomux_conn_send_error,					//! data send error
	iomux_conn_rs_connect_error,				//! real server connect error
	iomux_conn_rsdata_modify_error,				//! data from real server modify error

	//sync_send
	iomux_sync_sending,					//! sending data

	//sync_recv
	iomux_sync_receving,					//! recevind data

	//sync_error
	iomux_sync_modeerr,					//! mode error 

	//sync__destroy
	iomux_sync_destroy,					//! sync finish

	//replication_status
	iomux_replication_sending,				//! replication data is sending
	iomux_replication_receving,				//! replication data is reciveing
	iomux_replication_send_wait,				//! replication data is send wait
	iomux_replication_recv_wait,				//! replication data is recv wait
	iomux_replication_send_stop,				//! send is stop
	iomux_replication_recv_stop,				//! recive is stop
	iomux_replication_out,					//! mode is nothing


	// snmpbridge_status
	iomux_snmp_waiting,					//! snmp connection waiting
	iomux_snmp_receive_ready,				//! snmp data receive ready
	iomux_snmp_send_ready,				//! snmp data send ready

	//replication_status
	iomux_replication_error,				//! mode error

	//sync__destroy
	iomux_replication_destroy				//! sync finish

};

struct	l7vs_iomux{
	int	fd;
	int	(*callback)(struct l7vs_iomux* iom );
	enum	iomstatus status;
	void*	data;
};

#endif	//L7VS_IOM
