/*
 * @file  sslproxysession.h
 * @brief SSLproxy session Header
 *
 * Copyright (C) 2008  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************
 *
 * Distributed under the Boost Software Licence, Version 1.0
 * http://www.boost.org/LICENSE_1_0.txt
 *
 **********************************************************************/

#ifndef __SSLPROXYSESSION_H__
#define __SSLPROXYSESSION_H__

#include <boost/asio.hpp>
#include <boost/asio/ssl.hpp>
#include <boost/thread.hpp>

//! SSL socket for client.
typedef boost::asio::ssl::stream<boost::asio::ip::tcp::socket>	ssl_socket;

//! TCP socket for server. (target)
typedef boost::asio::ip::tcp::socket	nomal_socket;

class sslproxy_session
{
protected:
	nomal_socket					server_socket;
	ssl_socket					client_socket;
	boost::asio::ip::tcp::resolver::iterator	endpoint_iterator;
	boost::asio::deadline_timer			timer;
	int 						cancel_time;
	char						client_buffer[MAX_BUFFER_SIZE];
	char						server_buffer[MAX_BUFFER_SIZE];
	bool						handshaked;
	bool						istimeout;
	bool						c_r_event;
	bool						c_w_event;
	bool						s_r_event;
	bool						s_w_event;
	bool						finishing;
	pthread_mutex_t					client_socket_mutex;
	boost::asio::deadline_timer			cache_timer;

public:
	// constructor
	sslproxy_session(boost::asio::io_service& ioservice,
			 boost::asio::ssl::context& context,
			 boost::asio::ip::tcp::resolver::iterator itr);
	// destructor
	~sslproxy_session();
	// Low level socket getting function.
	ssl_socket::lowest_layer_type& low_socket();
	// Get remote endpoint (client address:port) function.
	std::string get_remote_endpoint() const;
	// Session start function
	void start();
	// Timer cancel function.
	void cancel(const boost::system::error_code& error);
	// Cache expire function.
	void cache_expire(const boost::system::error_code& error);
	// Session destroy function.
	void destroy_session(sslproxy_session* session);
	// Handshake handling function.
	void handle_handshake(const boost::system::error_code& error);
	// Connect handling function.
	void handle_connect(const boost::system::error_code& error);
	// Client read handling function.
	void handle_client_read(const boost::system::error_code& error, size_t bytes_transferred);
	// Server write handling function.
	void handle_server_write(const boost::system::error_code& error, size_t bytes_transferred);
	// Server read handling function.
	void handle_server_read(const boost::system::error_code& error, size_t bytes_transferred);
	// Client write handling function.
	void handle_client_write(const boost::system::error_code& error, size_t bytes_transferred);
    // Edit client message function.
	void edit_client_message(size_t& bytes_transferred);
    // Edit server message function.
	void edit_server_message(size_t& bytes_transferred);
};

#endif //__SSLPROXYSESSION_H__
