/*
 * @file  sslproxyserver.h
 * @brief SSLproxy server Header
 *
 * Copyright (C) 2008  NTT COMWARE Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************
 *
 * Distributed under the Boost Software Licence, Version 1.0
 * http://www.boost.org/LICENSE_1_0.txt
 *
 **********************************************************************/

#ifndef __SSLPROXYSERVER_H__
#define __SSLPROXYSERVER_H__

#include "sslproxy.h"
#include "sslproxysession.h"

//! SSLproxy session management table.
extern std::map<long, int> sessionTable;
extern pthread_mutex_t sessionTable_mutex;

class sslproxy_server
{
protected:
	boost::asio::io_service&			sslservice;
	boost::asio::ip::tcp::acceptor			sslacceptor;
	boost::asio::ssl::context			sslcontext;
	boost::asio::ip::tcp::resolver::iterator	target_endpoint_iterator;
	std::string					private_key_passwd;
public:
	// constructor
	sslproxy_server(boost::asio::io_service& io_service,
			boost::asio::ip::tcp::resolver::iterator target_itr,
			boost::asio::ip::tcp::endpoint recv_endpoint);
	// destructor
	~sslproxy_server();
	// Get password callback function.
	std::string get_password();
	// Acception handling function.
	void handle_accept(sslproxy_session* session, const boost::system::error_code& error);
};

#endif //__SSLPROXYSERVER_H__
