package org.ultramonkey.l7.view;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;
import org.ultramonkey.l7.controller.*;

/**
 * 
 * <p>
 * class LogOutputServlet
 * </p>
 * <p>
 * Copyright(c) NTT COMWARE 2008
 * </p>
 * 
 * @author kubota
 */
public class LogOutputServlet extends org.ultramonkey.l7.view.L7guiServletBase {
	static final long serialVersionUID = 1L;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public LogOutputServlet() {
		super();
        // --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11363 class LoginServlet created.");
        }
        // --- debug log (constructor) ---
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
			buf.append("LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
			buf.append("request=(" + request + "), ");
			buf.append("response=(" + response + ")");
			logger.debug("11364 " + buf.toString());
			request.setCharacterEncoding("UTF-8");
			logger.debug("11365 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		// check login session
		super.doPost(request, response);

		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41093, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11366 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

        request.setCharacterEncoding("UTF-8");
		String logType = request.getParameter("type");
		String logFile = request.getParameter("log");
		
		if (logType == null || logFile == null) {
			MessageView error = new MessageView(41094, LogCategorySet.GUI_LOG,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11367 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		Vector<LogFileData> logList = null;

		L7guiFramework frameWork = new L7guiFramework();
		LogData log = frameWork.getLogData();

		try {
			if (logType.equals(LogCategorySet.L7VSD)) {
				logList = log.lbLog.logFiles;
			} else if (logType.equals(LogCategorySet.L7VSADM)) {
				logList = log.admLog.logFiles;
			} else if (logType.equals(LogCategorySet.L7DIRECTORD)) {
				logList = log.directorLog.logFiles;
			} else if (logType.equals(LogCategorySet.SNMPAGENT)) {
				logList = log.snmpLog.logFiles;
			} else if (logType.equals(LogCategorySet.L7GUI)) {
				logList = log.guiLog.logFiles;
			} else if (logType.equals(LogCategorySet.SYNC)) {
				logList = log.syncLog.logFiles;
			} else if (logType.equals(LogCategorySet.HA)) {
				logList = log.haLog.logFiles;
			} else {
				MessageView error = new MessageView(41095, LogCategorySet.GUI_LOG,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11368 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		} catch (NullPointerException e) {
			MessageView error = new MessageView(41096, LogCategorySet.GUI_LOG, 
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11369 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		if (logList == null) {
			MessageView error = new MessageView(41097, LogCategorySet.GUI_LOG,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11370 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
		String dwLogFilePath = null;
		boolean matchFlag = false;
		
		for (int i = 0; i < logList.size(); i++) {
			if (logList.get(i).fileName.equals(logFile)) {
				dwLogFilePath = logList.get(i).filePath;
				matchFlag = true;
				break;
			}
		}
		if ((matchFlag == false) || (dwLogFilePath == null)) {
			MessageView error = new MessageView(41098, LogCategorySet.GUI_LOG,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11371 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}

		// Log File DownLoad
		File file = new File(dwLogFilePath);
		BufferedInputStream in = null;
		BufferedOutputStream out = null;
		try {
			// HTTP HEADER OUT
			response.setContentType("application/octet-stream");
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ file.getName() + "\"");
			response.setContentLength((int) file.length());

			in = new BufferedInputStream(new FileInputStream(file));
			out = new BufferedOutputStream(response.getOutputStream());

			byte buf[] = new byte[1024];
			int len;

			while ((len = in.read(buf)) != -1) {
				out.write(buf, 0, len);
			}
		} catch (SocketException e) {
			// nothing to do
		} catch (Exception e) {
			// HTTP HEADER RESET
			response.reset();
			response.sendError(HttpURLConnection.HTTP_INTERNAL_ERROR, e.toString());
		} finally {
			if (in != null) {
				in.close();
			}
			if (out != null) {
				out.flush();
				out.close();
			}
		}
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11372 LogOutputServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;

	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request,
	 *      HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("LogOutputServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11373 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11374 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11375 LogOutputServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}
}