package org.ultramonkey.l7.model;

import java.io.Serializable;

import org.apache.log4j.Logger;

/**
 * <p>class UserData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author nakai
 */
public class UserData implements Serializable {
    static final long serialVersionUID = 1L;

    public String userName = null;
    public String passwd = null;
    public int acl = -1;
	public String description = null;

	/**
	 * 
	 * Constructor
	 *
	 */
	public UserData() {
        // --- debug log (constructor) ---
	    Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
        if (userLogger.isDebugEnabled()) {
            userLogger.debug("11080 class UserData created.");
        }
        // --- debug log (constructor) ---
		this.userName = null;
		this.passwd = null;
		this.acl = -1;
		this.description = null;
	}

	public UserData(UserData copy) {
        // --- debug log (constructor) ---
	    Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
        if (userLogger.isDebugEnabled()) {
            userLogger.debug("11081 class UserData created.");
        }
        // --- debug log (constructor) ---
        if (copy.userName != null)
        	this.userName = copy.userName;
        if (copy.passwd != null)
        	this.passwd = copy.passwd;
        if (copy.description != null)
        	this.description = copy.description;
		this.acl = copy.acl;
	}
	
	/**
	 * 
	 * <p> equals method</p>
	 *
	 * @param user
	 * @return
	 */
	public boolean equals(UserData user) {
		// --- debug log (in method) ---
	    Logger userLogger = Logger.getLogger(LogCategorySet.GUI_USER_MANAGE);
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11082 Parameter::equals(UserData user) in user=(" + user + ")");
		}
		// --- debug log (in method) ---

		if (user != null && 
				this.userName.equals(user.userName) &&
				this.passwd.equals(user.passwd) &&
				this.acl == user.acl) {
			// --- debug log (out method) ---
			if (userLogger.isDebugEnabled()) {
	            userLogger.debug("11083 Parameter::equals(UserData user) return=true");
			}
			// --- debug log (out method) ---
			return true;
		}
		// --- debug log (out method) ---
		if (userLogger.isDebugEnabled()) {
            userLogger.debug("11084 Parameter::equals(UserData user) return=false");
		}
		// --- debug log (out method) ---
		return false;
	}
	
	public String toString() {
		return
			"userName=\"" + this.userName + "\", " + 
			"passwd=\"" + this.passwd + "\", " +
			"acl=" + this.acl + ", " +
			"description=\"" + this.description + "\""; 
	}
}
