package org.ultramonkey.l7.controller;

import java.io.*;
import java.util.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.LogCategorySet;

/**
 * /usr/sbin/l7directored control class
 * 
 * @author nakai
 * @versin 1.0
 * 
 */
public class DirectorController implements Serializable {
	static final long serialVersionUID = 1L;
	
	private final String l7directord = "/usr/sbin/l7directord";

	protected String filename = "";

	protected String CHECKTIMEOUT_KEY = "checktimeout";

	protected String CHECKINTERVAL_KEY = "checkinterval";
	
	protected String CHECKCOUNT_KEY = "checkcount";

	protected String FALLBACK_KEY = "fallback";

	protected String AUTORELOAD_KEY = "autoreload";

	protected String EXECUTE_KEY = "execute";
	
	protected String LOGFILE_KEY = "logfile";

	protected String QUIESCENT_KEY = "quiescent";

	protected String CALLBACK_KEY = "callback";

	protected String NEGOTIATE_TIMEOUT_KEY = "negotiatetimeout";

	protected String SUPERVISED_KEY = "supervised";

	protected String VIRTUAL_KEY = "virtual";

	protected String CHECKTYPE_KEY = "checktype";

	protected String CHECKPORT_KEY = "checkport";

	protected String MAXCONN_KEY = "maxconn";

	protected String MODULE_KEY = "module";

	protected String PROTOCOL_KEY = "protocol";

	protected String QOSCLIENTS_KEY = "qosclients";

	protected String QOSSERVICE_KEY = "qosservice";

	protected String RECEIVE_KEY = "receive";

	protected String SERVICE_KEY = "service";

	protected String REAL_KEY = "real";

	protected String REQUEST_KEY = "request";

	protected String SCHEDULER_KEY = "scheduler";

	protected String SORRYSERVER_KEY = "sorryserver";

	protected String HTTPMETHOD_KEY = "httpmethod";

	protected String VIRTUALHOST_KEY = "virtualhost";

	protected String PASSWORD_KEY = "passwd";

	protected String LOGIN_KEY = "login";
	
	protected String DATABASE_KEY = "database";

	protected String REALDOWNCALLBACK_KEY = "realdowncallback";

	protected String REALRECOVERCALLBACK_KEY = "realrecovercallback";

	/**
	 * pair class
	 * <p>
	 * class pair
	 * </p>
	 * <p>
	 * Copyright(c) NTT COMWARE 2008
	 * </p>
	 * 
	 * @author kubota
	 */
	protected class Pair<E, N> {
		protected E elementFirst;

		protected N elementSecond;

		public Pair(E firstIn, N secondIn) {
			elementFirst = firstIn;
			elementSecond = secondIn;
		}

		public void set(E firstIn, N secondIn) {
			elementFirst = firstIn;
			elementSecond = secondIn;
		}

		public E first() {
			return elementFirst;
		}

		public N second() {
			return elementSecond;
		}
	}

	protected Pair<String, String> paseKey(String inLine) {
		if (inLine == null)
			return null;
		int pos = inLine.indexOf("=");
		if (pos == -1)
			return new Pair(inLine, "");
		String first = inLine.substring(0, pos);
		String second = inLine.substring(pos + 1, inLine.length());
		if (first.indexOf('#') != -1)
			return new Pair<String, String>("", "");
		if (second.indexOf('#') != -1) {
			pos = second.indexOf('#');
			second = second.substring(0, pos);
		}
		first = first.trim();
		second = second.trim();
		Pair<String, String> pair = new Pair<String, String>(first, second);
		return pair;
	}

	protected boolean serchfile() {
		// sengenbasyo kentou yousu
		final String confname = "l7directord.cf";
		final String confdir1 = "/etc/ha.d/";
		final String confdir2 = "/etc/ha.d/conf/";
		String conf = confdir1 + confname;
		File objFile = new File(conf);
		if (!objFile.exists()) {
			conf = confdir2 + confname;
			objFile = new File(conf);
			if (!objFile.exists()) {
				return false;
			}
		}
		if (!objFile.isFile()) {
			return false;
		}
		filename = objFile.getPath();
		return true;
	}
	
	private static String trimQuote(String s) {
		if (s != null && s.matches("^\".*\"$")) {
			s = s.substring(1, s.length() - 1);
		}
		return s;
	}

	protected DirectorData loadFromFile()
			throws org.ultramonkey.l7.model.FileNotReadException {
		DirectorData data;
		try {
			java.io.FileReader file = new java.io.FileReader(filename);
			java.io.BufferedReader reader = new java.io.BufferedReader(file);
			String buffer;
			data = new DirectorData();
			Stack<String> stack = new Stack<String>();
			int position = 0;
			while ((buffer = reader.readLine()) != null) {
				buffer = buffer.replaceAll("\\s+$", "");
				buffer = buffer.replaceAll("\\t", "    ");
				if (buffer.length() == 0 || buffer.matches("^\\s*#.*"))
					continue;
				if (buffer.indexOf(VIRTUAL_KEY) == 0)
					position++;
				stack.push(buffer);
			}
			String tmpGlobalLogFile = "";
			String tmpGlobalExecute = "";
			boolean tmpGlobalAutoreaload = false;
			String tmpGlobalCallback = "";
			String tmpGlobalFallback = "";
			String tmpGlobalCheckInterval = "";
			String tmpGlobalCheckTimeOut = "";
			String tmpGlobalCheckCount = "";
			String tmpGlobalNegotiateTimeOut = "";
			String tmpGlobalQuiescent = "";
			String tmpGlobalSupervised = "no";
			String tmpCheckTimeOut = "";
			String tmpCheckCount = "";
			String tmpNegotiateTimeOut = "";
			String tmpQuiescent = "";
			String tmpQosClients = "";
			String tmpQosService = "";
			String tmpSorryServer = "";
			String tmpMaxConn = "";
			String tmpProtocol = "";
			String tmpScheduler = "";
			String tmpReceive = "";
			String tmpRequest = "";
			String tmpService = "";
			String tmpModule = "";
			Vector<String> tmpReal = new Vector<String>();
			String tmpCheckType = "";
			String tmpCheckport = "";
			String tmpHttpMethod = "";
			String tmpVirtualHost = "";
			String tmpPassword = "";
			String tmpLogin = "";
			String tmpDatabase = "";
			String tmpRealDownCallback = "";
			String tmpRealRecoverCallback = "";
			while (!stack.empty()) {
				buffer = stack.pop();
				if (buffer.indexOf(AUTORELOAD_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					if (pair.second().indexOf("yes") != -1)
						tmpGlobalAutoreaload = true;
					else
						tmpGlobalAutoreaload = false;
				}
				if (buffer.indexOf(CALLBACK_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalCallback = trimQuote(pair.second());
				} else if (buffer.indexOf(CHECKTIMEOUT_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalCheckTimeOut = pair.second();
				} else if (buffer.indexOf(CHECKINTERVAL_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalCheckInterval = pair.second();
				} else if (buffer.indexOf(CHECKCOUNT_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalCheckCount = pair.second();
				} else if (buffer.indexOf(FALLBACK_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalFallback = pair.second();
				} else if (buffer.indexOf(EXECUTE_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalExecute = trimQuote(pair.second());
				} else if (buffer.indexOf(LOGFILE_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalLogFile = trimQuote(pair.second());
				} else if (buffer.indexOf(NEGOTIATE_TIMEOUT_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalNegotiateTimeOut = pair.second();
				} else if (buffer.indexOf(QUIESCENT_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					tmpGlobalQuiescent = pair.second();
				} else if (buffer.indexOf(SUPERVISED_KEY) == 0) {
					tmpGlobalSupervised = "yes";
				} else if (buffer.indexOf(CHECKTIMEOUT_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpCheckTimeOut = pair.second();
				} else if (buffer.indexOf(CHECKCOUNT_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpCheckCount = pair.second();
				} else if (buffer.indexOf(NEGOTIATE_TIMEOUT_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpNegotiateTimeOut = pair.second();
				} else if (buffer.indexOf(QUIESCENT_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpQuiescent = pair.second();
				} else if (buffer.indexOf(CHECKTYPE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpCheckType = pair.second();
				} else if (buffer.indexOf(CHECKPORT_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpCheckport = pair.second();
				} else if (buffer.indexOf(MAXCONN_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpMaxConn = pair.second();
				} else if (buffer.indexOf(MODULE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpModule = pair.second();
				} else if (buffer.indexOf(PROTOCOL_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpProtocol = pair.second();
				} else if (buffer.indexOf(QOSCLIENTS_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpQosClients = pair.second();
				} else if (buffer.indexOf(QOSSERVICE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpQosService = pair.second();
				} else if (buffer.indexOf(REAL_KEY) >= 4
						&& buffer.indexOf(REALRECOVERCALLBACK_KEY) == -1
						&& buffer.indexOf(REALDOWNCALLBACK_KEY) == -1) {
					Pair<String, String> pair = paseKey(buffer);
					String real = pair.second();
					tmpReal.add(real);
				} else if (buffer.indexOf(RECEIVE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpReceive = trimQuote(pair.second());
				} else if (buffer.indexOf(REQUEST_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpRequest = trimQuote(pair.second());
				} else if (buffer.indexOf(SCHEDULER_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpScheduler = pair.second();
				} else if (buffer.indexOf(SERVICE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpService = trimQuote(pair.second());
				} else if (buffer.indexOf(HTTPMETHOD_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpHttpMethod = pair.second();
				} else if (buffer.indexOf(VIRTUALHOST_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpVirtualHost = trimQuote(pair.second());
				} else if (buffer.indexOf(PASSWORD_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpPassword = trimQuote(pair.second());
				} else if (buffer.indexOf(LOGIN_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpLogin = trimQuote(pair.second());
				} else if (buffer.indexOf(DATABASE_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpDatabase = trimQuote(pair.second());
				} else if (buffer.indexOf(SORRYSERVER_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpSorryServer = pair.second();
				} else if (buffer.indexOf(REALDOWNCALLBACK_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpRealDownCallback = trimQuote(pair.second());
				} else if (buffer.indexOf(REALRECOVERCALLBACK_KEY) >= 4) {
					Pair<String, String> pair = paseKey(buffer);
					tmpRealRecoverCallback = trimQuote(pair.second());
				} else if (buffer.indexOf(VIRTUAL_KEY) == 0) {
					Pair<String, String> pair = paseKey(buffer);
					VirtualSetting vs = new VirtualSetting();
					int pos = pair.second().indexOf(":");
					vs.virtual.host = pair.second().substring(0, pos);
					vs.virtual.port = pair.second().substring(pos + 1,
							pair.second().length());
					if (! vs.virtual.port.matches("^\\d+$"))
						vs.virtual.port = GetServ.byName(vs.virtual.port, "tcp");
					for (Iterator<String> itr = tmpReal.iterator(); itr
							.hasNext();) {
						String realstr = itr.next();
						pos = realstr.indexOf(":");
						EndPoint ed = new EndPoint();
						ed.host = realstr.substring(0, pos);
						int spacepos = realstr.lastIndexOf(" ");
						String tmpWeight = "";
						if (spacepos == -1) {
							ed.port = realstr.substring(pos + 1, realstr
									.length());
						} else {
							ed.port = realstr.substring(pos + 1, spacepos).replaceAll(" masq", "");
							tmpWeight = realstr.substring(spacepos + 1, realstr
									.length());
						}
						if (! ed.port.matches("^\\d+$"))
							ed.port = GetServ.byName(ed.port, "tcp");

						if (tmpWeight.length() != 0) {
							try {
								ed.weight = Integer.parseInt(tmpWeight);
							} catch (java.lang.NumberFormatException e) {
								ed.weight = 1;
							}
						}
						vs.real.add(ed);
					}
					vs.checktype = tmpCheckType;
					if (tmpMaxConn.length() != 0)
						vs.maxconn = Integer.parseInt(tmpMaxConn);
					pos = tmpModule.indexOf(" ");
					if (pos != -1) {
						vs.protomod = tmpModule.substring(0, pos);
						vs.option = tmpModule
								.substring(pos + 1, tmpModule.length());
					} else {
						vs.protomod = tmpModule;
						vs.option = "";
					}
					vs.protocol = tmpProtocol;
					if (tmpQosClients.length() != 0) {
						if ((pos = tmpQosClients.indexOf('k')) != -1
								|| (pos = tmpQosClients.indexOf('K')) != -1) {
							vs.qosclient = Long.parseLong(tmpQosClients
									.substring(0, pos));
							vs.qosclient = vs.qosclient * 1000;
						} else if ((pos = tmpQosClients.indexOf('M')) != -1
								|| (pos = tmpQosClients.indexOf('m')) != -1) {
							vs.qosclient = Long.parseLong(tmpQosClients
									.substring(0, pos));
							vs.qosclient = vs.qosclient * 1000000;
						} else {
							vs.qosclient = Long.parseLong(tmpQosClients);
						}
					}
					// QoSService
					if (tmpQosService.length() != 0) {
						if ((pos = tmpQosService.indexOf('K')) != -1
								|| (pos = tmpQosService.indexOf('k')) != -1) {
							vs.qosservice = Long.parseLong(tmpQosService
									.substring(0, pos));
							vs.qosservice = vs.qosservice * 1000;
						} else if ((pos = tmpQosService.indexOf('M')) != -1
								|| (pos = tmpQosService.indexOf('m')) != -1) {
							vs.qosservice = Long.parseLong(tmpQosService
									.substring(0, pos));
							vs.qosservice = vs.qosservice * 1000000;
						} else {
							vs.qosservice = Long.parseLong(tmpQosService);
						}
					}
					vs.receive = tmpReceive;
					vs.service = tmpService;
					vs.request = tmpRequest;
					vs.sched = tmpScheduler;
					pos = tmpSorryServer.indexOf(":");
					if (pos != -1) {
						vs.sorryserver.host = tmpSorryServer.substring(0, pos);
						vs.sorryserver.port = tmpSorryServer.substring(pos + 1,
								tmpSorryServer.length());
						if (! vs.sorryserver.port.matches("^\\d+$"))
							vs.sorryserver.port = GetServ.byName(vs.sorryserver.port, "tcp");
					}
					vs.quiescent = tmpQuiescent;
					vs.upcallback = tmpRealRecoverCallback;
					vs.downcallback = tmpRealDownCallback;
					if (tmpCheckport.length() != 0)
						vs.checkport = Integer.parseInt(tmpCheckport);
					vs.httpmethod = tmpHttpMethod;
					vs.virtualhost = tmpVirtualHost;
					vs.login = tmpLogin;
					vs.database = tmpDatabase;
					vs.passwd = tmpPassword;
					if (tmpCheckType != null && 
							((tmpCheckType.equals("connect") || tmpCheckType.equals("ping")) ||
							 ((tmpCheckType.equals("negotiate") || tmpCheckType.matches("^\\d$")) &&
									 tmpService != null && (tmpService.equals("dns") || tmpService.equals("sip"))
									 )
							)
						) {
						if (tmpCheckTimeOut.matches("^\\d+$"))
							vs.timeout = Integer.parseInt(tmpCheckTimeOut);
					}
					else {
						if (tmpNegotiateTimeOut.matches("^\\d+$"))
							vs.timeout = Integer.parseInt(tmpNegotiateTimeOut);
					}
					if (tmpCheckCount.matches("^\\d+$"))
						vs.checkcount = Integer.parseInt(tmpCheckCount);
					vs.cfPosition = position;
					position--;
					data.virtualSettings.add(vs);
					tmpCheckTimeOut = "";
					tmpCheckCount = "";
					tmpNegotiateTimeOut = "";
					tmpQuiescent = "";
					tmpQosClients = "";
					tmpQosService = "";
					tmpSorryServer = "";
					tmpMaxConn = "";
					tmpProtocol = "";
					tmpScheduler = "";
					tmpReceive = "";
					tmpRequest = "";
					tmpService = "";
					tmpModule = "";
					tmpReal = new Vector<String>();
					tmpCheckType = "";
					tmpCheckport = "";
					tmpHttpMethod = "";
					tmpVirtualHost = "";
					tmpPassword = "";
					tmpLogin = "";
					tmpDatabase = "";
					tmpRealDownCallback = "";
					tmpRealRecoverCallback = "";
				}// keyif if
			}// while(stack)
			data.autoreload = tmpGlobalAutoreaload;
			data.callback = tmpGlobalCallback;
			data.checkCount = tmpGlobalCheckCount;
			data.checkInterval = tmpGlobalCheckInterval;
			data.checkTimeOut = tmpGlobalCheckTimeOut;
			data.fallback = tmpGlobalFallback;
			data.logfile = tmpGlobalLogFile;
			data.execute = tmpGlobalExecute;
			data.negotiateTimeOut = tmpGlobalNegotiateTimeOut;
			data.quiescent = tmpGlobalQuiescent;
			data.supervised = tmpGlobalSupervised;
		} catch (Exception e) {
			org.ultramonkey.l7.model.FileNotReadException ex = new org.ultramonkey.l7.model.FileNotReadException();
			throw ex;
		}

		return data;
	}

	/**
	 * 
	 * <p>
	 * buildNewConf method
	 * </p>
	 * 
	 * @param in
	 * @return new configuration lines
	 * @throws org.ultramonkey.l7.model.FileNotWriteException
	 */
	protected LinkedList<String> buildNewConf(DirectorData in)
			throws org.ultramonkey.l7.model.FileNotWriteException {
		LinkedList<String> datas = new LinkedList();
		try {
			java.io.FileReader file = new java.io.FileReader(filename);
			java.io.BufferedReader reader = new java.io.BufferedReader(file);
			String buffer;
			while ((buffer = reader.readLine()) != null) {
				datas.addLast(buffer);
			}
		} catch (Exception e) {
			org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
			ex.setErrMessage("Cannot open file : " + filename);
			throw ex;
		}

		try {
			HashMap<String, String> map = new HashMap<String, String>();
			map.put(CHECKTIMEOUT_KEY, in.checkTimeOut);
			map.put(CHECKINTERVAL_KEY, in.checkInterval);
			map.put(CHECKCOUNT_KEY, in.checkCount);
			map.put(FALLBACK_KEY, in.fallback);
			if (in.autoreload)
				map.put(AUTORELOAD_KEY, "yes");
			else
				map.put(AUTORELOAD_KEY, "no");
			if (in.logfile != null && in.logfile.length() > 0)
				map.put(LOGFILE_KEY, "\"" + in.logfile + "\"");
			else
				map.put(LOGFILE_KEY, null);
			if (in.execute != null && in.execute.length() > 0)
				map.put(EXECUTE_KEY, "\"" + in.execute + "\"");
			else
				map.put(EXECUTE_KEY, null);
			map.put(QUIESCENT_KEY, in.quiescent);
			if (in.callback != null && in.callback.length() > 0)
				map.put(CALLBACK_KEY, "\"" + in.callback + "\"");
			else
				map.put(CALLBACK_KEY, null);
			map.put(NEGOTIATE_TIMEOUT_KEY, in.negotiateTimeOut);
			if (in.supervised != null && in.supervised.equals("yes"))
				map.put(SUPERVISED_KEY, in.supervised);
			else
				map.put(SUPERVISED_KEY, null);

			// global datas
			for (Iterator<String> itr = map.keySet().iterator(); itr.hasNext();) {
				String key = itr.next();
				String value = map.get(key);
				int commentLines = 0;
				boolean inserted = false;
				for (int i = 0; i < datas.size(); ++i) {
					String line = datas.get(i);
					String buffer = line.replaceAll("\\s+$", "");
					if (buffer.length() == 0 || buffer.matches("^\\s*#.*")) {
						commentLines++;
						continue;
					}
					else if (buffer.indexOf(VIRTUAL_KEY) == 0) {
						if (value != null && value.length() > 0) {
							StringBuffer buf = new StringBuffer(key);
							if (! key.equals(SUPERVISED_KEY)) {
								buf.append("=");
								buf.append(value);
							}
							datas.add(i - commentLines, buf.toString());
						}
						inserted = true;
						break;
					}
					commentLines = 0;
					Pair<String, String> pair = paseKey(buffer);
					if (pair.first().equals(key)) {
						if (value == null || ! pair.second().equals(value)) {
							StringBuffer buf = new StringBuffer("#");
							buf.append(buffer);
							datas.set(i, buf.toString());
							if (value != null && value.length() > 0) {
								buf = new StringBuffer();
								buf.append(key);
								if (! key.equals(SUPERVISED_KEY)) {
									buf.append("=");
									buf.append(value);
								}
								datas.add(i, buf.toString());
							}
						}
						inserted = true;
						break;
					}
				}
				if (inserted == false) {
					if (value != null && value.length() > 0) {
						StringBuffer buf = new StringBuffer(key);
						if (! key.equals(SUPERVISED_KEY)) {
							buf.append("=");
							buf.append(value);
						}
						datas.add(buf.toString());
					}
				}
			}
			// virtual settings
			DirectorData currentData = null;
			currentData = this.loadFromFile();
			LinkedList<Integer> delVsPosition = new LinkedList<Integer>();
			LinkedList<VirtualSetting> addVs = new LinkedList<VirtualSetting>();
			for (Iterator<VirtualSetting> itr = in.virtualSettings
					.iterator(); itr.hasNext();) {
				VirtualSetting vs = itr.next();
				boolean sameFlag = false;
				for (Iterator<VirtualSetting> curItr = currentData.virtualSettings
						.iterator(); curItr.hasNext();) {
					VirtualSetting curVs = curItr.next();
					if (curVs.equals(vs)) {
						sameFlag = true;
						curVs.cfPosition = 0;
						break;
					}
				}
				if (sameFlag == false) {
					addVs.add(vs);
				}
			}
			for (Iterator<VirtualSetting> curItr = currentData.virtualSettings
					.iterator(); curItr.hasNext();) {
				VirtualSetting curVs = curItr.next();
				if (curVs.cfPosition != 0)
					delVsPosition.add(curVs.cfPosition);
			}

			int position = 0;
			int commentLines = 0;
			for (int i = 0; i < datas.size(); ++i) { 
				String buffer = datas.get(i);
				String line = buffer.replaceAll("\\s+$", "");
				if (line.length() == 0 || line.matches("^\\s*#.*")) {
					continue;
				}
				else if (buffer.indexOf(VIRTUAL_KEY) == 0) {
					position++;
					if (delVsPosition.contains(position)) {
						int vsStartLine = i;
						for (; i < datas.size(); ++i) {
							buffer = datas.get(i);
							line = buffer.replaceAll("\\s+$", "");
							if (line.length() == 0 || line.matches("^\\s*#.*")) {
								commentLines++;
								continue;
							}
							if (buffer.indexOf(VIRTUAL_KEY) == 0 && i != vsStartLine) {
								i -= 1 + commentLines;
								commentLines = 0;
								break;
							}
							commentLines = 0;
							StringBuffer buf = new StringBuffer("#");
							buf.append(datas.get(i));
							datas.set(i, buf.toString());
						}
					}
				}
			}
			for (VirtualSetting vs : addVs) {
				datas.add(VIRTUAL_KEY + "=" + vs.virtual.host
						+ ":" + vs.virtual.port);
				if (vs.real.size() != 0) {
					for (java.util.Iterator<EndPoint> realitr = vs.real
							.iterator(); realitr.hasNext();) {
						EndPoint endpoint = realitr.next();
						datas.add("\t" + REAL_KEY + "=" + endpoint.host
								+ ":" + endpoint.port + " masq "
								+ String.valueOf(endpoint.weight));
					}
				}
				if (vs.checktype.length() != 0)
					datas.add("\t" + CHECKTYPE_KEY + "=" + vs.checktype);
				if (vs.checkport != 0)
					datas.add("\t" + CHECKPORT_KEY + "=" + vs.checkport);
				if (vs.maxconn != 0)
					datas.add("\t" + MAXCONN_KEY + "="
							+ String.valueOf(vs.maxconn));
				if (vs.protomod.length() != 0)
					datas.add("\t" + MODULE_KEY + "=" + vs.protomod + " "
							+ vs.option);
				if (vs.qosclient != 0) {
					StringBuffer buf = new StringBuffer();
					if (vs.qosclient > 1000000) {
						buf.append(vs.qosclient / 1000000);
						buf.append('M');
					} else if (vs.qosclient > 1000) {
						buf.append(vs.qosclient / 1000);
						buf.append('K');
					} else
						buf.append(vs.qosclient);
					datas.add("\t" + QOSCLIENTS_KEY + "="
							+ buf.toString());
				}
				if (vs.qosservice != 0) {
					StringBuffer buf = new StringBuffer();
					if (vs.qosservice > 1000000) {
						buf.append(vs.qosservice / 1000000);
						buf.append('M');
					} else if (vs.qosservice > 1000) {
						buf.append(vs.qosservice / 1000);
						buf.append('K');
					} else
						buf.append(vs.qosservice);
					datas.add("\t" + QOSSERVICE_KEY + "="
							+ buf.toString());
				}
				if (vs.receive.length() != 0)
					datas.add("\t" + RECEIVE_KEY + "=\"" + vs.receive + "\"");
				if (vs.service.length() != 0)
					datas.add("\t" + SERVICE_KEY + "=\"" + vs.service + "\"");
				if (vs.request.length() != 0)
					datas.add("\t" + REQUEST_KEY + "=\"" + vs.request + "\"");
				if (vs.sched.length() != 0)
					datas.add("\t" + SCHEDULER_KEY + "=" + vs.sched);
				if (vs.sorryserver.host.length() != 0)
					datas.add("\t" + SORRYSERVER_KEY + "="
							+ vs.sorryserver.host + ":" + vs.sorryserver.port);
				if (vs.httpmethod.length() != 0)
					datas.add("\t" + HTTPMETHOD_KEY + "=" + vs.httpmethod);
				if (vs.virtualhost.length() != 0)
					datas.add("\t" + VIRTUALHOST_KEY + "=\"" + vs.virtualhost + "\"");
				if (vs.passwd.length() != 0)
					datas.add("\t" + PASSWORD_KEY + "=\"" + vs.passwd + "\"");
				if (vs.login.length() != 0)
					datas.add("\t" + LOGIN_KEY + "=\"" + vs.login + "\"");
				if (vs.database.length() != 0)
					datas.add("\t" + DATABASE_KEY + "=\"" + vs.database + "\"");
				if (vs.downcallback.length() != 0)
					datas.add("\t" + REALDOWNCALLBACK_KEY + "=\""
							+ vs.downcallback + "\"");
				if (vs.upcallback.length() != 0)
					datas.add("\t" + REALRECOVERCALLBACK_KEY + "=\""
							+ vs.upcallback + "\"");
//				if (vs.checkcount != 0)
//					datas.add("\t" + CHECKCOUNT_KEY + "=" + vs.checkcount);
				if (vs.timeout != 0) {
					if (vs.checktype != null && 
							((vs.checktype.equals("connect") || vs.checktype.equals("ping")) ||
							 ((vs.checktype.equals("negotiate") || vs.checktype.matches("^\\d$")) &&
									 vs.service != null && (vs.service.equals("dns") || vs.service.equals("sip"))
									 )
							)
						) {
						datas.add("\t" + CHECKTIMEOUT_KEY + "=" + vs.timeout);
					}
					else {
						datas.add("\t" + NEGOTIATE_TIMEOUT_KEY + "=" + vs.timeout);
					}
				}
				if (vs.quiescent.length() != 0)
					datas.add("\t" + QUIESCENT_KEY + "=" + vs.quiescent);
				if (vs.protocol.length() != 0)
					datas.add("\t" + PROTOCOL_KEY + "=" + vs.protocol);
				datas.add("");
			}
		} catch (Exception e) {
			org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
			ex.setErrMessage("Cannot open file : " + filename
					+ "BaseException : " + e.getMessage());
			throw ex;
		}
		
		return datas;
	}

	/**
	 * 
	 * <p>
	 * saveToFile method
	 * </p>
	 * 
	 * @param in
	 * @throws org.ultramonkey.l7.model.FileNotWriteException
	 */
	protected void saveToFile(DirectorData in)
			throws org.ultramonkey.l7.model.FileNotWriteException {
		LinkedList<String> datas = this.buildNewConf(in);
		try {
			java.io.File file = new java.io.File(filename);
			if (file.exists()) {
				Date date = new Date();
				java.io.File backfile = new java.io.File(filename + ".bak."
						+ String.valueOf(date.getTime()));
				file.renameTo(backfile);
				file = new java.io.File(filename);
			}
			java.io.FileWriter writer = new java.io.FileWriter(file);
			for (Iterator<String> itr = datas.iterator(); itr
					.hasNext();) {
				StringBuffer buf = new StringBuffer(itr.next());
				buf.append('\n');
				writer.write(buf.toString());
			}
			writer.flush();
			writer.close();
		} catch (Exception e) {
			org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
			ex.setErrMessage("Cannot write file : " + filename);
			throw ex;
		}
	}

	/**
	 * 
	 * <p>
	 * syntaxCheck method
	 * </p>
	 * 
	 * @param in
	 * @throws org.ultramonkey.l7.model.FileNotWriteException
	 */
	protected String syntaxCheck(DirectorData in)
			throws org.ultramonkey.l7.model.FileNotWriteException {
		StringBuffer result = new StringBuffer();
		LinkedList<String> datas = this.buildNewConf(in);
		try {
			Date date = new Date();
			String tmpFile = filename + "." + String.valueOf(date.getTime());
			File file = new java.io.File(tmpFile);
			FileWriter writer = new FileWriter(file);
			for (Iterator<String> itr = datas.iterator(); itr
					.hasNext();) {
				StringBuffer buf = new StringBuffer(itr.next());
				buf.append('\n');
				writer.write(buf.toString());
			}
			writer.flush();
			writer.close();
			
			// TODO sudo
			String command = "sudo " + l7directord + " -t " + tmpFile;
			Process p = Runtime.getRuntime().exec(command);
			InputStream stderr = p.getErrorStream();
			BufferedReader br = new BufferedReader(new InputStreamReader(stderr));
			String line = null;
			while ((line = br.readLine()) != null) {
				result.append(line + "\n");
			}
			InputStream is = p.getInputStream();
			br = new BufferedReader(new InputStreamReader(is));
			while ((line = br.readLine()) != null) {
				result.append(line + "\n");
			}
			
			file.delete();
		} catch (Exception e) {
			org.ultramonkey.l7.model.FileNotWriteException ex = new org.ultramonkey.l7.model.FileNotWriteException();
			ex.setErrMessage("Cannot write file : " + filename);
			throw ex;
		}
		
		return result.toString();
	}

	/**
	 * get DirectorData from l7directord.cf
	 * <p>
	 * getDirectorData method
	 * </p>
	 * 
	 * @return DirectorData l7directord.cf datas
	 * @throws org.ultramonkey.l7.model.FileNotReadException
	 */
	public DirectorData getDirectorData()
			throws org.ultramonkey.l7.model.FileNotReadException {
		// --- debug log (in method) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11575 DirectorController::getDirectorData() in");
		}
		// --- debug log (in method) ---

		DirectorData data = null;
		synchronized (this) {
			if (serchfile()) {
				data = loadFromFile();
			}
		}

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11576 DirectorController::getDirectorData() out return=(" + data + ")");
		}
		// --- debug log (out method) ---
		return data;
	}

	/**
	 * set DirectorData to l7directord.cf
	 * <p>
	 * setDirectorData method
	 * </p>
	 * 
	 * @param in
	 */
	public void setDirectorData(DirectorData in)
			throws org.ultramonkey.l7.model.FileNotWriteException {
		// --- debug log (in method) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11577 DirectorController::setDirectorData(DirectorData in) in in=(" + in + ")");
		}
		// --- debug log (in method) ---

		synchronized (this) {
			if (in != null && serchfile()) {
				saveToFile(in);
			}
		}

		// --- debug log (out method) ---
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11578 DirectorController::setDirectorData(DirectorData in) out");
		}
		// --- debug log (out method) ---
	}

	/**
	 * check new l7directord.cf
	 * <p>
	 * checkDirectorData method
	 * </p>
	 * 
	 * @param in
	 */
	public String checkDirectorData(DirectorData in)
			throws org.ultramonkey.l7.model.FileNotWriteException {
		// --- debug log (in method) ---
		Logger ioFileLogger = Logger.getLogger(LogCategorySet.GUI_IO_FILE);
		if (ioFileLogger.isDebugEnabled()) {
            ioFileLogger.debug("11579 DirectorController::checkDirectorData(DirectorData in) in in=(" + in + ")");
		}
		// --- debug log (in method) ---

		synchronized (this) {
			if (in != null && serchfile()) {
				String ret = this.syntaxCheck(in);
				
				// --- debug log (out method) ---
				if (ioFileLogger.isDebugEnabled()) {
		            ioFileLogger.debug("11580 DirectorController::checkDirectorData(DirectorData in) out return=\"" + ret + "\"");
				}
				// --- debug log (out method) ---
				return ret;
			}

			// --- debug log (out method) ---
			if (ioFileLogger.isDebugEnabled()) {
	            ioFileLogger.debug("11581 DirectorController::checkDirectorData(DirectorData in) out return=null");
			}
			// --- debug log (out method) ---
			return null;
		}
	}
}
