<%@ page import="org.ultramonkey.l7.model.*,
				 org.ultramonkey.l7.controller.*,
				 org.ultramonkey.l7.view.*, java.util.*"
	language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
%>
<%
	/*
	 * check session
 	 */
 	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41305, LogCategorySet.GUI_USER_AUTHENTICATION,
				Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get cluster status and fix css seat
	 */
	L7guiFramework framework = new L7guiFramework(); 
	ClusterData cd = framework.getClusterData();
	if (cd == null) {
		MessageView error = new MessageView(41306, LogCategorySet.GUI_IO_COMMAND,
				Message.CLUSTER_DATA_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}	
	
	String cssSeat = "l7gui_single_style.css";
	if ( cd.self_status == ClusterStatus.ACTIVE ){
		cssSeat = "l7gui_act_style.css";
	}
	else if ( cd.self_status == ClusterStatus.STANDBY ){
		cssSeat = "l7gui_sby_style.css";
	}

	/*
	 * in case : sessionTimeout == null(Adm Command Normal)
	 *  get save status & sync status
	 */	 

	/*
	 * Adm timeout status
	 */
	Parameter param = Parameter.getInstance(); 
	if (param == null){
		MessageView error = new MessageView(41307, LogCategorySet.GUI_START_STOP,
				Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
	String sessionTimeout = param.getValue(Parameter.L7VSADM_TIMEOUT_FLAG);

	boolean saveState = false;
	String logSaveState = (String)session.getAttribute(SessionKeys.LOG_SAVE_STATE);
	String vsSaveState = (String)session.getAttribute(SessionKeys.VS_SAVE_STATE);
	
	int syncState = 0; 
	String logSyncState = null;
	String vsSyncState = null;
	String monitorSyncState = null;
	String repSyncState = null;
	String snmpSyncState = null;
	String guiSyncState = null;

	String legendInfo = null;
 
	if ( sessionTimeout == null ) {
		/*
		 * get save status
		 */	 
	
		if ( (logSaveState == null) || (vsSaveState == null) ){
			MessageView error = new MessageView(41308, LogCategorySet.GUI_USER_AUTHENTICATION,
					Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			return;
		}
		
		if ((logSaveState.equals(SessionKeys.SAVE)) && (vsSaveState.equals(SessionKeys.SAVE))){
			saveState = true;
		}
	
		
		/*
		 * in case : ACT or SBY get sync status
		 */
		if ( (cd.self_status == ClusterStatus.ACTIVE) || (cd.self_status == ClusterStatus.STANDBY) ){
			syncState = 1;
			logSyncState = (String)session.getAttribute(SessionKeys.LOG_SYNC_STATE);
			vsSyncState = (String)session.getAttribute(SessionKeys.VS_SYNC_STATE);
			monitorSyncState = (String)session.getAttribute(SessionKeys.MONITOR_SYNC_STATE);
			repSyncState = (String)session.getAttribute(SessionKeys.REP_SYNC_STATE);
			snmpSyncState = (String)session.getAttribute(SessionKeys.SNMP_SYNC_STATE);
			guiSyncState = (String)session.getAttribute(SessionKeys.GUI_SYNC_STATE);
		
			if ( (logSyncState == null) || (vsSyncState == null) 
					|| (monitorSyncState == null ) || (repSyncState == null ) 
					|| (snmpSyncState == null ) || (guiSyncState == null) ){
				
				MessageView error = new MessageView(41309, LogCategorySet.GUI_USER_AUTHENTICATION,
						Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				return;
			}
			
			if ( (logSyncState.equals(SessionKeys.SYNC)) && (vsSyncState.equals(SessionKeys.SYNC)) 
					&& (monitorSyncState.equals(SessionKeys.SYNC)) && (repSyncState.equals(SessionKeys.SYNC)) 
					&& (snmpSyncState.equals(SessionKeys.SYNC)) && (guiSyncState.equals(SessionKeys.SYNC)) ){
	
				syncState = 2;
			}
		}
	

		if ( (cd.self_status == ClusterStatus.ACTIVE) || (cd.self_status == ClusterStatus.STANDBY) ){ 
			if ( saveState == true && syncState == 1 ){
				legendInfo = "No Sync Info";
			}
			else if ( saveState == false && syncState == 1 ){
				legendInfo = "No Sync & No Save Info";
			}
			else if ( saveState == false && syncState == 2 ){
				legendInfo = "No Save Info";
			}
		}
		else {
			if (saveState == false ){
				legendInfo = "No Save Info";
			}
		}
	}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
	<head>
	 	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	 	<meta http-equiv="Pragma" content="no-cache">
		<meta http-equiv="Cache-Control" content="no-cache">
		<meta http-equiv="Expires" content="0"> 			 	
		<meta http-equiv="Content-Script-Type" content="text/javascript" />
		<meta http-equiv="Content-Style-Type" content="text/css" />
		<script src="l7gui.js" type="text/javascript"></script>
		<noscript> 
			<meta http-equiv="refresh" content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>"/>
		</noscript> 
		<link rel="stylesheet" type="text/css" href="<%=cssSeat %>" />
		<link rel="shortcut icon" href="images/favicon.ico" />
		<title>Check Logout</title>
	</head>

	<body class="normal">
	<jsp:include page="menu.jsp" flush="false"/>

	<div id="content">

		<h1>Check Logout </h1>
		<form method="post" action="logout_success.jsp">
		<%
		if ( sessionTimeout == null ) {
			if ( legendInfo != null ){
		%>
				<fieldset>
				<legend><%=legendInfo %></legend>
					<table class="status">
					<% 
					if ( saveState == false ){
					%>
					<tr>
						<th>
							<label for="noSaveCategory">No Save Category</label>
						</th>
						<td>
						<%
						if ( logSaveState.equals(SessionKeys.NO_SAVE) )
							out.println("<p class=\"text\"> Log </p>");
						if ( vsSaveState.equals(SessionKeys.NO_SAVE ) )
							out.println("<p class=\"text\"> Service </p>");
						%>
						</td>
					</tr>
					<%
					}
					%>
					<% 
					if ( syncState == 1){
					%>
					<tr>
						<th>
							<label for="noSyncCategory">No Sync Category</label>
						</th>
						<td>
						<%
						if ( logSyncState.equals(SessionKeys.NO_SYNC) )
							out.println("<p class=\"text\"> Log </p>");
						if ( monitorSyncState.equals(SessionKeys.NO_SYNC ) )
							out.println("<p class=\"text\"> Monitor </p>");
						if ( vsSyncState.equals(SessionKeys.NO_SYNC ) )
							out.println("<p class=\"text\"> Service </p>");
						if ( repSyncState.equals(SessionKeys.NO_SYNC ) )
							out.println("<p class=\"text\"> Replication </p>");
						if ( snmpSyncState.equals(SessionKeys.NO_SYNC ) )
							out.println("<p class=\"text\"> SNMPAgent </p>");
						if ( guiSyncState.equals(SessionKeys.NO_SYNC ) )
							out.println("<p class=\"text\"> GUI </p>");
						%>
						</td>
					</tr>
					<%
					}
					%>
				</table>
				</fieldset>
				<%
				}
		}
				%>
					
			<h2>Logout OK?</h2>
			<input type="submit" name="button" value="<%=ButtonMode.YES %>" onClick="return confirm(logout)" />
		</form>

	</div>
	</body>
</html>
