/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SyncCategoryIdSet;
import org.ultramonkey.l7.view.CommandExecuter;
import org.ultramonkey.l7.view.L7guiServletBase;

public class SyncStateServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public SyncStateServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11431 class SyncStateServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("SyncStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11432 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11433 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11434 SyncStateServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MessageView error;
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11435 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11436 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error2 = new MessageView(41191, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error2);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11437 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String[] selectCheck = request.getParameterValues("sync_category");
        String button_mode = request.getParameter("button");
        if (button_mode == null || !button_mode.equals("Save + Sync")) {
            error = new MessageView(41192, "l7gui_Sync", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11438 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (selectCheck == null) {
            error = new MessageView(21084, "l7gui_Sync", "Please select one or some of the followings.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("sync.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11439 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        HashSet<Integer> syncCategory = new HashSet<Integer>();
        int i = 0;
        while (i < selectCheck.length) {
            try {
                int categoryNum = SyncCategoryIdSet.toCategoryId(selectCheck[i]);
                syncCategory.add(categoryNum);
            }
            catch (MessageView mem) {
                MessageView error3 = new MessageView(21085, "l7gui_Sync", "Please select one or some of the followings.");
                session.setAttribute("resultMessage", (Object)error3);
                response.sendRedirect("sync.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11440 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            ++i;
        }
        CommandExecuter thread = new CommandExecuter(session);
        try {
            thread.setExecute(ExecuteMode.SYNC, syncCategory);
            thread.start();
        }
        catch (Exception e) {
            MessageView error4 = new MessageView(41193, "l7gui_Sync", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error4);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11441 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect("sync_executive.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11442 SyncStateServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }
}

