/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.L7vsConfCategory;
import org.ultramonkey.l7.controller.L7vsConfController;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.ReplicationData;
import org.ultramonkey.l7.controller.ReplicationStatus;
import org.ultramonkey.l7.controller.SnmpAgentData;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.ExecuteMode;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;

public class CommandExecuter
extends Thread
implements Serializable {
    static final long serialVersionUID = 1L;
    ExecuteMode mode;
    Object DataClass;
    Object OrgDataClass;
    Object NewDataClass;
    HttpSession session;

    public CommandExecuter(HttpSession session) {
        this.session = session;
        this.mode = null;
        this.DataClass = null;
        this.OrgDataClass = null;
        this.NewDataClass = null;
    }

    private void setThreadStatus(MessageView mv) {
        this.session.setAttribute("commandMessage", (Object)mv);
    }

    private void setThreadStatus(String st) {
        this.session.setAttribute("threadStatus", (Object)st);
    }

    private void setThreadStatus(String st, String mes) {
        this.session.setAttribute("threadStatus", (Object)st);
    }

    public void setExecute(ExecuteMode mode, DirectorData DataClass) throws IllegalArgumentException {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception DirectorData is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    public void setExecute(ExecuteMode mode, VirtualSetting DataClass) throws IllegalArgumentException {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception VirtualSettingData is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    public void setExecute(ExecuteMode mode, VirtualSetting OrgDataClass, VirtualSetting NewDataClass) throws IllegalArgumentException {
        if (OrgDataClass == null || NewDataClass == null) {
            throw new IllegalArgumentException("Exception VirtualSettingData is null.");
        }
        this.mode = mode;
        this.OrgDataClass = OrgDataClass;
        this.NewDataClass = NewDataClass;
    }

    public void setExecute(ExecuteMode mode) {
        this.mode = mode;
    }

    public void setExecute(ExecuteMode mode, ReplicationData DataClass) {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception ReplicationData is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    public void setExecute(ExecuteMode mode, LogData DataClass) {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception LogDeta is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    public void setExecute(ExecuteMode mode, SnmpAgentData DataClass) {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception SnmpAgentData is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    public void setExecute(ExecuteMode mode, HashSet DataClass) {
        if (DataClass == null) {
            throw new IllegalArgumentException("Exception categoryList is null.");
        }
        this.mode = mode;
        this.DataClass = DataClass;
    }

    private boolean vsRemove(DirectorData dd, VirtualSetting vs) {
        int i = 0;
        while (i < dd.virtualSettings.size()) {
            if (vs.isSameService(dd.virtualSettings.elementAt(i))) {
                dd.virtualSettings.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean vsRemove(L7vsAdmData ad, VirtualSetting vs) {
        int i = 0;
        while (i < ad.virtualSettings.size()) {
            if (vs.isSameService(ad.virtualSettings.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run() {
        boolean result = false;
        boolean sameVs = false;
        String message = "";
        int errno = 0;
        HashSet<Integer> cset = new HashSet<Integer>();
        this.setThreadStatus("running");
        L7guiFramework framework = new L7guiFramework();
        L7vsConfController confController = new L7vsConfController();
        switch (this.mode) {
            case DIRECTOR_SAVE: {
                String syntax = framework.checkDirectorData((DirectorData)this.DataClass);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41099;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf \"" + syntax + "\"");
                    result = false;
                    break;
                }
                result = framework.setDirectorData((DirectorData)this.DataClass);
                if (!result) {
                    errno = 41100;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                errno = 21049;
                message = "Succeeded to modify monitor settings.";
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                this.session.setAttribute("monitorSyncState", (Object)"noSync");
                break;
            }
            case DIRECTOR_SAVESYNC: {
                String syntax = framework.checkDirectorData((DirectorData)this.DataClass);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41101;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                result = framework.setDirectorData((DirectorData)this.DataClass);
                if (!result) {
                    errno = 41102;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                this.session.setAttribute("monitorSyncState", (Object)"noSync");
                cset.add(9);
                result = framework.syncExecute(cset);
                if (!result) {
                    errno = 41103;
                    message = "Failed in the synchronization of the l7directord.cf file.";
                    break;
                }
                errno = 21050;
                message = "Succeeded to modify and sync monitor settings.";
                this.session.setAttribute("vsSyncState", (Object)"sync");
                this.session.setAttribute("monitorSyncState", (Object)"sync");
                break;
            }
            case VS_ADD_APPLY: {
                result = framework.addVirtualSetting((VirtualSetting)this.DataClass);
                if (!result) {
                    errno = 41104;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21051;
                message = "Succeeded to add a new VirtualService setting.";
                this.session.setAttribute("vsSaveState", (Object)"noSave");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_ADD_SAVE: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41105;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                for (VirtualSetting exist : dd.virtualSettings) {
                    if (!exist.isSameService((VirtualSetting)this.DataClass)) continue;
                    sameVs = true;
                    break;
                }
                if (sameVs) {
                    errno = 41106;
                    message = "Already the same VirtualService exists.";
                    result = false;
                    break;
                }
                dd.virtualSettings.add((VirtualSetting)this.DataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41107;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                result = framework.setDirectorData(dd);
                if (!result) {
                    errno = 41108;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                errno = 21052;
                message = "Succeeded to add and save a new VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_ADD_SAVESYNC: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41109;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                for (VirtualSetting exist : dd.virtualSettings) {
                    if (!exist.isSameService((VirtualSetting)this.DataClass)) continue;
                    sameVs = true;
                    break;
                }
                if (sameVs) {
                    errno = 41110;
                    message = "Already the same VirtualService exists.";
                    result = false;
                    break;
                }
                dd.virtualSettings.add((VirtualSetting)this.DataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41111;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                result = framework.setDirectorData(dd);
                if (!result) {
                    errno = 41112;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                cset.add(10);
                result = framework.syncExecute(cset);
                if (!result) {
                    errno = 41113;
                    message = "Failed in the synchronization of the l7directord.cf file.";
                    break;
                }
                errno = 21053;
                message = "Succeeded to add, save, and sync a new VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSyncState", (Object)"sync");
                break;
            }
            case VS_REMOVE_APPLY: {
                result = framework.delVirtualSetting((VirtualSetting)this.DataClass);
                if (!result) {
                    errno = 41114;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21054;
                message = "Succeeded to remove a VirtualService setting.";
                this.session.setAttribute("vsSaveState", (Object)"noSave");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_REMOVE_SAVE: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41115;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                L7vsAdmData ad = framework.getAdmData();
                if (ad == null) {
                    errno = 41116;
                    message = "An error occurred while processing l7vsadm command.";
                    result = false;
                    break;
                }
                result = this.vsRemove(dd, (VirtualSetting)this.DataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41117;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                if (!result) {
                    result = this.vsRemove(ad, (VirtualSetting)this.DataClass);
                    if (!result) {
                        errno = 41118;
                        message = "Such VirtualService does not exist.";
                        break;
                    }
                    result = framework.delVirtualSetting((VirtualSetting)this.DataClass);
                    if (!result) {
                        errno = 41119;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    this.session.setAttribute("vsSaveState", (Object)"noSave");
                    this.session.setAttribute("vsSyncState", (Object)"noSync");
                }
                if (!(result = framework.setDirectorData(dd))) {
                    errno = 41120;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                errno = 21055;
                message = "Succeeded to remove and save a VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_REMOVE_SAVESYNC: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41121;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                L7vsAdmData ad = framework.getAdmData();
                if (ad == null) {
                    errno = 41122;
                    message = "An error occurred while processing l7vsadm command.";
                    result = false;
                    break;
                }
                result = this.vsRemove(dd, (VirtualSetting)this.DataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41123;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                if (!result) {
                    result = this.vsRemove(ad, (VirtualSetting)this.DataClass);
                    if (!result) {
                        errno = 41124;
                        message = "Such VirtualService does not exist.";
                        break;
                    }
                    result = framework.delVirtualSetting((VirtualSetting)this.DataClass);
                    if (!result) {
                        errno = 41125;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    this.session.setAttribute("vsSaveState", (Object)"noSave");
                    this.session.setAttribute("vsSyncState", (Object)"noSync");
                }
                if (!(result = framework.setDirectorData(dd))) {
                    errno = 41126;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                cset.add(10);
                result = framework.syncExecute(cset);
                if (!result) {
                    errno = 41127;
                    message = "Failed in the synchronization of the l7directord.cf file.";
                    break;
                }
                errno = 21056;
                message = "Succeeded to remove and save, sync a VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSyncState", (Object)"sync");
                break;
            }
            case VS_MODIFY_APPLY: {
                result = framework.delVirtualSetting((VirtualSetting)this.OrgDataClass);
                if (!result) {
                    errno = 41128;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                result = framework.addVirtualSetting((VirtualSetting)this.NewDataClass);
                if (!result) {
                    errno = 41129;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21057;
                message = "Succeeded to modify VirtualService setting.";
                this.session.setAttribute("vsSaveState", (Object)"noSave");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_MODIFY_SAVE: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41130;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                L7vsAdmData ad = framework.getAdmData();
                if (ad == null) {
                    errno = 41131;
                    message = "An error occurred while processing l7vsadm command.";
                    result = false;
                    break;
                }
                result = this.vsRemove(dd, (VirtualSetting)this.OrgDataClass);
                for (VirtualSetting exist : dd.virtualSettings) {
                    if (!exist.isSameService((VirtualSetting)this.NewDataClass)) continue;
                    sameVs = true;
                    break;
                }
                if (sameVs) {
                    errno = 41132;
                    message = "Already the same VirtualService exists.";
                    result = false;
                    break;
                }
                dd.virtualSettings.add((VirtualSetting)this.NewDataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41133;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                if (!result) {
                    result = this.vsRemove(ad, (VirtualSetting)this.OrgDataClass);
                    if (!result) {
                        errno = 41134;
                        message = "Such VirtualService does not exist.";
                        break;
                    }
                    result = framework.delVirtualSetting((VirtualSetting)this.OrgDataClass);
                    if (!result) {
                        errno = 41135;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    this.session.setAttribute("vsSaveState", (Object)"noSave");
                    this.session.setAttribute("vsSyncState", (Object)"noSync");
                }
                if (!(result = framework.setDirectorData(dd))) {
                    errno = 41136;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                errno = 21058;
                message = "Succeeded to modify and save VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                break;
            }
            case VS_MODIFY_SAVESYNC: {
                DirectorData dd = framework.getDirectorData();
                if (dd == null) {
                    errno = 41137;
                    message = "Cannot get the l7directord.cf data.";
                    result = false;
                    break;
                }
                L7vsAdmData ad = framework.getAdmData();
                if (ad == null) {
                    errno = 41138;
                    message = "An error occurred while processing l7vsadm command.";
                    result = false;
                    break;
                }
                result = this.vsRemove(dd, (VirtualSetting)this.OrgDataClass);
                for (VirtualSetting exist : dd.virtualSettings) {
                    if (!exist.isSameService((VirtualSetting)this.NewDataClass)) continue;
                    sameVs = true;
                    break;
                }
                if (sameVs) {
                    errno = 41139;
                    message = "Already the same VirtualService exists.";
                    result = false;
                    break;
                }
                dd.virtualSettings.add((VirtualSetting)this.NewDataClass);
                String syntax = framework.checkDirectorData(dd);
                if (syntax == null || !syntax.matches("^Syntax OK\n$")) {
                    String[] error;
                    errno = 41140;
                    message = syntax == null ? "Cannot write new data to the l7directord.cf file." : ((error = syntax.split("at line \\d+: ", 2)).length == 2 ? "Syntax error of l7directord.cf: \"" + error[1] + "\"" : "Syntax error of l7directord.cf\"" + syntax + "\"");
                    result = false;
                    break;
                }
                if (!result) {
                    result = this.vsRemove(ad, (VirtualSetting)this.OrgDataClass);
                    if (!result) {
                        errno = 41141;
                        message = "Such VirtualService does not exist.";
                        break;
                    }
                    result = framework.delVirtualSetting((VirtualSetting)this.OrgDataClass);
                    if (!result) {
                        errno = 41142;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    this.session.setAttribute("vsSaveState", (Object)"noSave");
                    this.session.setAttribute("vsSyncState", (Object)"noSync");
                }
                if (!(result = framework.setDirectorData(dd))) {
                    errno = 41143;
                    message = "Cannot write new data to the l7directord.cf file.";
                    break;
                }
                this.session.setAttribute("vsSaveState", (Object)"save");
                this.session.setAttribute("vsSyncState", (Object)"noSync");
                cset.add(10);
                result = framework.syncExecute(cset);
                if (!result) {
                    errno = 41144;
                    message = "Failed in the synchronization of the l7directord.cf file.";
                    break;
                }
                errno = 21059;
                message = "Succeeded to modify, save and sync VirtualService setting. If the settings is not reflected in the following list, please refresh this page after waited for a while.";
                this.session.setAttribute("vsSyncState", (Object)"sync");
                break;
            }
            case CLUSTER_SWITCHORVER: {
                result = framework.setClusterMode();
                if (!result) {
                    errno = 41145;
                    message = "An error occurred while processing cluster management command.";
                    break;
                }
                errno = 21060;
                message = "Succeeded to switch-over cluster.";
                break;
            }
            case REP_MASTER: {
                result = framework.setReplicationMode(ReplicationStatus.MASTER);
                if (!result) {
                    errno = 41146;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21061;
                message = "Succeeded to start replication.";
                break;
            }
            case REP_MASTER_STOP: {
                result = framework.setReplicationMode(ReplicationStatus.MASTER_STOP);
                if (!result) {
                    errno = 41147;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21062;
                message = "Succeeded to stop replication.";
                break;
            }
            case REP_SLAVE: {
                result = framework.setReplicationMode(ReplicationStatus.SLAVE);
                if (!result) {
                    errno = 41148;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21063;
                message = "Succeeded to start replication.";
                break;
            }
            case REP_SLAVE_STOP: {
                result = framework.setReplicationMode(ReplicationStatus.SLAVE_STOP);
                if (!result) {
                    errno = 41149;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21064;
                message = "Succeeded to stop replication.";
                break;
            }
            case REP_INFO_SAVE: {
                result = framework.setReplicationData((ReplicationData)this.DataClass);
                if (!result) {
                    errno = 41150;
                    message = "Cannot write new data to the l7vs.cf file.";
                    break;
                }
                errno = 21065;
                message = "Succeeded to modify and save replication setting.";
                this.session.setAttribute("repSyncState", (Object)"noSync");
                break;
            }
            case REP_INFO_SAVESYNC: {
                result = framework.setReplicationData((ReplicationData)this.DataClass);
                if (result) {
                    this.session.setAttribute("repSyncState", (Object)"noSync");
                    cset.add(6);
                    result = framework.syncExecute(cset);
                    if (!result) {
                        errno = 41151;
                        message = "Failed in the synchronization of the l7vs.cf file.";
                        break;
                    }
                    errno = 21066;
                    message = "Succeeded to modify, save and sync replication setting.";
                    this.session.setAttribute("repSyncState", (Object)"sync");
                    break;
                }
                errno = 41152;
                message = "Cannot write new data to the l7vs.cf file.";
                break;
            }
            case REP_START: {
                result = framework.dumpReplicationData();
                if (!result) {
                    errno = 41153;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21067;
                message = "Succeeded to dump replication data.";
                break;
            }
            case LOGLEVEL_CHANGE_APPLY: {
                LogData ld = (LogData)this.DataClass;
                result = framework.setLogLevel(ld.lbLog.logLevel);
                if (!result) {
                    errno = 41154;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                result = framework.setLogLevel(ld.snmpLog.logLevel);
                if (!result) {
                    errno = 41155;
                    message = "An error occurred while processing l7vsadm command.";
                    break;
                }
                errno = 21068;
                message = "Succeeded to change log level.";
                this.session.setAttribute("logSaveState", (Object)"noSave");
                this.session.setAttribute("logSyncState", (Object)"noSync");
                break;
            }
            case LOGLEVEL_CHANGE_SAVE: {
                try {
                    L7vsConfData cf = confController.getConfData();
                    cf.logger = (LogData)this.DataClass;
                    result = framework.setL7vsConfData(cf);
                    if (!result) {
                        errno = 41156;
                        message = "Cannot write new data to the l7vs.cf file.";
                        break;
                    }
                    result = framework.reloadAdmData(L7vsConfCategory.LOGGER);
                    if (!result) {
                        errno = 41157;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    result = framework.reloadAdmData(L7vsConfCategory.SNMPAGENT);
                    if (!result) {
                        errno = 41158;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    errno = 21069;
                    message = "Succeeded to change and save log level.";
                    this.session.setAttribute("logSaveState", (Object)"save");
                    this.session.setAttribute("logSyncState", (Object)"noSync");
                }
                catch (Exception e) {
                    errno = 41159;
                    message = "Cannot get the l7vs.cf data.";
                    result = false;
                }
                break;
            }
            case LOGLEVEL_CHANGE_SAVESYNC: {
                try {
                    L7vsConfData cf = confController.getConfData();
                    cf.logger = (LogData)this.DataClass;
                    result = framework.setL7vsConfData(cf);
                    if (!result) {
                        errno = 41160;
                        message = "Cannot write new data to the l7vs.cf file.";
                        break;
                    }
                    result = framework.reloadAdmData(L7vsConfCategory.LOGGER);
                    if (!result) {
                        errno = 41161;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    result = framework.reloadAdmData(L7vsConfCategory.SNMPAGENT);
                    if (!result) {
                        errno = 41162;
                        message = "An error occurred while processing l7vsadm command.";
                        break;
                    }
                    this.session.setAttribute("logSaveState", (Object)"save");
                    this.session.setAttribute("logSyncState", (Object)"noSync");
                    cset.add(12);
                    result = framework.syncExecute(cset);
                    if (!result) {
                        errno = 41163;
                        message = "Failed in the synchronization of the l7vs.cf file.";
                        break;
                    }
                    errno = 21070;
                    message = "Succeeded to change, save and sync log level";
                    this.session.setAttribute("logSyncState", (Object)"sync");
                }
                catch (Exception e) {
                    errno = 41164;
                    message = "Cannot get the l7vs.cf data.";
                    result = false;
                }
                break;
            }
            case SNMP_INFO_SAVE: {
                result = framework.setSnmpAgentData((SnmpAgentData)this.DataClass);
                if (!result) {
                    errno = 41165;
                    message = "Cannot write new data to the l7vs.cf file.";
                    break;
                }
                errno = 21071;
                message = "Succeeded to change and save SNMP Agent setting.";
                this.session.setAttribute("snmpSyncState", (Object)"noSync");
                break;
            }
            case SNMP_INFO_SAVESYNC: {
                result = framework.setSnmpAgentData((SnmpAgentData)this.DataClass);
                if (!result) {
                    errno = 41166;
                    message = "Cannot write new data to the l7vs.cf file.";
                    break;
                }
                this.session.setAttribute("snmpSyncState", (Object)"noSync");
                cset.add(7);
                result = framework.syncExecute(cset);
                if (!result) {
                    errno = 41167;
                    message = "Failed in the synchronization of the l7vs.cf file.";
                    break;
                }
                errno = 21072;
                message = "Succeeded to change, save and sync SNMP Agent setting.";
                this.session.setAttribute("snmpSyncState", (Object)"sync");
                break;
            }
            case SYNC: {
                HashSet syncSet = (HashSet)this.DataClass;
                result = framework.syncExecute(syncSet);
                if (!result) {
                    errno = 41168;
                    message = "Failed to synchronize ";
                    break;
                }
                errno = 21073;
                message = "Succeeded to sync resources.";
                Iterator iterator = syncSet.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    switch (i) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 12: {
                            this.session.setAttribute("logSyncState", (Object)"sync");
                            break;
                        }
                        case 6: {
                            this.session.setAttribute("repSyncState", (Object)"sync");
                            break;
                        }
                        case 7: {
                            this.session.setAttribute("snmpSyncState", (Object)"sync");
                            break;
                        }
                        case 9: {
                            this.session.setAttribute("monitorSyncState", (Object)"sync");
                            break;
                        }
                        case 10: {
                            this.session.setAttribute("vsSyncState", (Object)"sync");
                            break;
                        }
                        case 11: {
                            this.session.setAttribute("guiSyncState", (Object)"sync");
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Parameter.");
            }
        }
        MessageView mv = new MessageView();
        mv.setCategory("l7gui_I/O.Command");
        mv.setMessage(message);
        mv.setErrno(errno);
        this.setThreadStatus(mv);
        if (!result) {
            this.setThreadStatus("fail");
        } else {
            this.setThreadStatus("success");
        }
    }
}

