/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.model;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.L7SyncManager;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.SyncCategoryIdSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L7SyncCommand {
    protected static Logger debugLogger = Logger.getLogger((String)"l7sync_Sync");
    protected HashSet<Integer> categorySet;
    protected int serverMode = 0;
    private static final int ACT_MODE = 1;
    private static final int SBY_MODE = 2;
    private static final int MODE_ERROR = 3;
    private static final int UNDESIGNED_MODE = 0;
    private int MODE_LOCATION = 0;
    private int CATEGORY_START_LOCATION = this.MODE_LOCATION + 1;
    protected Logger logger = Logger.getLogger((String)"l7sync_Sync");

    public L7SyncCommand(String[] args) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug((Object)"11232 class L7SyncCommand created.");
        }
        this.categorySet = new HashSet();
        try {
            this.checkArgument(args);
        }
        catch (MessageView m) {
            System.out.println("Invalid argument supplied for L7SyncCommand.");
            this.logger.info((Object)"21032 Invalid argument supplied for L7SyncCommand.");
        }
    }

    protected void checkArgument(String[] args) throws MessageView {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::checkArgument(String[] args) throws MessageView in args= ");
            if (args.length != 0) {
                int i = 0;
                while (i < args.length) {
                    if (args.length - 1 == i) {
                        buf.append(args[i].toString());
                        break;
                    }
                    buf.append(String.valueOf(args[i].toString()) + ",");
                    ++i;
                }
            } else {
                buf.append("null");
            }
            debugLogger.debug((Object)("11233 " + buf.toString()));
        }
        if (args.length == 0) {
            this.setServerMode(0);
        } else if (args[this.MODE_LOCATION].equals("-a")) {
            this.setServerMode(1);
            if (args.length <= this.CATEGORY_START_LOCATION) {
                throw new MessageView(40024, "l7sync_Sync", "Invalid argument supplied for checkArgument.");
            }
            int i = this.CATEGORY_START_LOCATION;
            while (i < args.length) {
                try {
                    this.setCaterogyIdSet(SyncCategoryIdSet.toCategoryId(args[i]));
                }
                catch (MessageView m) {
                    throw new MessageView(40025, "l7sync_Sync", "Invalid argument supplied for checkArgument.");
                }
                ++i;
            }
        } else if (args[this.MODE_LOCATION].equals("-s")) {
            this.setServerMode(2);
        } else {
            this.setServerMode(3);
            throw new MessageView(40026, "l7sync_Sync", "Invalid argument supplied for checkArgument.");
        }
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::checkArgument(String[] args) throws MessageView out ");
            debugLogger.debug((Object)("11234 " + buf.toString()));
        }
    }

    public static void main(String[] args) {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::main(String[] args) in args= ");
            if (args.length == 0) {
                buf.append("null");
            } else {
                int i = 0;
                while (i < args.length) {
                    if (args.length - 1 == i) {
                        buf.append(args[i].toString());
                        break;
                    }
                    buf.append(String.valueOf(args[i].toString()) + ",");
                    ++i;
                }
            }
            debugLogger.debug((Object)("11235 " + buf.toString()));
        }
        if (args.length == 0) {
            L7SyncCommand.usage();
        } else {
            L7SyncCommand l7SyncCommand = new L7SyncCommand(args);
            l7SyncCommand.start();
        }
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::main(String[] args) out ");
            debugLogger.debug((Object)("11236 " + buf.toString()));
        }
    }

    protected void start() {
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::start() in ");
            debugLogger.debug((Object)("11237 " + buf.toString()));
        }
        L7SyncManager l7SyncManager = new L7SyncManager();
        switch (this.serverMode) {
            case 1: {
                try {
                    l7SyncManager.syncAct(this.getCategoryIdSet());
                }
                catch (MessageView m) {
                    System.out.println(m.message);
                }
                break;
            }
            case 2: {
                try {
                    l7SyncManager.syncSby();
                }
                catch (MessageView m) {
                    System.out.println(m.message);
                }
                break;
            }
            default: {
                System.out.println("Invalid server mode.");
            }
        }
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::start() out ");
            debugLogger.debug((Object)("11238 " + buf.toString()));
        }
    }

    protected static void usage() {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::usage() in ");
            debugLogger.debug((Object)("11239 " + buf.toString()));
        }
        System.out.println("Usage: L7SyncCommand -a [CATEGORY]...\n       L7SyncCommand -s\n\nCommands:\n  -a    active mode. send specified category data to standby server.\n  -s    standby mode. receive data from active server.\n\nCategory:\n  l7vsd_log         log settings of l7vsd\n  adm_log           log settings of l7vsadm\n  snmp_log          log settings of l7agent\n  log_all           all log settings\n  adm_info          command settings of l7vsadm\n  replication_info  replication settings of l7vsd\n  snmp_info         interval settings of l7agent\n  monitor           global settings of l7directord.cf\n  service           virtual settings of l7directord.cf\n  userdata          user data of l7gui\n");
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::usage() out ");
            debugLogger.debug((Object)("11240 " + buf.toString()));
        }
    }

    protected HashSet<Integer> getCategoryIdSet() {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::getCategoryIdSet() in ");
            debugLogger.debug((Object)("11241 " + buf.toString()));
        }
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::getCategoryIdSet() out ");
            buf.append("return= " + this.categorySet.toString());
            debugLogger.debug((Object)("11242 " + buf.toString()));
        }
        return this.categorySet;
    }

    protected void setCaterogyIdSet(Integer categoryId) {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::setCaterogyIdSet() in ");
            debugLogger.debug((Object)("11243 " + buf.toString()));
        }
        this.categorySet.add(categoryId);
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::setCaterogyIdSet() out ");
            debugLogger.debug((Object)("11244 " + buf.toString()));
        }
    }

    protected int getServerMode() {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() in ");
            debugLogger.debug((Object)("11245 " + buf.toString()));
        }
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() out ");
            buf.append("return= " + this.serverMode);
            debugLogger.debug((Object)("11246 " + buf.toString()));
        }
        return this.serverMode;
    }

    protected void setServerMode(int mode) {
        StringBuffer buf;
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::setServerMode() in ");
            buf.append("mode= " + mode);
            debugLogger.debug((Object)("11247 " + buf.toString()));
        }
        if (debugLogger.isDebugEnabled()) {
            buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() out ");
            debugLogger.debug((Object)("11248 " + buf.toString()));
        }
        this.serverMode = mode;
    }
}

