package com.td.utility;

import java.util.Calendar;
import java.util.Date;

import android.content.Context;

public class StatusFlag {
	// OFF  (RDY )@ON @OFF
	public static final int OFF = 0;
	public static final int RDY = 2;
	public static final int ON = 1;
	public static final int ERR = -1;

	public static final int TERM_1M = 1;
	public static final long TERM_10M = 10;
	public static final int TERM_30M = 30;
	public static final int TERM_1H = 60;
	public static final int TERM_NONE = -1;
	
	private static final String PREF_STF_FLAG = "STF_FLAG";
	private static final String DELM = ",";

	private Context context;
	private long term; // 
	private EditPrefUtil pref;
	private String key;

	public StatusFlag(Context context, String id, long term){
		this.context = context;
		this.term = term;
		pref = new EditPrefUtil(context);
		key = id + "_" + PREF_STF_FLAG;
	}
	
	public void setOn(){
		set(ON);
	}
	
	public void setOff(){
		set(OFF);
	}
	
	public void setErr(){
		set(ERR);
	}

	public void setRdy(){
		set(RDY);
	}
	
	public void set(int flag){
		Calendar cal = Calendar.getInstance();
		Date d = cal.getTime();
		int ymd = DateUtil.getYmd(d);
		int hm = DateUtil.getHm(d);
		
		StringBuffer sb = new StringBuffer();
		sb.append(ymd);
		sb.append(DELM);
		sb.append(hm);
		sb.append(DELM);
		sb.append(flag);
		
		pref.put(key, sb.toString());
		pref.update();
	}
	
	public int get(){
		return get(term);
	}
	
	public int get(long term){
		String s = pref.get(key);
		if (s == null){
			return OFF;
		}
		
		String[] t = s.split(DELM);
		int ymd = Integer.valueOf(t[0]);
		int hm = Integer.valueOf(t[1]);
		int flag = Integer.valueOf(t[2]);
		
		if (flag == OFF || term < 0){
			return flag;
		}
		
		int y = DateUtil.getY(ymd);
		int m = DateUtil.getM(ymd);
		int d = DateUtil.getD(ymd);

		int h = DateUtil.getH(hm);
		int mi = DateUtil.getMi(hm);
		
		Calendar sCal = DateUtil.getCalendar(y, m, d, h, mi);
		Calendar nCal = Calendar.getInstance();
		
		long mt = sCal.getTimeInMillis() + term * 60 * 1000; // ۑԍő
		long nt = nCal.getTimeInMillis(); // 
		
		if (nt > mt){
			Debug.t(context, "ۑőԒ߁@" + ymd + "/" + hm);
			this.setOff();
			return OFF;
		}
		return flag;
	}

	public boolean isOn(){
		return get() == ON;
	}

	public boolean isOff(){
		return get() == OFF;
	}

	public boolean isErr(){
		return get() == ERR;
	}

	public boolean isRdy(){
		return get() == RDY;
	}
	
	public String toString(){
		if (isOff()){
			return "OFF";
		}
		if (isRdy()){
			return "READY";
		}
		if (isOn()){
			return "ON";
		}
		if (isErr()){
			return "ERROR";
		}
		return "NONE";
	}
}
