package com.td.utility;

import android.os.RemoteException;
import android.util.Log;

public class ExceptionUtil {
	public static final String TAG_E10 = "com.td.e10";
	public static final String TAG_E20 = "com.td.e20";
	public static final String TAG_E30 = "com.td.e30";
	public static final String TAG_E40 = "com.td.e40";
	public static final String TAG_E41 = "com.td.e41";
	public static final String TAG_E42 = "com.td.e42";
	public static final String TAG_E50 = "com.td.e50";
	public static final String TAG_E60 = "com.td.e60";
	public static final String TAG_E70 = "com.td.e70";
	public static final String TAG_E80 = "com.td.e80";
	public static final String TAG_E90 = "com.td.e90";

	private static ExceptionUtil instance = null;
	
	public static ExceptionUtil getInstance(){
		if (instance == null){
			instance = new ExceptionUtil();
		}
		return instance;
	}
	
	private ExceptionUtil(){
		
	}
	
	public void throwException(String tag) throws Exception{
		if (Log.isLoggable(tag, Log.DEBUG)){
			throw new Exception();
		}
	}

	public void throwRemoteException(String tag) throws RemoteException{
		if (Log.isLoggable(tag, Log.DEBUG)){
			throw new RemoteException();
		}
	}

	public boolean isDebug(String tag) {
		return Log.isLoggable(tag, Log.DEBUG);
	}
}
