package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

import com.td.utility.DateUtil;
import com.td.utility.Util;

public class MonitorDao {
	private static MonitorDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement deleteStmt = null;
	private SQLiteStatement deleteByIdStmt = null;

	public static MonitorDao getInstance() {
		if (instance == null) {
			instance = new MonitorDao();
		}
		return instance;
	}

	private MonitorDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE MONITOR (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "WEEK0 INTEGER,"
				+ "WEEK1 INTEGER," + "WEEK2 INTEGER," + "WEEK3 INTEGER,"
				+ "WEEK4 INTEGER," + "WEEK5 INTEGER," + "WEEK6 INTEGER,"
				+ "FRM INTEGER," + "TT INTEGER" + ");");
	}

	public void init(SQLiteDatabase db) {
		// Monitor monitor = new Monitor(600, 800);
		// int n = 1;
		// monitor.setWeek(n++, true);
		// monitor.setWeek(n++, true);
		// monitor.setWeek(n++, true);
		// monitor.setWeek(n++, true);
		// monitor.setWeek(n++, true);
		// add(db, monitor);
	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO MONITOR (" + "WEEK0,"
				+ "WEEK1," + "WEEK2," + "WEEK3," + "WEEK4," + "WEEK5,"
				+ "WEEK6," + "FRM," + "TT" + ") VALUES (" + "?,?,?,?,?,?,?,?,?"
				+ ");");
		updateStmt = db.compileStatement("UPDATE MONITOR SET " + "WEEK0 = ?,"
				+ "WEEK1 = ?," + "WEEK2 = ?," + "WEEK3 = ?," + "WEEK4 = ?,"
				+ "WEEK5 = ?," + "WEEK6 = ?," + "FRM = ?," + "TT = ? "
				+ "WHERE " + android.provider.BaseColumns._ID + " = ?;");
		deleteStmt = db.compileStatement("DELETE FROM MONITOR");
		deleteByIdStmt = db.compileStatement("DELETE FROM MONITOR  " + "WHERE "
				+ android.provider.BaseColumns._ID + " = ?;");
	}

	public List<Monitor> search() {
		return search(null, null, "FRM, TT");
	}

	private List<Monitor> search(String selection, String[] selectionArgs,
			String orderBy) {
		List<Monitor> list = new ArrayList<Monitor>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();

		Cursor cursor = db.query("MONITOR", new String[] {
				android.provider.BaseColumns._ID, "WEEK0", "WEEK1", "WEEK2",
				"WEEK3", "WEEK4", "WEEK5", "WEEK6", "FRM", "TT" }, selection,
				selectionArgs, null, null, orderBy);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Monitor monitor = new Monitor(cursor.getInt(0),
						cursor.getInt(8), cursor.getInt(9));
				for (int j = 0; j < DateUtil.WEEK; j++) {
					monitor.setWeek(j, Util.toBoolean(cursor.getInt(j + 1)));
				}
				list.add(monitor);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public void add(Monitor monitor) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		add(db, monitor);
	}

	private long add(SQLiteDatabase db, Monitor monitor) {
		long id = -1;
		db.beginTransaction();
		try {
			int i = 1;
			int n = 0;
			SQLiteStatement stmt = insertStmt;
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, monitor.getFrom());
			stmt.bindLong(i++, monitor.getTo());
			id = stmt.executeInsert();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public void set(Monitor monitor) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			int n = 0;
			SQLiteStatement stmt = updateStmt;
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, Util.toInt(monitor.getWeek(n++)));
			stmt.bindLong(i++, monitor.getFrom());
			stmt.bindLong(i++, monitor.getTo());
			stmt.bindLong(i++, monitor.getId());
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void delete(long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = deleteByIdStmt;
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}
	
	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
