package com.td.db;

import java.util.ArrayList;
import java.util.List;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;

public class KeywordDao {
	private static KeywordDao instance = null;
	private SQLiteStatement insertStmt = null;
	private SQLiteStatement updateStmt = null;
	private SQLiteStatement deleteStmt = null;
	private SQLiteStatement deleteByIdStmt = null;

	public static KeywordDao getInstance() {
		if (instance == null) {
			instance = new KeywordDao();
		}
		return instance;
	}

	private KeywordDao() {

	}

	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE KEYWORD (" + android.provider.BaseColumns._ID
				+ " INTEGER PRIMARY KEY AUTOINCREMENT," + "TEXT TEXT" + ");");
	}

	public void init(SQLiteDatabase db) {
		final String[] keywords = { "lg", "x", "~܂", "x", "^]~", "^]",
				"^]", };

		for (int i = 0; i < keywords.length; i++) {
			Keyword keyword = new Keyword(keywords[i]);
			add(db, keyword);
		}
	}

	public void start(SQLiteDatabase db) {
		insertStmt = db.compileStatement("INSERT INTO KEYWORD (" + "TEXT"
				+ ") VALUES (" + "?" + ");");
		updateStmt = db.compileStatement("UPDATE KEYWORD SET " + "TEXT = ? "
				+ "WHERE " + android.provider.BaseColumns._ID + " = ?;");
		deleteStmt = db.compileStatement("DELETE FROM KEYWORD");
		deleteByIdStmt = db.compileStatement("DELETE FROM KEYWORD  " + "WHERE "
				+ android.provider.BaseColumns._ID + " = ?;");
	}

	public List<Keyword> search() {
		return search(null, null);
	}

	private List<Keyword> search(String selection, String[] selectionArgs) {
		List<Keyword> list = new ArrayList<Keyword>();
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getReadableDatabase();

		Cursor cursor = db.query("KEYWORD", new String[] {
				android.provider.BaseColumns._ID, "TEXT" }, selection,
				selectionArgs, null, null, null);
		try {
			cursor.moveToFirst();
			int size = cursor.getCount();
			for (int i = 0; i < size; i++) {
				Keyword keyword = new Keyword(cursor.getInt(0),
						cursor.getString(1));
				list.add(keyword);
				cursor.moveToNext();
			}
		} finally {
			if (cursor != null) {
				cursor.close();
			}
		}
		return list;
	}

	public void add(Keyword keyword) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		add(db, keyword);
	}

	private long add(SQLiteDatabase db, Keyword keyword) {
		long id = -1;
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = insertStmt;
			stmt.bindString(i++, keyword.getText());
			id = stmt.executeInsert();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
		return id;
	}

	public void set(long id, String text) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = updateStmt;
			stmt.bindString(i++, text);
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void delete(long id) {
		DatabaseHelper helper = DatabaseHelper.getInstance();
		SQLiteDatabase db = helper.getWritableDatabase();
		db.beginTransaction();
		try {
			int i = 1;
			SQLiteStatement stmt = deleteByIdStmt;
			stmt.bindLong(i++, id);
			stmt.execute();
			db.setTransactionSuccessful();
		} finally {
			db.endTransaction();
		}
	}

	public void deleteNT() {
		SQLiteStatement stmt = deleteStmt;
		stmt.execute();
	}
}
