package com.td;

import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;

import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.service.TrainDelayedServiceImpl;
import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;

public class TrainListActivity extends BaseActivity {
	private EditPrefUtil pref = new EditPrefUtil(this);
	private ListView listView;
	private List<Train> list;
	private int position = -1;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.train_list);

		try {
			listView = (ListView) findViewById(R.id.menu51);
			Button button1 = (Button) findViewById(R.id.button51);

			Bundle extras = getIntent().getExtras();
			long pid = extras.getLong("PID");

			list = TrainDao.getInstance().search(pid);
			TrainListViewArrayAdapter adapter = new TrainListViewArrayAdapter(
					this, android.R.layout.simple_list_item_1, list);
			listView.setAdapter(adapter);

			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					TrainListActivity.this.position = position;

					Train item = list.get(position);
					boolean selected = item.isSelected();

					selected = !selected;
					item.setSelected(selected);

					CheckBox checkbox = (CheckBox) view
							.findViewById(R.id.checkBox);
					checkbox.setChecked(selected);

					TrainDelayedServiceImpl.clearSchedule(
							TrainListActivity.this, pref);

					if (selected) {
						TrainEditActivity.init(TrainListActivity.this);

						Intent intent = new Intent(TrainListActivity.this,
								(Class<?>) TrainEditActivity.class);
						intent.putExtra("ID", item.getId());
						startActivityForResult(intent, 0);
					} else {
						long n = item.getId();
						TrainDao.getInstance().set(n, selected);

						TrainDelayedServiceImpl.clearSchedule(
								TrainListActivity.this, pref);
					}
				}
			});

			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					TrainListActivity.this.finish();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);

		if (resultCode == RESULT_OK) {

		} else {
			if (position >= 0) {
				Train item = list.get(position);
				item.setSelected(false);
			}
		}
		listView.invalidateViews();
	}
}
