package com.td;

import java.util.List;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;

import com.td.db.Prefecture;
import com.td.db.PrefectureDao;
import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.utility.ExceptionUtil;

public class PrefectureListActivity extends BaseActivity {
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.prefecture_list);
		
		try {
			ListView listView = (ListView) findViewById(R.id.menu41);
			Button button1 = (Button) findViewById(R.id.button41);
			
			ExceptionUtil.getInstance().throwException(ExceptionUtil.TAG_E20);
			
			final List<Prefecture> list = PrefectureDao.getInstance().search();
			ArrayAdapter<Prefecture> adapter = new ArrayAdapter<Prefecture>(this,
					android.R.layout.simple_list_item_1, list);
			listView.setAdapter(adapter);
	
			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view, int position,
						long id) {
					Prefecture pre = list.get(position);
					long pid = pre.getId();
					Intent intent = new Intent(PrefectureListActivity.this,
							(Class<?>) TrainListActivity.class);
					intent.putExtra("PID", pid);
					startActivityForResult(intent, -1);
				}
			});
			
			button1.setOnClickListener(new OnClickListener(){
				public void onClick(View view) {
					finish();
				}});
		}
		catch (Exception e){
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}
}
