package com.td;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;

import com.td.service.TrainDelayedServiceImpl;
import com.td.utility.BaseActivity;
import com.td.utility.ConfUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;

public class ConfEditActivity extends BaseActivity {
	public static final String PREF_CFE_DATA = "CFE_DATA";
	private EditPrefUtil pref = new EditPrefUtil(this);

	// ĎԊu
	private static final int[] LEN = { 5, 10, 30, 60 };

	// ĎԊu(DEBUG)
	private static final int[] DEBUG_LEN = { 1, 3, 5, 10, 30, 60 };

	// twit
	private static final int[] H = { 1, 2, 3, 4, 5, 10, 15, 30, 50 };

	// ĒʒmԊu
	private static final int[] W = { 5, 10, 30, 60, 120, };

	// ĒʒmԊu(DEBUG)
	private static final int[] DEBUG_W = { 1, 2, 3, 5, 10, 30, 60, 120, };

	private Spinner spinner1;
	private Spinner spinner2;
	private Spinner spinner3;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.conf_edit);

		try {
			spinner1 = (Spinner) findViewById(R.id.spinnerb1);
			spinner1.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					ConfUtil.setLen(pref, Debug.isDebug() ? DEBUG_LEN[position]
							: LEN[position]);
				}

				public void onNothingSelected(AdapterView<?> view) {
					;
				}
			});

			spinner2 = (Spinner) findViewById(R.id.spinnerb2);
			spinner2.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					ConfUtil.setHeight(pref, H[position]);
				}

				public void onNothingSelected(AdapterView<?> view) {
					;
				}
			});

			spinner3 = (Spinner) findViewById(R.id.spinnerb3);
			spinner3.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					ConfUtil.setWidth(pref, Debug.isDebug() ? DEBUG_W[position]
							: W[position]);
				}

				public void onNothingSelected(AdapterView<?> view) {
					;
				}
			});

			Button button8 = (Button) findViewById(R.id.buttonb8);
			button8.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					pref.update();
					TrainDelayedServiceImpl.clearSchedule(
							ConfEditActivity.this, pref);
					ConfEditActivity.this.finish();
				}
			});

			Button button9 = (Button) findViewById(R.id.buttonb9);
			button9.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					ConfEditActivity.this.finish();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void setSpinner(Spinner spinner, int[] aryVal, int val,
			String suffix) {
		String[] aryStr = new String[aryVal.length];
		for (int i = 0; i < aryStr.length; i++) {
			aryStr[i] = aryVal[i] + suffix;
		}
		ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_spinner_item, aryStr);
		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		spinner.setAdapter(adapter);

		int j;
		for (j = 0; j < aryStr.length; j++) {
			if (val == Integer.valueOf(aryVal[j])) {
				break;
			}
		}
		if (j >= aryStr.length) {
			j = 0;
		}
		spinner.setSelection(j);
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			String data = pref.get(PREF_CFE_DATA);
			if (data != null) {
				pref.restore(PREF_CFE_DATA);
			}

			int len = ConfUtil.getLen(pref);
			setSpinner(spinner1, Debug.isDebug() ? DEBUG_LEN : LEN, len, "");

			int h = ConfUtil.getHeight(pref);
			setSpinner(spinner2, H, h, "/");

			int w = ConfUtil.getWidth(pref);
			setSpinner(spinner3, Debug.isDebug() ? DEBUG_W : W, w, "");
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onStop() {
		super.onStop();

		try {
			pref.save(PREF_CFE_DATA);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);
		pref.remove(PREF_CFE_DATA);
		pref.update();
	}
}
