package com.td;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.wait.InitializeWating;

public class ConfActivity extends BaseActivity {
	private boolean isClick = false;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.conf);

		try {
			Button button1 = (Button) findViewById(R.id.button21);
			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					ConfEditActivity.init(ConfActivity.this);
					Intent intent = new Intent(ConfActivity.this,
							(Class<?>) ConfEditActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			Button button2 = (Button) findViewById(R.id.button22);
			button2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(ConfActivity.this,
							(Class<?>) SearchWordActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			Button button3 = (Button) this.findViewById(R.id.button23);
			button3.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					if (isClick) {
						return;
					}
					isClick = true;

					new AlertDialog.Builder(ConfActivity.this)
							.setTitle(getString(R.string.warn_dialog_title))
							.setMessage(getString(R.string.init_qmsg))
							.setPositiveButton(getString(R.string.yes_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											initizlize();

											isClick = false;
										}
									})
							.setNegativeButton(
									getString(R.string.cancel_button),
									new DialogInterface.OnClickListener() {
										public void onClick(
												DialogInterface dialog,
												int whichButton) {
											isClick = false;
										}
									}).create().show();
				}
			});

			Button button4 = (Button) findViewById(R.id.button24);
			button4.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(ConfActivity.this,
							(Class<?>) LogListActivity.class);
					startActivityForResult(intent, -1);
				}
			});

			Button button9 = (Button) findViewById(R.id.button29);
			button9.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					ConfActivity.this.finish();
				}
			});

			if (!Debug.isDebug()) {
				button4.setVisibility(View.GONE);
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void initizlize() {
		Intent intent = new Intent(this, (Class<?>) WaitActivity.class);
		intent.putExtra(WaitActivity.CLASS, InitializeWating.class.getName());
		intent.putExtra(WaitActivity.MESSAGE0, getString(R.string.waiting_msg));
		intent.putExtra(WaitActivity.MESSAGE1,
				getString(R.string.start_clear_conf_msg));
		intent.putExtra(WaitActivity.MESSAGE2,
				getString(R.string.end_clear_conf_msg));
		intent.putExtra(WaitActivity.MESSAGE3, "");

		WaitActivity.init(this);
		startActivityForResult(intent, -1);
	}

}
