/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.Shape;

public class RectShape
implements Shape {
    private RectF mRect;

    public RectShape() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public RectShape(RectF rect) {
        this(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public RectShape(Rect rect) {
        this(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public RectShape(RectShape rect) {
        this.mRect = new RectF(rect.mRect);
    }

    public RectShape(float x, float y, float width, float height) {
        this.mRect = new RectF(x, y, x + width, y + height);
    }

    public RectShape(double x, double y, double width, double height) {
        this.mRect = new RectF((float)x, (float)y, (float)(x + width), (float)(y + height));
    }

    public Path getPath() {
        Path path = new Path();
        path.addRect(this.mRect, Path.Direction.CW);
        return path;
    }

    public void clip(Canvas canvas) {
        canvas.clipRect(this.mRect);
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRect(this.mRect, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(this.mRect, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawRect(this.mRect, paint);
    }

    public boolean contains(RectShape rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(float x, float y) {
        return this.mRect.contains((float)((int)x), (float)((int)y));
    }

    public boolean contains(float x, float y, float width, float height) {
        return this.mRect.contains((float)((int)x), (float)((int)y), (float)((int)(x + width)), (float)((int)(y + height)));
    }

    public boolean contains(PointF point) {
        return this.mRect.contains(point.x, point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        return this;
    }

    public void getBounds(RectShape rect) {
        rect.setRect(this);
    }

    public boolean intersects(float x, float y, float width, float height) {
        return this.mRect.intersects(x, y, x + width, y + height);
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, Math.abs(rect.right - rect.left), Math.abs(rect.bottom - rect.top));
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean intersectsLine(float x1, float y1, float x2, float y2) {
        return this.intersectsLine(new LineShape(x1, y1, x2, y2));
    }

    public boolean intersectsLine(LineShape line) {
        if (line.intersectsLine(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMinY())) {
            return true;
        }
        if (line.intersectsLine(this.getMinX(), this.getMinY(), this.getMinX(), this.getMaxY())) {
            return true;
        }
        if (line.intersectsLine(this.getMaxX(), this.getMinY(), this.getMaxX(), this.getMaxY())) {
            return true;
        }
        if (line.intersectsLine(this.getMinX(), this.getMaxY(), this.getMaxX(), this.getMaxY())) {
            return true;
        }
        return this.contains(line.getX1(), line.getY1()) || this.contains(line.getX2(), line.getY2());
    }

    public RectShape createUnion(RectShape rect) {
        float l = this.getX() < rect.getX() ? this.getX() : rect.getX();
        float t = this.getY() < rect.getY() ? this.getY() : rect.getY();
        float r = this.getX() + this.getWidth() < rect.getX() + rect.getWidth() ? rect.getX() + rect.getWidth() : this.getX() + this.getWidth();
        float b = this.getY() + this.getHeight() < rect.getY() + rect.getHeight() ? rect.getY() + rect.getHeight() : this.getY() + this.getHeight();
        return new RectShape(l, t, r - l, b - t);
    }

    public boolean isEmpty() {
        return this.getWidth() <= 0.0f || this.getHeight() <= 0.0f;
    }

    public void translate(float x, float y) {
        this.mRect.left += x;
        this.mRect.top += y;
        this.mRect.right += x;
        this.mRect.bottom += y;
    }

    public void setRect(float x, float y, float width, float height) {
        this.mRect.left = x;
        this.mRect.top = y;
        this.mRect.right = x + width;
        this.mRect.bottom = y + height;
    }

    public void setRect(double x, double y, double width, double height) {
        this.mRect.left = (float)x;
        this.mRect.top = (float)y;
        this.mRect.right = (float)(x + width);
        this.mRect.bottom = (float)(y + height);
    }

    public void setRect(RectShape rect) {
        this.mRect.left = rect.getX();
        this.mRect.top = rect.getY();
        this.mRect.right = rect.getMaxX();
        this.mRect.bottom = rect.getMaxY();
    }

    public void setRect(Rect rect) {
        this.mRect.set(rect);
    }

    public void setRectF(RectF rectF) {
        this.mRect.set(rectF);
    }

    public RectF getRectF() {
        return new RectF(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY());
    }

    public float getX() {
        return this.mRect.left;
    }

    public void setX(float x) {
        this.mRect.left = x;
    }

    public float getY() {
        return this.mRect.top;
    }

    public void setY(float y) {
        this.mRect.top = y;
    }

    public float getWidth() {
        return this.mRect.width();
    }

    public void setWidth(float width) {
        this.mRect.right = this.getMinX() + width;
    }

    public float getHeight() {
        return this.mRect.height();
    }

    public void setHeight(float height) {
        this.mRect.bottom = this.getMinY() + height;
    }

    public float getMinX() {
        return this.mRect.left;
    }

    public float getMaxX() {
        return this.mRect.right;
    }

    public float getCenterX() {
        return this.mRect.centerX();
    }

    public float getMinY() {
        return this.mRect.top;
    }

    public float getMaxY() {
        return this.mRect.bottom;
    }

    public float getCenterY() {
        return this.mRect.centerY();
    }

    public boolean equals(Object o) {
        if (o instanceof RectShape) {
            RectShape rectShape = (RectShape)o;
            return this.getX() == rectShape.getX() && this.getY() == rectShape.getY() && this.getWidth() == rectShape.getWidth() && this.getHeight() == rectShape.getHeight();
        }
        return false;
    }

    public RectShape clone() {
        return new RectShape(this);
    }
}

