/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class OvalShape
implements Shape {
    private RectF mOval;
    private Path mPath;
    private Region mRegion;

    public OvalShape() {
    }

    public OvalShape(float x, float y, float width, float height) {
        this.mOval = new RectF(x, y, x + width, y + height);
        this.mPath = new Path();
        this.update();
    }

    public OvalShape(double x, double y, double width, double height) {
        this.mOval = new RectF((float)x, (float)y, (float)(x + width), (float)(y + height));
        this.mPath = new Path();
        this.update();
    }

    public OvalShape(OvalShape ovalShape) {
        this(ovalShape.getX(), ovalShape.getY(), ovalShape.getWidth(), ovalShape.getHeight());
        this.mPath = ovalShape.mPath;
        this.mRegion = ovalShape.mRegion;
    }

    public Path getPath() {
        Path path = new Path();
        path.addOval(this.mOval, Path.Direction.CW);
        return path;
    }

    public void draw(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawOval(this.mOval, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        canvas.drawOval(this.mOval, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawOval(this.mOval, paint);
    }

    public void clip(Canvas canvas) {
        canvas.clipPath(this.mPath);
    }

    public boolean contains(RectShape rect) {
        return this.mRegion.contains((int)rect.getMinX(), (int)rect.getMinY()) && this.mRegion.contains((int)rect.getMinX(), (int)rect.getMaxY()) && this.mRegion.contains((int)rect.getMaxX(), (int)rect.getMinY()) && this.mRegion.contains((int)rect.getMaxX(), (int)rect.getMaxY());
    }

    public boolean contains(float x, float y) {
        return this.mRegion.contains((int)x, (int)y);
    }

    public boolean contains(float x, float y, float width, float height) {
        return this.mRegion.contains((int)x, (int)y) && this.mRegion.contains((int)x, (int)(y + height)) && this.mRegion.contains((int)(x + width), (int)y) && this.mRegion.contains((int)(x + width), (int)(y + height));
    }

    public boolean contains(PointF point) {
        return this.mRegion.contains((int)point.x, (int)point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        return new RectShape(this.mRegion.getBounds());
    }

    public void getBounds(RectShape rect) {
        rect.setRect(this.mRegion.getBounds());
    }

    public boolean intersects(float x, float y, float width, float height) {
        float tmph;
        float tmpy;
        float tmpw;
        float tmpx;
        Region region = new Region(this.mRegion);
        if (x < width + x) {
            tmpx = x;
            tmpw = width;
        } else {
            tmpx = width + x;
            tmpw = Math.abs(width);
        }
        if (y < height + y) {
            tmpy = y;
            tmph = height;
        } else {
            tmpy = height + y;
            tmph = Math.abs(height);
        }
        return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        this.mOval.left += x;
        this.mOval.top += y;
        this.mOval.right += x;
        this.mOval.bottom += y;
        this.update();
    }

    public float getX() {
        return this.mOval.left;
    }

    public float getY() {
        return this.mOval.top;
    }

    public float getWidth() {
        return this.mOval.width();
    }

    public float getHeight() {
        return this.mOval.height();
    }

    public float getMinX() {
        return this.getX();
    }

    public float getMaxX() {
        return this.mOval.right;
    }

    public float getCenterX() {
        return this.mOval.centerX();
    }

    public float getMinY() {
        return this.getY();
    }

    public float getMaxY() {
        return this.mOval.bottom;
    }

    public float getCenterY() {
        return this.mOval.centerY();
    }

    private void update() {
        this.mPath.reset();
        this.mPath.addOval(this.mOval, Path.Direction.CW);
        this.mRegion = new Region((int)this.mOval.left, (int)this.mOval.top, (int)this.mOval.right, (int)this.mOval.bottom);
        this.mRegion.setPath(this.mPath, this.mRegion);
    }

    public boolean equals(Object o) {
        if (o instanceof OvalShape) {
            OvalShape ovalShape = (OvalShape)o;
            if (this.mOval.left == ovalShape.mOval.left && this.mOval.right == ovalShape.mOval.right && this.mOval.top == ovalShape.mOval.top && this.mOval.bottom == ovalShape.mOval.bottom) {
                return true;
            }
        }
        return false;
    }

    public Shape clone() {
        return new OvalShape(this);
    }
}

