/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.renderer.category.BarPainter;
import org.afree.chart.renderer.category.BarRenderer;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class StandardBarPainter
implements BarPainter,
Serializable {
    private static final long serialVersionUID = -1706184054280631384L;

    public void paintBar(Canvas canvas, BarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base) {
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        Paint paint = PaintUtility.createPaint(1, itemPaintType);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(bar.getMinX(), bar.getMinY(), bar.getMaxX(), bar.getMaxY(), paint);
        if (renderer.isDrawBarOutline()) {
            float stroke = renderer.getItemOutlineStroke(row, column).floatValue();
            PaintType paintType = renderer.getItemOutlinePaintType(row, column);
            if (stroke != 0.0f && paintType != null) {
                paint = PaintUtility.createPaint(paintType, stroke, renderer.getItemOutlineEffect(row, column));
                paint.setStyle(Paint.Style.STROKE);
                canvas.drawRect(bar.getMinX(), bar.getMinY(), bar.getMaxX(), bar.getMaxY(), paint);
            }
        }
    }

    public void paintBarShadow(Canvas canvas, BarRenderer renderer, int row, int column, RectShape bar, RectangleEdge base, boolean pegShadow) {
        PaintType itemPaintType = renderer.getItemPaintType(row, column);
        if (itemPaintType.getAlpha() == 0) {
            return;
        }
        RectShape shadow = this.createShadow(bar, renderer.getShadowXOffset(), renderer.getShadowYOffset(), base, pegShadow);
        PaintType p = renderer.getShadowPaintType();
        Paint paint = PaintUtility.createPaint(1, p);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(shadow.getMinX(), shadow.getMinY(), shadow.getMaxX(), shadow.getMaxY(), paint);
    }

    private RectShape createShadow(RectShape bar, double xOffset, double yOffset, RectangleEdge base, boolean pegShadow) {
        double x0 = bar.getMinX();
        double x1 = bar.getMaxX();
        double y0 = bar.getMinY();
        double y1 = bar.getMaxY();
        if (base == RectangleEdge.TOP) {
            x0 += xOffset;
            x1 += xOffset;
            if (!pegShadow) {
                y0 += yOffset;
            }
            y1 += yOffset;
        } else if (base == RectangleEdge.BOTTOM) {
            x0 += xOffset;
            x1 += xOffset;
            y0 += yOffset;
            if (!pegShadow) {
                y1 += yOffset;
            }
        } else if (base == RectangleEdge.LEFT) {
            if (!pegShadow) {
                x0 += xOffset;
            }
            x1 += xOffset;
            y0 += yOffset;
            y1 += yOffset;
        } else if (base == RectangleEdge.RIGHT) {
            x0 += xOffset;
            if (!pegShadow) {
                x1 += xOffset;
            }
            y0 += yOffset;
            y1 += yOffset;
        }
        return new RectShape(x0, y0, x1 - x0, y1 - y0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof StandardBarPainter;
    }

    public int hashCode() {
        int hash = 37;
        return hash;
    }
}

