/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import java.io.Serializable;
import java.util.ArrayList;
import org.afree.chart.LegendItem;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.CategoryItemEntity;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.CategoryItemLabelGenerator;
import org.afree.chart.labels.CategorySeriesLabelGenerator;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.labels.StandardCategorySeriesLabelGenerator;
import org.afree.chart.plot.CategoryCrosshairState;
import org.afree.chart.plot.CategoryMarker;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.IntervalMarker;
import org.afree.chart.plot.Marker;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.ValueMarker;
import org.afree.chart.renderer.AbstractRenderer;
import org.afree.chart.renderer.category.CategoryItemRenderer;
import org.afree.chart.renderer.category.CategoryItemRendererState;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.category.CategoryDataset;
import org.afree.data.general.DatasetUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.OvalShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.LengthAdjustmentType;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.util.ObjectList;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1247553218442497391L;
    private CategoryPlot plot;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private CategoryItemLabelGenerator baseItemLabelGenerator;
    private CategorySeriesLabelGenerator legendItemLabelGenerator = new StandardCategorySeriesLabelGenerator();
    private CategorySeriesLabelGenerator legendItemToolTipGenerator;
    private CategorySeriesLabelGenerator legendItemURLGenerator;
    private transient int rowCount;
    private transient int columnCount;
    private CategoryItemLabelGenerator itemLabelGenerator = null;

    protected AbstractCategoryItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public CategoryPlot getPlot() {
        return this.plot;
    }

    public void setPlot(CategoryPlot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = plot;
    }

    public CategoryItemLabelGenerator getItemLabelGenerator(int row, int column) {
        return this.getSeriesItemLabelGenerator(row);
    }

    public CategoryItemLabelGenerator getSeriesItemLabelGenerator(int series) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        CategoryItemLabelGenerator generator = (CategoryItemLabelGenerator)this.itemLabelGeneratorList.get(series);
        if (generator == null) {
            generator = this.baseItemLabelGenerator;
        }
        return generator;
    }

    public void setSeriesItemLabelGenerator(int series, CategoryItemLabelGenerator generator) {
        this.itemLabelGeneratorList.set(series, generator);
    }

    public CategoryItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(CategoryItemLabelGenerator generator) {
        this.baseItemLabelGenerator = generator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected CategoryItemRendererState createState(PlotRenderingInfo info) {
        return new CategoryItemRendererState(info);
    }

    public CategoryItemRendererState initialise(Canvas canvas, RectShape dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        this.setPlot(plot);
        CategoryDataset data = plot.getDataset(rendererIndex);
        if (data != null) {
            this.rowCount = data.getRowCount();
            this.columnCount = data.getColumnCount();
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        CategoryItemRendererState state = this.createState(info);
        int[] visibleSeriesTemp = new int[this.rowCount];
        int visibleSeriesCount = 0;
        int row = 0;
        while (row < this.rowCount) {
            if (this.isSeriesVisible(row)) {
                visibleSeriesTemp[visibleSeriesCount] = row;
                ++visibleSeriesCount;
            }
            ++row;
        }
        int[] visibleSeries = new int[visibleSeriesCount];
        System.arraycopy(visibleSeriesTemp, 0, visibleSeries, 0, visibleSeriesCount);
        state.setVisibleSeriesArray(visibleSeries);
        return state;
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        return this.findRangeBounds(dataset, false);
    }

    protected Range findRangeBounds(CategoryDataset dataset, boolean includeInterval) {
        if (dataset == null) {
            return null;
        }
        if (this.getDataBoundsIncludesVisibleSeriesOnly()) {
            ArrayList<Comparable> visibleSeriesKeys = new ArrayList<Comparable>();
            int seriesCount = dataset.getRowCount();
            int s = 0;
            while (s < seriesCount) {
                if (this.isSeriesVisible(s)) {
                    visibleSeriesKeys.add(dataset.getRowKey(s));
                }
                ++s;
            }
            return DatasetUtilities.findRangeBounds(dataset, visibleSeriesKeys, includeInterval);
        }
        return DatasetUtilities.findRangeBounds(dataset, includeInterval);
    }

    public double getItemMiddle(Comparable rowKey, Comparable columnKey, CategoryDataset dataset, CategoryAxis axis, RectShape area, RectangleEdge edge) {
        return axis.getCategoryMiddle(columnKey, dataset.getColumnKeys(), area, edge);
    }

    public void drawBackground(Canvas canvas, CategoryPlot plot, RectShape dataArea) {
        plot.drawBackground(canvas, dataArea);
    }

    public void drawOutline(Canvas canvas, CategoryPlot plot, RectShape dataArea) {
        plot.drawOutline(canvas, dataArea);
    }

    public void drawDomainGridline(Canvas canvas, CategoryPlot plot, RectShape dataArea, double value) {
        float stroke;
        LineShape line = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape((double)dataArea.getMinX(), value, (double)dataArea.getMaxX(), value);
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new LineShape(value, (double)dataArea.getMinY(), value, (double)dataArea.getMaxY());
        }
        PaintType paintType = plot.getDomainGridlinePaintType();
        if (paintType == null) {
            paintType = CategoryPlot.DEFAULT_GRIDLINE_PAINT_TYPE;
        }
        if ((stroke = plot.getDomainGridlineStroke()) == 0.0f) {
            stroke = 1.0f;
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke, plot.getDomainGridlineEffect());
        paint.setStrokeCap(Paint.Cap.ROUND);
        line.draw(canvas, paint);
    }

    public void drawRangeGridline(Canvas canvas, CategoryPlot plot, ValueAxis axis, RectShape dataArea, double value) {
        float stroke;
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        LineShape line = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
        }
        PaintType paintType = plot.getRangeGridlinePaintType();
        if (paintType == null) {
            paintType = CategoryPlot.DEFAULT_GRIDLINE_PAINT_TYPE;
        }
        if ((stroke = plot.getRangeGridlineStroke()) == 0.0f) {
            stroke = 1.0f;
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke, plot.getRangeGridlineEffect());
        paint.setStrokeCap(Paint.Cap.ROUND);
        line.draw(canvas, paint);
    }

    public void drawRangeLine(Canvas canvas, CategoryPlot plot, ValueAxis axis, RectShape dataArea, double value, PaintType paintType, Float stroke, PathEffect effect) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        LineShape line = null;
        double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (orientation == PlotOrientation.HORIZONTAL) {
            line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
        } else if (orientation == PlotOrientation.VERTICAL) {
            line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
        }
        Paint paint = PaintUtility.createPaint(paintType, stroke.floatValue(), effect);
        paint.setStrokeWidth(stroke.floatValue());
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
    }

    public void drawDomainMarker(Canvas canvas, CategoryPlot plot, CategoryAxis axis, CategoryMarker marker, RectShape dataArea) {
        Paint paint;
        Comparable category = marker.getKey();
        CategoryDataset dataset = plot.getDataset(plot.getIndexOf(this));
        int columnIndex = dataset.getColumnIndex(category);
        if (columnIndex < 0) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        RectShape bounds = new RectShape();
        if (marker.getDrawAsLine()) {
            double v = axis.getCategoryMiddle(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            LineShape line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
            }
            paint = PaintUtility.createPaint(1, marker.getPaintType(), marker.getStroke(), marker.getEffect());
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setAlpha(marker.getAlpha());
            line.draw(canvas, paint);
            line.getBounds(bounds);
        } else {
            double v0 = axis.getCategoryStart(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            double v1 = axis.getCategoryEnd(columnIndex, dataset.getColumnCount(), dataArea, plot.getDomainAxisEdge());
            RectShape area = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                area = new RectShape((double)dataArea.getMinX(), v0, (double)dataArea.getWidth(), v1 - v0);
            } else if (orientation == PlotOrientation.VERTICAL) {
                area = new RectShape(v0, (double)dataArea.getMinY(), v1 - v0, (double)dataArea.getHeight());
            }
            Paint paint2 = PaintUtility.createPaint(1, marker.getPaintType());
            paint2.setAlpha(marker.getAlpha());
            paint2.setStrokeCap(Paint.Cap.ROUND);
            area.fill(canvas, paint2);
            bounds = area;
        }
        String label = marker.getLabel();
        RectangleAnchor anchor = marker.getLabelAnchor();
        if (label != null) {
            PointF coordinates = this.calculateDomainMarkerTextAnchorPoint(canvas, orientation, dataArea, bounds, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
            paint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
            paint.setAlpha(marker.getAlpha());
            TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), paint);
        }
    }

    public void drawRangeMarker(Canvas canvas, CategoryPlot plot, ValueAxis axis, Marker marker, RectShape dataArea) {
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = axis.getRange();
            if (!range.contains(value)) {
                return;
            }
            PlotOrientation orientation = plot.getOrientation();
            double v = axis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
            LineShape line = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                line = new LineShape(v, (double)dataArea.getMinY(), v, (double)dataArea.getMaxY());
            } else if (orientation == PlotOrientation.VERTICAL) {
                line = new LineShape((double)dataArea.getMinX(), v, (double)dataArea.getMaxX(), v);
            }
            Paint paint = PaintUtility.createPaint(1, marker.getPaintType(), marker.getStroke(), marker.getEffect());
            paint.setStrokeCap(Paint.Cap.ROUND);
            paint.setAlpha(marker.getAlpha());
            line.draw(canvas, paint);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                RectShape rectShape = new RectShape();
                line.getBounds(rectShape);
                PointF coordinates = this.calculateRangeMarkerTextAnchorPoint(canvas, orientation, dataArea, rectShape, marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                Paint labelPaint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                labelPaint.setAlpha(marker.getAlpha());
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), labelPaint);
            }
        } else if (marker instanceof IntervalMarker) {
            IntervalMarker im = (IntervalMarker)marker;
            double start = im.getStartValue();
            double end = im.getEndValue();
            Range range = axis.getRange();
            if (!range.intersects(start, end)) {
                return;
            }
            double start2d = axis.valueToJava2D(start, dataArea, plot.getRangeAxisEdge());
            double end2d = axis.valueToJava2D(end, dataArea, plot.getRangeAxisEdge());
            double low = Math.min(start2d, end2d);
            double high = Math.max(start2d, end2d);
            PlotOrientation orientation = plot.getOrientation();
            RectShape rect = null;
            if (orientation == PlotOrientation.HORIZONTAL) {
                low = Math.max(low, (double)dataArea.getMinX());
                high = Math.min(high, (double)dataArea.getMaxX());
                rect = new RectShape(low, (double)dataArea.getMinY(), high - low, (double)dataArea.getHeight());
            } else if (orientation == PlotOrientation.VERTICAL) {
                low = Math.max(low, (double)dataArea.getMinY());
                high = Math.min(high, (double)dataArea.getMaxY());
                rect = new RectShape((double)dataArea.getMinX(), low, (double)dataArea.getWidth(), high - low);
            }
            Paint paint = PaintUtility.createPaint(1, marker.getPaintType());
            paint.setAlpha(marker.getAlpha());
            rect.fill(canvas, paint);
            if (im.getOutlinePaintType() != null && im.getOutlineStroke() != null) {
                LineShape line;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new LineShape();
                    double x0 = dataArea.getMinX();
                    double x1 = dataArea.getMaxX();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    outlinePaint.setStrokeCap(Paint.Cap.ROUND);
                    if (range.contains(start)) {
                        line.setLine(x0, start2d, x1, start2d);
                        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(x0, end2d, x1, end2d);
                        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), outlinePaint);
                    }
                } else {
                    line = new LineShape();
                    double y0 = dataArea.getMinY();
                    double y1 = dataArea.getMaxY();
                    Paint outlinePaint = PaintUtility.createPaint(1, im.getOutlinePaintType(), im.getOutlineStroke().floatValue(), im.getOutlineEffect());
                    outlinePaint.setAlpha(marker.getAlpha());
                    outlinePaint.setStrokeCap(Paint.Cap.ROUND);
                    if (range.contains(start)) {
                        line.setLine(start2d, y0, start2d, y1);
                        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), outlinePaint);
                    }
                    if (range.contains(end)) {
                        line.setLine(end2d, y0, end2d, y1);
                        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), outlinePaint);
                    }
                }
            }
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                PointF coordinates = this.calculateRangeMarkerTextAnchorPoint(canvas, orientation, dataArea, rect, marker.getLabelOffset(), marker.getLabelOffsetType(), anchor);
                Paint labelPaint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                labelPaint.setAlpha(marker.getAlpha());
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), labelPaint);
            }
        }
    }

    protected PointF calculateDomainMarkerTextAnchorPoint(Canvas canvas, PlotOrientation orientation, RectShape dataArea, RectShape markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        RectShape anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    protected PointF calculateRangeMarkerTextAnchorPoint(Canvas canvas, PlotOrientation orientation, RectShape dataArea, RectShape markerArea, RectangleInsets markerOffset, LengthAdjustmentType labelOffsetType, RectangleAnchor anchor) {
        RectShape anchorRect = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, labelOffsetType, LengthAdjustmentType.CONTRACT);
        } else if (orientation == PlotOrientation.VERTICAL) {
            anchorRect = markerOffset.createAdjustedRectShape(markerArea, LengthAdjustmentType.CONTRACT, labelOffsetType);
        }
        return RectangleAnchor.coordinates(anchorRect, anchor);
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot p = this.getPlot();
        if (p == null) {
            return null;
        }
        if (!this.isSeriesVisible(series) || !this.isSeriesVisibleInLegend(series)) {
            return null;
        }
        CategoryDataset dataset = p.getDataset(datasetIndex);
        String description = label = this.legendItemLabelGenerator.generateLabel(dataset, series);
        String toolTipText = null;
        if (this.legendItemToolTipGenerator != null) {
            toolTipText = this.legendItemToolTipGenerator.generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.legendItemURLGenerator != null) {
            urlText = this.legendItemURLGenerator.generateLabel(dataset, series);
        }
        Shape shape = this.lookupLegendShape(series);
        PaintType paintType = this.lookupSeriesPaintType(series);
        PaintType outlinePaintType = this.lookupSeriesOutlinePaintType(series);
        Float outlineStroke = this.lookupSeriesOutlineStroke(series);
        LegendItem item = new LegendItem(label, description, toolTipText, urlText, shape, paintType, outlineStroke.floatValue(), outlinePaintType);
        item.setLabelFont(this.lookupLegendTextFont(series));
        PaintType labelPaintType = this.lookupLegendTextPaintType(series);
        if (labelPaintType != null) {
            item.setLabelPaintType(labelPaintType);
        }
        item.setSeriesKey(dataset.getRowKey(series));
        item.setSeriesIndex(series);
        item.setDataset(dataset);
        item.setDatasetIndex(datasetIndex);
        return item;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        CategoryPlot cp = this.getPlot();
        if (cp != null) {
            result = cp.getDrawingSupplier();
        }
        return result;
    }

    protected void updateCrosshairValues(CategoryCrosshairState crosshairState, Comparable rowKey, Comparable columnKey, double value, int datasetIndex, double transX, double transY, PlotOrientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairPoint(rowKey, columnKey, value, datasetIndex, transX, transY, orientation);
            } else {
                crosshairState.updateCrosshairX(rowKey, columnKey, datasetIndex, transX, orientation);
            }
        }
    }

    protected void drawItemLabel(Canvas canvas, PlotOrientation orientation, CategoryDataset dataset, int row, int column, double x, double y, boolean negative) {
        CategoryItemLabelGenerator generator = this.getItemLabelGenerator(row, column);
        if (generator != null) {
            String label = generator.generateLabel(dataset, row, column);
            ItemLabelPosition position = null;
            position = !negative ? this.getPositiveItemLabelPosition(row, column) : this.getNegativeItemLabelPosition(row, column);
            PointF anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
            Paint paint = PaintUtility.createPaint(1, this.getItemLabelPaintType(row, column), this.getItemLabelFont(row, column));
            TextUtilities.drawRotatedString(label, canvas, anchorPoint.x, anchorPoint.y, position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
        }
    }

    protected CategoryAxis getDomainAxis(CategoryPlot plot, int index) {
        CategoryAxis result = plot.getDomainAxis(index);
        if (result == null) {
            result = plot.getDomainAxis();
        }
        return result;
    }

    protected ValueAxis getRangeAxis(CategoryPlot plot, int index) {
        ValueAxis result = plot.getRangeAxis(index);
        if (result == null) {
            result = plot.getRangeAxis();
        }
        return result;
    }

    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection result = new LegendItemCollection();
        int index = this.plot.getIndexOf(this);
        CategoryDataset dataset = this.plot.getDataset(index);
        if (dataset != null) {
            int seriesCount = dataset.getRowCount();
            int i = 0;
            while (i < seriesCount) {
                LegendItem item;
                if (this.isSeriesVisibleInLegend(i) && (item = this.getLegendItem(index, i)) != null) {
                    result.add(item);
                }
                ++i;
            }
        }
        return result;
    }

    public CategorySeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(CategorySeriesLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = generator;
    }

    public CategorySeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(CategorySeriesLabelGenerator generator) {
        this.legendItemToolTipGenerator = generator;
    }

    public CategorySeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(CategorySeriesLabelGenerator generator) {
        this.legendItemURLGenerator = generator;
    }

    protected void addItemEntity(EntityCollection entities, CategoryDataset dataset, int row, int column, Shape hotspot) {
        if (hotspot == null) {
            throw new IllegalArgumentException("Null 'hotspot' argument.");
        }
        if (!this.getItemCreateEntity(row, column)) {
            return;
        }
        CategoryItemEntity entity = new CategoryItemEntity(hotspot, "", "", dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
        entities.add(entity);
    }

    protected void addEntity(EntityCollection entities, Shape hotspot, CategoryDataset dataset, int row, int column, double entityX, double entityY) {
        if (!this.getItemCreateEntity(row, column)) {
            return;
        }
        Shape s = hotspot;
        if (hotspot == null) {
            double r = this.getDefaultEntityRadius();
            double w = r * 2.0;
            s = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new OvalShape(entityX - r, entityY - r, w, w) : new OvalShape(entityY - r, entityX - r, w, w);
        }
        CategoryItemEntity entity = new CategoryItemEntity(s, "", "", dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
        entities.add(entity);
    }
}

