/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot.dial;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.afree.chart.plot.dial.AbstractDialLayer;
import org.afree.chart.plot.dial.DialLayerChangeEvent;
import org.afree.chart.plot.dial.DialPlot;
import org.afree.chart.plot.dial.DialScale;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class StandardDialScale
extends AbstractDialLayer
implements DialScale,
Cloneable,
Serializable {
    static final long serialVersionUID = 3715644629665918516L;
    private double lowerBound;
    private double upperBound;
    private double startAngle;
    private double extent;
    private double tickRadius;
    private double majorTickIncrement;
    private double majorTickLength;
    private transient Paint majorTickPaint;
    private transient Float majorTickStroke;
    private int minorTickCount;
    private double minorTickLength;
    private transient Paint minorTickPaint;
    private transient Float minorTickStroke;
    private double tickLabelOffset;
    private Font tickLabelFont;
    private boolean tickLabelsVisible;
    private NumberFormat tickLabelFormatter;
    private boolean firstTickLabelVisible;
    private transient Paint tickLabelPaint;

    public StandardDialScale() {
        this(0.0, 100.0, 175.0, -170.0, 10.0, 4);
    }

    public StandardDialScale(double lowerBound, double upperBound, double startAngle, double extent, double majorTickIncrement, int minorTickCount) {
        this.startAngle = startAngle;
        this.extent = extent;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.tickRadius = 0.7;
        this.tickLabelsVisible = true;
        this.tickLabelFormatter = new DecimalFormat("0.0");
        this.firstTickLabelVisible = true;
        this.tickLabelFont = new Font();
        this.tickLabelPaint = new Paint(1);
        this.tickLabelPaint.setColor(-16776961);
        this.tickLabelOffset = 0.1;
        this.majorTickIncrement = majorTickIncrement;
        this.majorTickLength = 0.04;
        this.majorTickPaint = new Paint(1);
        this.majorTickPaint.setColor(-16777216);
        this.majorTickStroke = Float.valueOf(3.0f);
        this.minorTickCount = minorTickCount;
        this.minorTickLength = 0.02;
        this.minorTickPaint = new Paint(1);
        this.minorTickPaint.setColor(-16777216);
        this.minorTickStroke = Float.valueOf(1.0f);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lower) {
        this.lowerBound = lower;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upper) {
        this.upperBound = upper;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double extent) {
        this.extent = extent;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickRadius() {
        return this.tickRadius;
    }

    public void setTickRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("The 'radius' must be positive.");
        }
        this.tickRadius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickIncrement() {
        return this.majorTickIncrement;
    }

    public void setMajorTickIncrement(double increment) {
        if (increment <= 0.0) {
            throw new IllegalArgumentException("The 'increment' must be positive.");
        }
        this.majorTickIncrement = increment;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickLength() {
        return this.majorTickLength;
    }

    public void setMajorTickLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.majorTickLength = length;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMajorTickPaint() {
        return this.majorTickPaint;
    }

    public void setMajorTickPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.majorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Float getMajorTickStroke() {
        return this.majorTickStroke;
    }

    public void setMajorTickStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.majorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("The 'count' cannot be negative.");
        }
        this.minorTickCount = count;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMinorTickLength() {
        return this.minorTickLength;
    }

    public void setMinorTickLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.minorTickLength = length;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMinorTickPaint() {
        return this.minorTickPaint;
    }

    public void setMinorTickPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.minorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Float getMinorTickStroke() {
        return this.minorTickStroke;
    }

    public void setMinorTickStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.minorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double offset) {
        this.tickLabelOffset = offset;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.tickLabelFont = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean visible) {
        this.tickLabelsVisible = visible;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public NumberFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(NumberFormat formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.tickLabelFormatter = formatter;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getFirstTickLabelVisible() {
        return this.firstTickLabelVisible;
    }

    public void setFirstTickLabelVisible(boolean visible) {
        this.firstTickLabelVisible = visible;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Canvas canvas, DialPlot plot, RectShape frame, Shape view) {
        RectShape arcRect = DialPlot.RectShapeByRadius(frame, this.tickRadius, this.tickRadius);
        RectShape arcRectMajor = DialPlot.RectShapeByRadius(frame, this.tickRadius - this.majorTickLength, this.tickRadius - this.majorTickLength);
        RectShape arcRectMinor = arcRect;
        if (this.minorTickCount > 0 && this.minorTickLength > 0.0) {
            arcRectMinor = DialPlot.RectShapeByRadius(frame, this.tickRadius - this.minorTickLength, this.tickRadius - this.minorTickLength);
        }
        RectShape arcRectForLabels = DialPlot.RectShapeByRadius(frame, this.tickRadius - this.tickLabelOffset, this.tickRadius - this.tickLabelOffset);
        boolean firstLabel = true;
        ArcShape arc = new ArcShape();
        LineShape workingLine = new LineShape();
        double v = this.lowerBound;
        while (v <= this.upperBound) {
            arc.setArc(arcRect, this.startAngle, -(this.startAngle - this.valueToAngle(v)), true);
            PointF pt0 = arc.getEndPoint();
            arc.setArc(arcRectMajor, this.startAngle, -(this.startAngle - this.valueToAngle(v)), true);
            PointF pt1 = arc.getEndPoint();
            this.majorTickPaint.setStrokeWidth(this.majorTickStroke.floatValue());
            workingLine.setLine(pt0, pt1);
            workingLine.draw(canvas, this.majorTickPaint);
            arc.setArc(arcRectForLabels, this.startAngle, -(this.startAngle - this.valueToAngle(v)), true);
            PointF pt2 = arc.getEndPoint();
            if (this.tickLabelsVisible && (!firstLabel || this.firstTickLabelVisible)) {
                this.tickLabelPaint.setTypeface(this.tickLabelFont.getTypeFace());
                this.tickLabelPaint.setTextSize((float)this.tickLabelFont.getSize());
                this.tickLabelPaint.setTextAlign(Paint.Align.CENTER);
                canvas.drawText(this.tickLabelFormatter.format(v), pt2.x, pt2.y, this.tickLabelPaint);
            }
            firstLabel = false;
            if (this.minorTickCount > 0 && this.minorTickLength > 0.0) {
                double minorTickIncrement = this.majorTickIncrement / (double)(this.minorTickCount + 1);
                int i = 0;
                while (i < this.minorTickCount) {
                    double vv = v + (double)(i + 1) * minorTickIncrement;
                    if (vv >= this.upperBound) break;
                    double angle = this.valueToAngle(vv);
                    arc.setArc(arcRect, this.startAngle, -(this.startAngle - angle), true);
                    pt0 = arc.getEndPoint();
                    arc.setArc(arcRectMinor, this.startAngle, -(this.startAngle - angle), true);
                    PointF pt3 = arc.getEndPoint();
                    this.minorTickPaint.setStrokeWidth(this.minorTickStroke.floatValue());
                    workingLine.setLine(pt0, pt3);
                    workingLine.draw(canvas, this.minorTickPaint);
                    ++i;
                }
            }
            v += this.majorTickIncrement;
        }
    }

    public double valueToAngle(double value) {
        double range = this.upperBound - this.lowerBound;
        double unit = this.extent / range;
        return this.startAngle + unit * (value - this.lowerBound);
    }

    public double angleToValue(double angle) {
        return Double.NaN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardDialScale)) {
            return false;
        }
        StandardDialScale that = (StandardDialScale)obj;
        if (this.lowerBound != that.lowerBound) {
            return false;
        }
        if (this.upperBound != that.upperBound) {
            return false;
        }
        if (this.startAngle != that.startAngle) {
            return false;
        }
        if (this.extent != that.extent) {
            return false;
        }
        if (this.tickRadius != that.tickRadius) {
            return false;
        }
        if (this.majorTickIncrement != that.majorTickIncrement) {
            return false;
        }
        if (this.majorTickLength != that.majorTickLength) {
            return false;
        }
        if (!this.majorTickStroke.equals(that.majorTickStroke)) {
            return false;
        }
        if (this.minorTickCount != that.minorTickCount) {
            return false;
        }
        if (this.minorTickLength != that.minorTickLength) {
            return false;
        }
        if (!this.minorTickStroke.equals(that.minorTickStroke)) {
            return false;
        }
        if (this.tickLabelsVisible != that.tickLabelsVisible) {
            return false;
        }
        if (this.tickLabelOffset != that.tickLabelOffset) {
            return false;
        }
        if (!this.tickLabelFont.equals(that.tickLabelFont)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 193;
        long temp = Double.doubleToLongBits(this.lowerBound);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upperBound);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.startAngle);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.extent);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.tickRadius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

