/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.graphics.Region;
import java.io.Serializable;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.PieSectionEntity;
import org.afree.chart.plot.PiePlot;
import org.afree.chart.plot.PiePlotState;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.data.general.PieDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleInsets;
import org.afree.util.Rotation;
import org.afree.util.UnitType;

public class RingPlot
extends PiePlot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1556064784129676620L;
    private boolean separatorsVisible = true;
    private transient float separatorStroke = 0.5f;
    private transient PathEffect separatorEffect = null;
    private transient PaintType separatorPaintType = new SolidColor(-7829368);
    private double innerSeparatorExtension = 0.2;
    private double outerSeparatorExtension = 0.2;
    private double sectionDepth = 0.2;

    public RingPlot() {
        this(null);
    }

    public RingPlot(PieDataset dataset) {
        super(dataset);
    }

    public boolean getSeparatorsVisible() {
        return this.separatorsVisible;
    }

    public void setSeparatorsVisible(boolean visible) {
        this.separatorsVisible = visible;
    }

    public Float getSeparatorStroke() {
        return Float.valueOf(this.separatorStroke);
    }

    public void setSeparatorStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.separatorStroke = stroke.floatValue();
    }

    public PaintType getSeparatorPaintType() {
        return this.separatorPaintType;
    }

    public void setSeparatorPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.separatorPaintType = paintType;
    }

    public PathEffect getSeparatorEffect() {
        return this.separatorEffect;
    }

    public void setSeparatorEffect(PathEffect effect) {
        this.separatorEffect = effect;
    }

    public double getInnerSeparatorExtension() {
        return this.innerSeparatorExtension;
    }

    public void setInnerSeparatorExtension(double percent) {
        this.innerSeparatorExtension = percent;
    }

    public double getOuterSeparatorExtension() {
        return this.outerSeparatorExtension;
    }

    public void setOuterSeparatorExtension(double percent) {
        this.outerSeparatorExtension = percent;
    }

    public double getSectionDepth() {
        return this.sectionDepth;
    }

    public void setSectionDepth(double sectionDepth) {
        this.sectionDepth = sectionDepth;
    }

    public PiePlotState initialise(Canvas canvas, RectShape plotArea, PiePlot plot, Integer index, PlotRenderingInfo info) {
        PiePlotState state = super.initialise(canvas, plotArea, plot, index, info);
        state.setPassesRequired(3);
        return state;
    }

    protected void drawItem(Canvas canvas, int section, RectShape dataArea, PiePlotState state, int currentPass, int alpha) {
        canvas.save();
        PieDataset dataset = this.getDataset();
        Number n = dataset.getValue(section);
        if (n == null) {
            return;
        }
        double value = n.doubleValue();
        double angle1 = 0.0;
        double angle2 = 0.0;
        Rotation direction = this.getDirection();
        if (direction == Rotation.CLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 - value / state.getTotal() * 360.0;
        } else if (direction == Rotation.ANTICLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 + value / state.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double angle = angle2 - angle1;
        if (Math.abs(angle) > this.getMinimumArcAngleToDraw()) {
            Comparable key = this.getSectionKey(section);
            double ep = 0.0;
            double mep = this.getMaximumExplodePercent();
            if (mep > 0.0) {
                ep = this.getExplodePercent(key) / mep;
            }
            RectShape arcBounds = this.getArcBounds(state.getPieArea(), state.getExplodedPieArea(), angle1, angle, ep);
            ArcShape arc = new ArcShape(arcBounds, angle1, angle, true);
            double depth = this.sectionDepth / 2.0;
            RectangleInsets s = new RectangleInsets(UnitType.RELATIVE, depth, depth, depth, depth);
            RectShape innerArcBounds = new RectShape();
            innerArcBounds.setRect(arcBounds);
            s.trim(innerArcBounds);
            ArcShape arc2 = new ArcShape(innerArcBounds, angle1 + angle, -angle, true);
            LineShape separator = new LineShape(arc2.getEndPoint(), arc.getStartPoint());
            if (currentPass == 0) {
                Paint shadowPaint = this.getShadowPaint();
                double shadowXOffset = this.getShadowXOffset();
                double shadowYOffset = this.getShadowYOffset();
                if (shadowPaint != null) {
                    Matrix mat = new Matrix();
                    mat.postTranslate((float)shadowXOffset, (float)shadowYOffset);
                    Path sArc1 = new Path(arc.getPath());
                    Path sArc2 = new Path(arc2.getPath());
                    sArc1.transform(mat);
                    sArc2.transform(mat);
                    canvas.clipPath(arc.getPath());
                    canvas.clipPath(arc2.getPath(), Region.Op.XOR);
                    arc.fill(canvas, shadowPaint);
                }
            } else if (currentPass == 1) {
                EntityCollection entities;
                canvas.save();
                Paint paint = PaintUtility.createPaint(1, this.lookupSectionPaintType(key));
                canvas.clipPath(arc.getPath());
                canvas.clipPath(arc2.getPath(), Region.Op.XOR);
                arc.fill(canvas, paint);
                canvas.restore();
                PaintType outlinePaintType = this.lookupSectionOutlinePaintType(key);
                Float outlineStroke = this.lookupSectionOutlineStroke(key);
                PathEffect outlineEffect = this.lookupSectionOutlineEffect(key);
                Paint outlinePaint = PaintUtility.createPaint(1, outlinePaintType, outlineStroke.floatValue(), outlineEffect);
                if (outlinePaint != null && outlineStroke != null) {
                    outlinePaint.setStyle(Paint.Style.STROKE);
                    outlinePaint.setStrokeWidth(outlineStroke.floatValue());
                    Path path = new Path();
                    path.arcTo(new RectF(arc.getMinX(), arc.getMinY(), arc.getMaxX(), arc.getMaxY()), (float)angle1, (float)angle);
                    path.lineTo(arc2.getStartPoint().x, arc2.getStartPoint().y);
                    path.arcTo(new RectF(arc2.getMinX(), arc2.getMinY(), arc2.getMaxX(), arc2.getMaxY()), (float)(angle1 + angle), (float)(-angle));
                    path.close();
                    canvas.drawPath(path, outlinePaint);
                }
                if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                    String tip = null;
                    String url = null;
                    PieSectionEntity entity = new PieSectionEntity(arc, dataset, this.getPieIndex(), section, key, tip, url);
                    entities.add(entity);
                }
            } else if (currentPass == 2 && this.separatorsVisible) {
                LineShape extendedSeparator = this.extendLine(separator, this.innerSeparatorExtension, this.outerSeparatorExtension);
                Paint paint = PaintUtility.createPaint(1, this.separatorPaintType, this.separatorStroke, this.separatorEffect);
                extendedSeparator.draw(canvas, paint);
            }
        }
        state.setLatestAngle(angle2);
        canvas.restore();
    }

    protected double getLabelLinkDepth() {
        return Math.min(super.getLabelLinkDepth(), this.getSectionDepth() / 2.0);
    }

    private LineShape extendLine(LineShape line, double startPercent, double endPercent) {
        if (line == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        double x1 = line.getX1();
        double x2 = line.getX2();
        double deltaX = x2 - x1;
        double y1 = line.getY1();
        double y2 = line.getY2();
        double deltaY = y2 - y1;
        return new LineShape(x1 -= startPercent * deltaX, y1 -= startPercent * deltaY, x2 += endPercent * deltaX, y2 += endPercent * deltaY);
    }
}

