/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.afree.chart.EffectMap;
import org.afree.chart.LegendItem;
import org.afree.chart.LegendItemCollection;
import org.afree.chart.PaintTypeMap;
import org.afree.chart.StrokeMap;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.PieSectionEntity;
import org.afree.chart.labels.PieSectionLabelGenerator;
import org.afree.chart.labels.StandardPieSectionLabelGenerator;
import org.afree.chart.plot.AbstractPieLabelDistributor;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.PieLabelDistributor;
import org.afree.chart.plot.PieLabelLinkStyle;
import org.afree.chart.plot.PieLabelRecord;
import org.afree.chart.plot.PiePlotState;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.chart.text.G2TextMeasurer;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextBox;
import org.afree.chart.text.TextUtilities;
import org.afree.data.DefaultKeyedValues;
import org.afree.data.KeyedValues;
import org.afree.data.general.DatasetChangeEvent;
import org.afree.data.general.DatasetUtilities;
import org.afree.data.general.PieDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.CubicCurveShape;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.QuadCurveShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleInsets;
import org.afree.ui.TextAnchor;
import org.afree.util.Rotation;
import org.afree.util.ShapeUtilities;
import org.afree.util.UnitType;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -795612466005590431L;
    public static final double DEFAULT_INTERIOR_GAP = 0.08;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = -90.0;
    public static final Font DEFAULT_LABEL_FONT_TYPE = new Font("SansSerif", 0, 10);
    public static final PaintType DEFAULT_LABEL_PAINT_TYPE = new SolidColor(-16777216);
    public static final PaintType DEFAULT_LABEL_BACKGROUND_PAINT_TYPE = new SolidColor(Color.rgb((int)255, (int)255, (int)192));
    public static final PaintType DEFAULT_LABEL_OUTLINE_PAINT_TYPE = new SolidColor(-16777216);
    public static final float DEFAULT_LABEL_OUTLINE_STROKE = 0.5f;
    public static final PathEffect DEFAULT_LABEL_OUTLINE_EFFECT = null;
    public static final PaintType DEFAULT_LABEL_SHADOW_PAINT_TYPE = new SolidColor(Color.argb((int)128, (int)151, (int)151, (int)151));
    public static final PaintType DEFAULT_SHADOW_PAINT = new SolidColor(-3355444);
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private PaintTypeMap sectionPaintTypeMap;
    private transient PaintType baseSectionPaintType;
    private boolean autoPopulateSectionPaint;
    private boolean sectionOutlinesVisible;
    private PaintTypeMap sectionOutlinePaintTypeMap;
    private transient PaintType baseSectionOutlinePaintType;
    private boolean autoPopulateSectionOutlinePaint;
    private StrokeMap sectionOutlineStrokeMap;
    private EffectMap sectionOutlineEffectMap;
    private transient float baseSectionOutlineStroke;
    private transient PathEffect baseSectionOutlineEffect;
    private boolean autoPopulateSectionOutlineStroke;
    private boolean autoPopulateSectionOutlineEffect;
    private transient Paint shadowPaint = null;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private Map explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient PaintType labelPaintType;
    private transient PaintType labelBackgroundPaintType;
    private transient PaintType labelOutlinePaintType;
    private transient Float labelOutlineStroke;
    private transient PathEffect labelOutlineEffect;
    private transient PaintType labelShadowPaintType;
    private boolean simpleLabels = true;
    private RectangleInsets labelPadding;
    private RectangleInsets simpleLabelOffset;
    private double maximumLabelWidth = 0.14;
    private double labelGap = 0.025;
    private boolean labelLinksVisible;
    private PieLabelLinkStyle labelLinkStyle = PieLabelLinkStyle.STANDARD;
    private double labelLinkMargin = 0.025;
    private transient PaintType labelLinkPaintType = DEFAULT_LABEL_PAINT_TYPE;
    private transient float labelLinkStroke = 2.0f;
    private transient PathEffect labelLinkEffect = null;
    private AbstractPieLabelDistributor labelDistributor;
    private PieSectionLabelGenerator legendLabelGenerator;
    private PieSectionLabelGenerator legendLabelToolTipGenerator;
    private boolean ignoreNullValues;
    private boolean ignoreZeroValues;
    private transient Shape legendItemShape;
    private double minimumArcAngleToDraw;
    static final boolean DEBUG_DRAW_INTERIOR = false;
    static final boolean DEBUG_DRAW_LINK_AREA = false;
    static final boolean DEBUG_DRAW_PIE_AREA = false;
    private transient PaintType sectionPaint;
    private transient PaintType sectionOutlinePaintType;
    private transient Float sectionOutlineStroke;
    private transient PathEffect sectionOutlineEffect;

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset dataset) {
        this.dataset = dataset;
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.08;
        this.circular = true;
        this.startAngle = -90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintTypeMap = new PaintTypeMap();
        this.baseSectionPaintType = new SolidColor(-7829368);
        this.autoPopulateSectionPaint = true;
        this.sectionOutlinesVisible = true;
        this.sectionOutlinePaintType = null;
        this.sectionOutlinePaintTypeMap = new PaintTypeMap();
        this.baseSectionOutlinePaintType = DEFAULT_OUTLINE_PAINT_TYPE;
        this.autoPopulateSectionOutlinePaint = false;
        this.sectionOutlineStrokeMap = new StrokeMap();
        this.sectionOutlineEffectMap = new EffectMap();
        this.baseSectionOutlineStroke = 0.5f;
        this.autoPopulateSectionOutlineStroke = false;
        this.explodePercentages = new TreeMap();
        this.labelGenerator = new StandardPieSectionLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT_TYPE;
        this.labelPaintType = DEFAULT_LABEL_PAINT_TYPE;
        this.labelBackgroundPaintType = DEFAULT_LABEL_BACKGROUND_PAINT_TYPE;
        this.labelOutlinePaintType = DEFAULT_LABEL_OUTLINE_PAINT_TYPE;
        this.labelOutlineStroke = Float.valueOf(0.5f);
        this.labelOutlineEffect = DEFAULT_LABEL_OUTLINE_EFFECT;
        this.labelShadowPaintType = DEFAULT_LABEL_SHADOW_PAINT_TYPE;
        this.labelLinksVisible = true;
        this.labelDistributor = new PieLabelDistributor(0);
        this.simpleLabels = false;
        this.simpleLabelOffset = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        this.labelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.legendLabelGenerator = new StandardPieSectionLabelGenerator();
        this.legendLabelToolTipGenerator = null;
        this.legendItemShape = Plot.DEFAULT_LEGEND_ITEM_CIRCLE;
        this.ignoreNullValues = false;
        this.ignoreZeroValues = false;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset dataset) {
        PieDataset existing = this.dataset;
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int index) {
        this.pieIndex = index;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = direction;
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("Invalid 'percent' (" + percent + ") argument.");
        }
        if (this.interiorGap != percent) {
            this.interiorGap = percent;
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean flag) {
        this.setCircular(flag, true);
    }

    public void setCircular(boolean circular, boolean notify) {
        this.circular = circular;
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean flag) {
        this.ignoreNullValues = flag;
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean flag) {
        this.ignoreZeroValues = flag;
    }

    protected PaintType lookupSectionPaintType(Comparable key) {
        return this.lookupSectionPaintType(key, this.getAutoPopulateSectionPaint());
    }

    protected PaintType lookupSectionPaintType(Comparable key, boolean autoPopulate) {
        PaintType result = this.getSectionPaintType();
        if (result != null) {
            return result;
        }
        result = this.sectionPaintTypeMap.getPaintType(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = ds.getNextPaintType();
                this.sectionPaintTypeMap.put(key, result);
            } else {
                result = this.baseSectionPaintType;
            }
        } else {
            result = this.baseSectionPaintType;
        }
        return result;
    }

    public PaintType getSectionPaintType() {
        return this.sectionPaint;
    }

    protected Comparable getSectionKey(int section) {
        Comparable<Integer> key = null;
        if (this.dataset != null && section >= 0 && section < this.dataset.getItemCount()) {
            key = this.dataset.getKey(section);
        }
        if (key == null) {
            key = new Integer(section);
        }
        return key;
    }

    public PaintType getSectionPaint(Comparable key) {
        return this.sectionPaintTypeMap.getPaintType(key);
    }

    public void setSectionPaintType(Comparable key, PaintType paintType) {
        this.sectionPaintTypeMap.put(key, paintType);
    }

    public void clearSectionPaints(boolean notify) {
        this.sectionPaintTypeMap.clear();
    }

    public PaintType getBaseSectionPaintType() {
        return this.baseSectionPaintType;
    }

    public void setBaseSectionPainTypet(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaintType = paintType;
    }

    public boolean getAutoPopulateSectionPaint() {
        return this.autoPopulateSectionPaint;
    }

    public void setAutoPopulateSectionPaint(boolean auto) {
        this.autoPopulateSectionPaint = auto;
    }

    public boolean getSectionOutlinesVisible() {
        return this.sectionOutlinesVisible;
    }

    public void setSectionOutlinesVisible(boolean visible) {
        this.sectionOutlinesVisible = visible;
    }

    protected PaintType lookupSectionOutlinePaintType(Comparable key) {
        return this.lookupSectionOutlinePaintType(key, this.getAutoPopulateSectionOutlinePaint());
    }

    protected PaintType lookupSectionOutlinePaintType(Comparable key, boolean autoPopulate) {
        PaintType result = this.getSectionOutlinePaintType();
        if (result != null) {
            return result;
        }
        result = this.sectionOutlinePaintTypeMap.getPaintType(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = ds.getNextOutlinePaintType();
                this.sectionOutlinePaintTypeMap.put(key, result);
            } else {
                result = this.baseSectionOutlinePaintType;
            }
        } else {
            result = this.baseSectionOutlinePaintType;
        }
        return result;
    }

    public PaintType getSectionOutlinePaintType(Comparable key) {
        return this.sectionOutlinePaintTypeMap.getPaintType(key);
    }

    public void setSectionOutlinePaintType(Comparable key, PaintType paintType) {
        this.sectionOutlinePaintTypeMap.put(key, paintType);
    }

    public void clearSectionOutlinePaints(boolean notify) {
        this.sectionOutlinePaintTypeMap.clear();
    }

    public PaintType getBaseSectionOutlinePaintType() {
        return this.baseSectionOutlinePaintType;
    }

    public void setBaseSectionOutlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaintType = paintType;
    }

    public boolean getAutoPopulateSectionOutlinePaint() {
        return this.autoPopulateSectionOutlinePaint;
    }

    public void setAutoPopulateSectionOutlinePaint(boolean auto) {
        this.autoPopulateSectionOutlinePaint = auto;
    }

    protected Float lookupSectionOutlineStroke(Comparable key) {
        return this.lookupSectionOutlineStroke(key, this.getAutoPopulateSectionOutlineStroke());
    }

    protected Float lookupSectionOutlineStroke(Comparable key, boolean autoPopulate) {
        Float result = this.getSectionOutlineStroke();
        if (result != null) {
            return result;
        }
        result = this.sectionOutlineStrokeMap.getStroke(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = Float.valueOf(ds.getNextOutlineStroke());
                this.sectionOutlineStrokeMap.put(key, result);
            } else {
                result = Float.valueOf(this.baseSectionOutlineStroke);
            }
        } else {
            result = Float.valueOf(this.baseSectionOutlineStroke);
        }
        return result;
    }

    protected PathEffect lookupSectionOutlineEffect(Comparable key) {
        return this.lookupSectionOutlineEffect(key, this.getAutoPopulateSectionOutlineEffect());
    }

    protected PathEffect lookupSectionOutlineEffect(Comparable key, boolean autoPopulate) {
        PathEffect result = this.getSectionOutlineEffect();
        if (result != null) {
            return result;
        }
        result = this.sectionOutlineEffectMap.getEffect(key);
        if (result != null) {
            return result;
        }
        if (autoPopulate) {
            DrawingSupplier ds = this.getDrawingSupplier();
            if (ds != null) {
                result = ds.getNextOutlineEffect();
                this.sectionOutlineEffectMap.put(key, result);
            } else {
                result = this.baseSectionOutlineEffect;
            }
        } else {
            result = this.baseSectionOutlineEffect;
        }
        return result;
    }

    public Float getSectionOutlineStroke(Comparable key) {
        return this.sectionOutlineStrokeMap.getStroke(key);
    }

    public void setSectionOutlineStroke(Comparable key, Float stroke) {
        this.sectionOutlineStrokeMap.put(key, stroke);
    }

    public PathEffect getSectionOutlineEffect(Comparable key) {
        return this.sectionOutlineEffectMap.getEffect(key);
    }

    public void setSectionOutlineEffect(Comparable key, PathEffect effect) {
        this.sectionOutlineEffectMap.put(key, effect);
    }

    public void clearSectionOutlineStrokes(boolean notify) {
        this.sectionOutlineStrokeMap.clear();
    }

    public Float getBaseSectionOutlineStroke() {
        return Float.valueOf(this.baseSectionOutlineStroke);
    }

    public void setBaseSectionOutlineStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke.floatValue();
    }

    public PathEffect getBaseSectionOutlineEffect() {
        return this.baseSectionOutlineEffect;
    }

    public void setBaseSectionOutlineEffect(PathEffect effect) {
        if (effect == null) {
            throw new IllegalArgumentException("Null 'effect' argument.");
        }
        this.baseSectionOutlineEffect = effect;
    }

    public boolean getAutoPopulateSectionOutlineStroke() {
        return this.autoPopulateSectionOutlineStroke;
    }

    public boolean getAutoPopulateSectionOutlineEffect() {
        return this.autoPopulateSectionOutlineEffect;
    }

    public void setAutoPopulateSectionOutlineStroke(boolean auto) {
        this.autoPopulateSectionOutlineStroke = auto;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public double getExplodePercent(Comparable key) {
        Number percent;
        double result = 0.0;
        if (this.explodePercentages != null && (percent = (Number)this.explodePercentages.get(key)) != null) {
            result = percent.doubleValue();
        }
        return result;
    }

    public void setExplodePercent(Comparable key, double percent) {
        if (key == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.explodePercentages == null) {
            this.explodePercentages = new TreeMap();
        }
        this.explodePercentages.put(key, new Double(percent));
    }

    public double getMaximumExplodePercent() {
        if (this.dataset == null) {
            return 0.0;
        }
        double result = 0.0;
        for (Comparable key : this.dataset.getKeys()) {
            Number explode = (Number)this.explodePercentages.get(key);
            if (explode == null) continue;
            result = Math.max(result, explode.doubleValue());
        }
        return result;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator generator) {
        this.labelGenerator = generator;
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double gap) {
        this.labelGap = gap;
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double width) {
        this.maximumLabelWidth = width;
    }

    public boolean getLabelLinksVisible() {
        return this.labelLinksVisible;
    }

    public void setLabelLinksVisible(boolean visible) {
        this.labelLinksVisible = visible;
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("Null 'style' argument.");
        }
        this.labelLinkStyle = style;
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double margin) {
        this.labelLinkMargin = margin;
    }

    public PaintType getLabelLinkPaintType() {
        return this.labelLinkPaintType;
    }

    public void setLabelLinkPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaintType = paintType;
    }

    public Float getLabelLinkStroke() {
        return Float.valueOf(this.labelLinkStroke);
    }

    public void setLabelLinkStroke(Float stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke.floatValue();
    }

    protected double getLabelLinkDepth() {
        return 0.1;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
    }

    public PaintType getLabelPaintType() {
        return this.labelPaintType;
    }

    public void setLabelPaint(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaintType = paintType;
    }

    public PaintType getLabelBackgroundPaintType() {
        return this.labelBackgroundPaintType;
    }

    public void setLabelBackgroundPaintType(PaintType paintType) {
        this.labelBackgroundPaintType = paintType;
    }

    public PaintType getLabelOutlinePaintType() {
        return this.labelOutlinePaintType;
    }

    public void setLabelOutlinePaint(PaintType paintType) {
        this.labelOutlinePaintType = paintType;
    }

    public Float getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Float stroke) {
        this.labelOutlineStroke = stroke;
    }

    public PaintType getLabelShadowPaintType() {
        return this.labelShadowPaintType;
    }

    public void setLabelShadowPaint(PaintType paintType) {
        this.labelShadowPaintType = paintType;
    }

    public RectangleInsets getLabelPadding() {
        return this.labelPadding;
    }

    public void setLabelPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.labelPadding = padding;
    }

    public boolean getSimpleLabels() {
        return this.simpleLabels;
    }

    public void setSimpleLabels(boolean simple) {
        this.simpleLabels = simple;
    }

    public RectangleInsets getSimpleLabelOffset() {
        return this.simpleLabelOffset;
    }

    public void setSimpleLabelOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.simpleLabelOffset = offset;
    }

    public AbstractPieLabelDistributor getLabelDistributor() {
        return this.labelDistributor;
    }

    public void setLabelDistributor(AbstractPieLabelDistributor distributor) {
        if (distributor == null) {
            throw new IllegalArgumentException("Null 'distributor' argument.");
        }
        this.labelDistributor = distributor;
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double angle) {
        this.minimumArcAngleToDraw = angle;
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
    }

    public PieSectionLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieSectionLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendLabelGenerator = generator;
    }

    public PieSectionLabelGenerator getLegendLabelToolTipGenerator() {
        return this.legendLabelToolTipGenerator;
    }

    public void setLegendLabelToolTipGenerator(PieSectionLabelGenerator generator) {
        this.legendLabelToolTipGenerator = generator;
    }

    public PiePlotState initialise(Canvas canvas, RectShape plotArea, PiePlot plot, Integer index, PlotRenderingInfo info) {
        PiePlotState state = new PiePlotState(info);
        state.setPassesRequired(2);
        if (this.dataset != null) {
            state.setTotal(DatasetUtilities.calculatePieDatasetTotal(plot.getDataset()));
        }
        state.setLatestAngle(plot.getStartAngle());
        return state;
    }

    public void draw(Canvas canvas, RectShape area, PointF anchor, PlotState parentState, PlotRenderingInfo info) {
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(canvas, area);
        this.drawOutline(canvas, area);
        canvas.save();
        canvas.clipRect(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY());
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawPie(canvas, area, info, this.getForegroundAlpha());
        } else {
            this.drawNoDataMessage(canvas, area);
        }
        canvas.restore();
        this.drawOutline(canvas, area);
    }

    protected void drawPie(Canvas canvas, RectShape plotArea, PlotRenderingInfo info, int alpha) {
        PiePlotState state = this.initialise(canvas, plotArea, this, null, info);
        double labelReserve = 0.0;
        if (this.labelGenerator != null && !this.simpleLabels) {
            labelReserve = this.labelGap + this.maximumLabelWidth;
        }
        double gapHorizontal = (double)plotArea.getWidth() * (this.interiorGap + labelReserve) * 2.0;
        double gapVertical = (double)plotArea.getHeight() * this.interiorGap * 2.0;
        double linkX = (double)plotArea.getX() + gapHorizontal / 2.0;
        double linkY = (double)plotArea.getY() + gapVertical / 2.0;
        double linkW = (double)plotArea.getWidth() - gapHorizontal;
        double linkH = (double)plotArea.getHeight() - gapVertical;
        if (this.circular) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        RectShape linkArea = new RectShape(linkX, linkY, linkW, linkH);
        state.setLinkArea(linkArea);
        double lm = 0.0;
        if (!this.simpleLabels) {
            lm = this.labelLinkMargin;
        }
        double hh = (double)linkArea.getWidth() * lm * 2.0;
        double vv = (double)linkArea.getHeight() * lm * 2.0;
        RectShape explodeArea = new RectShape(linkX + hh / 2.0, linkY + vv / 2.0, linkW - hh, linkH - vv);
        state.setExplodedPieArea(explodeArea);
        double maximumExplodePercent = this.getMaximumExplodePercent();
        double percent = maximumExplodePercent / (1.0 + maximumExplodePercent);
        double h1 = (double)explodeArea.getWidth() * percent;
        double v1 = (double)explodeArea.getHeight() * percent;
        RectShape pieArea = new RectShape((double)explodeArea.getX() + h1 / 2.0, (double)explodeArea.getY() + v1 / 2.0, (double)explodeArea.getWidth() - h1, (double)explodeArea.getHeight() - v1);
        state.setPieArea(pieArea);
        state.setPieCenterX(pieArea.getCenterX());
        state.setPieCenterY(pieArea.getCenterY());
        state.setPieWRadius((double)pieArea.getWidth() / 2.0);
        state.setPieHRadius((double)pieArea.getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List keys = this.dataset.getKeys();
            double totalValue = DatasetUtilities.calculatePieDatasetTotal(this.dataset);
            int passesRequired = state.getPassesRequired();
            int pass = 0;
            while (pass < passesRequired) {
                double runningTotal = 0.0;
                int section = 0;
                while (section < keys.size()) {
                    double value;
                    Number n = this.dataset.getValue(section);
                    if (n != null && (value = n.doubleValue()) > 0.0) {
                        runningTotal += value;
                        this.drawItem(canvas, section, explodeArea, state, pass, alpha);
                    }
                    ++section;
                }
                ++pass;
            }
            if (this.simpleLabels) {
                this.drawSimpleLabels(canvas, keys, totalValue, plotArea, linkArea, state, alpha);
            } else {
                this.drawLabels(canvas, keys, totalValue, plotArea, linkArea, state, alpha);
            }
        } else {
            this.drawNoDataMessage(canvas, plotArea);
        }
    }

    protected void drawItem(Canvas canvas, int section, RectShape dataArea, PiePlotState state, int currentPass, int alpha) {
        Number n = this.dataset.getValue(section);
        if (n == null) {
            return;
        }
        double value = n.doubleValue();
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 + value / state.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            angle1 = state.getLatestAngle();
            angle2 = angle1 - value / state.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double angle = angle2 - angle1;
        if (Math.abs(angle) > this.getMinimumArcAngleToDraw()) {
            double ep = 0.0;
            double mep = this.getMaximumExplodePercent();
            if (mep > 0.0) {
                ep = this.getExplodePercent(section) / mep;
            }
            RectShape arcBounds = this.getArcBounds(state.getPieArea(), state.getExplodedPieArea(), angle1, angle, ep);
            ArcShape arc = new ArcShape(arcBounds, angle1, angle, true);
            if (currentPass == 0) {
                if (this.shadowPaint != null) {
                    this.shadowPaint.setAlpha(alpha);
                    this.shadowPaint.setStyle(Paint.Style.FILL);
                    arc.translate((float)this.shadowXOffset, (float)this.shadowYOffset);
                    arc.fill(canvas, this.shadowPaint);
                }
            } else if (currentPass == 1) {
                EntityCollection entities;
                Comparable key = this.getSectionKey(section);
                Paint paint = PaintUtility.createPaint(1, this.lookupSectionPaintType(key));
                paint.setAlpha(alpha);
                arc.fill(canvas, paint);
                Paint outlinePaint = PaintUtility.createPaint(1, this.lookupSectionOutlinePaintType(key), this.lookupSectionOutlineStroke(key).floatValue(), this.lookupSectionOutlineEffect(key));
                outlinePaint.setAlpha(alpha);
                if (this.sectionOutlinesVisible) {
                    outlinePaint.setStyle(Paint.Style.STROKE);
                    outlinePaint.setStrokeMiter(90.0f);
                    outlinePaint.setStrokeJoin(Paint.Join.MITER);
                    arc.draw(canvas, outlinePaint);
                }
                if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
                    String tip = null;
                    String url = null;
                    PieSectionEntity entity = new PieSectionEntity(arc, this.dataset, this.pieIndex, section, key, tip, url);
                    entities.add(entity);
                }
            }
        }
        state.setLatestAngle(angle2);
    }

    public void drawSimpleLabels(Canvas canvas, List keys, double totalValue, RectShape adjustedPlotArea, RectShape linkArea, PiePlotState state) {
        int alpha = this.getForegroundAlpha();
        this.drawSimpleLabels(canvas, keys, totalValue, adjustedPlotArea, linkArea, state, alpha);
    }

    protected void drawSimpleLabels(Canvas canvas, List keys, double totalValue, RectShape plotArea, RectShape pieArea, PiePlotState state, int alpha) {
        int oldAlpha = this.labelPaintType.getAlpha();
        RectangleInsets labelInsets = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        RectShape labelsArea = labelInsets.createInsetRectShape(pieArea);
        double runningTotal = 0.0;
        for (Comparable key : keys) {
            String label;
            boolean include = true;
            double v = 0.0;
            Number n = this.getDataset().getValue(key);
            if (n == null) {
                include = !this.getIgnoreNullValues();
            } else {
                v = n.doubleValue();
                boolean bl = this.getIgnoreZeroValues() ? v > 0.0 : (include = v >= 0.0);
            }
            if (!include) continue;
            double mid = this.getStartAngle() + this.getDirection().getFactor() * (((runningTotal += v) - v / 2.0) * 360.0) / totalValue;
            ArcShape arc = new ArcShape(labelsArea, this.getStartAngle(), -(mid - this.getStartAngle()), true);
            int x = (int)arc.getEndPoint().x;
            int y = (int)arc.getEndPoint().y;
            PieSectionLabelGenerator labelGenerator = this.getLabelGenerator();
            if (labelGenerator == null || (label = labelGenerator.generateSectionLabel(this.dataset, key)) == null) continue;
            Paint paint = PaintUtility.createPaint(1, this.labelPaintType, this.labelFont);
            this.labelPaintType.setAlpha(255);
            RectShape bounds = TextUtilities.getTextBounds(label, paint);
            RectShape out = this.labelPadding.createOutsetRectangle(bounds);
            Shape bg = ShapeUtilities.createTranslatedShape(out, (float)x - bounds.getCenterX(), (float)y - bounds.getCenterY());
            if (this.labelShadowPaintType != null) {
                Shape shadow = ShapeUtilities.createTranslatedShape(bg, this.shadowXOffset, this.shadowYOffset);
                PaintUtility.updatePaint(paint, this.labelShadowPaintType);
                shadow.fill(canvas, paint);
            }
            if (this.labelBackgroundPaintType != null) {
                PaintUtility.updatePaint(paint, this.labelBackgroundPaintType);
                bg.fill(canvas, paint);
            }
            if (this.labelOutlinePaintType != null && this.labelOutlineStroke != null) {
                paint = PaintUtility.createPaint(1, this.labelOutlinePaintType, this.labelOutlineStroke.floatValue(), this.labelOutlineEffect);
                bg.draw(canvas, paint);
            }
            paint = PaintUtility.createPaint(1, this.labelPaintType, this.labelFont);
            TextUtilities.drawAlignedString(this.getLabelGenerator().generateSectionLabel(this.getDataset(), key), canvas, x, y, TextAnchor.CENTER, paint);
        }
        this.labelPaintType.setAlpha(oldAlpha);
    }

    public void drawLabels(Canvas canvas, List keys, double totalValue, RectShape adjustedPlotArea, RectShape linkArea, PiePlotState state) {
        int alpha = this.getForegroundAlpha();
        this.drawLabels(canvas, keys, totalValue, adjustedPlotArea, linkArea, state, alpha);
    }

    protected void drawLabels(Canvas canvas, List keys, double totalValue, RectShape plotArea, RectShape linkArea, PiePlotState state, int alphaa) {
        DefaultKeyedValues leftKeys = new DefaultKeyedValues();
        DefaultKeyedValues rightKeys = new DefaultKeyedValues();
        double runningTotal = 0.0;
        for (Comparable key : keys) {
            boolean include = true;
            double v = 0.0;
            Number n = this.dataset.getValue(key);
            if (n == null) {
                include = !this.ignoreNullValues;
            } else {
                v = n.doubleValue();
                boolean bl = this.ignoreZeroValues ? v > 0.0 : (include = v >= 0.0);
            }
            if (!include) continue;
            runningTotal += v;
            double mid = this.startAngle - this.direction.getFactor() * ((runningTotal - v / 2.0) * 360.0) / totalValue;
            if (Math.cos(Math.toRadians(mid)) < 0.0) {
                leftKeys.addValue(key, new Double(mid));
                continue;
            }
            rightKeys.addValue(key, new Double(mid));
        }
        Paint paint = PaintUtility.createPaint(1, this.getLabelPaintType(), this.getLabelFont());
        paint.setAlpha(255);
        double marginX = (double)plotArea.getX() + this.interiorGap * (double)plotArea.getWidth();
        double gap = (double)plotArea.getWidth() * this.labelGap;
        double ww = (double)linkArea.getX() - gap - marginX;
        float labelWidth = (float)this.labelPadding.trimWidth(ww);
        if (this.labelGenerator != null) {
            this.drawLeftLabels(leftKeys, canvas, plotArea, linkArea, labelWidth, state);
            this.drawRightLabels(rightKeys, canvas, plotArea, linkArea, labelWidth, state);
        }
    }

    protected void drawLeftLabels(KeyedValues keys, Canvas canvas, RectShape plotArea, RectShape linkArea, float maxLabelWidth, PiePlotState state) {
        this.labelDistributor.clear();
        double lGap = (double)plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = (double)state.getLinkArea().getHeight() / 2.0;
        Paint paint = PaintUtility.createPaint(1, this.labelPaintType);
        int i = 0;
        while (i < keys.getItemCount()) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, keys.getKey(i));
            if (label != null) {
                TextBlock block = TextUtilities.createTextBlock(label, this.labelFont, this.labelPaintType, maxLabelWidth, new G2TextMeasurer(paint));
                TextBox labelBox = new TextBox(block);
                labelBox.setBackgroundPaintType(this.labelBackgroundPaintType);
                labelBox.setOutlinePaintType(this.labelOutlinePaintType);
                labelBox.setOutlineStroke(this.labelOutlineStroke);
                labelBox.setShadowPaintType(this.labelShadowPaintType);
                labelBox.setInteriorGap(this.labelPadding);
                double theta = Math.toRadians(keys.getValue(i).doubleValue());
                double baseY = state.getPieCenterY() + Math.sin(theta) * verticalLinkRadius;
                double hh = labelBox.getHeight(canvas);
                this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * -Math.cos(theta), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keys.getKey(i))));
            }
            ++i;
        }
        double hh = plotArea.getHeight();
        double gap = hh * this.getInteriorGap();
        this.labelDistributor.distributeLabels((double)plotArea.getMinY() + gap, hh - 2.0 * gap);
        int i2 = 0;
        while (i2 < this.labelDistributor.getItemCount()) {
            this.drawLeftLabel(canvas, state, this.labelDistributor.getPieLabelRecord(i2));
            ++i2;
        }
    }

    protected void drawRightLabels(KeyedValues keys, Canvas canvas, RectShape plotArea, RectShape linkArea, float maxLabelWidth, PiePlotState state) {
        this.labelDistributor.clear();
        double lGap = (double)plotArea.getWidth() * this.labelGap;
        double verticalLinkRadius = (double)state.getLinkArea().getHeight() / 2.0;
        int i = 0;
        while (i < keys.getItemCount()) {
            String label = this.labelGenerator.generateSectionLabel(this.dataset, keys.getKey(i));
            if (label != null) {
                Paint paint = PaintUtility.createPaint(1, this.labelPaintType, this.labelFont);
                TextBlock block = TextUtilities.createTextBlock(label, this.labelFont, this.labelPaintType, maxLabelWidth, new G2TextMeasurer(paint));
                TextBox labelBox = new TextBox(block);
                labelBox.setBackgroundPaintType(this.labelBackgroundPaintType);
                labelBox.setOutlinePaintType(this.labelOutlinePaintType);
                labelBox.setOutlineStroke(this.labelOutlineStroke);
                labelBox.setShadowPaintType(this.labelShadowPaintType);
                labelBox.setInteriorGap(this.labelPadding);
                double theta = Math.toRadians(keys.getValue(i).doubleValue());
                double baseY = state.getPieCenterY() + Math.sin(theta) * verticalLinkRadius;
                double hh = labelBox.getHeight(canvas);
                this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keys.getKey(i), theta, baseY, labelBox, hh, lGap / 2.0 + lGap / 2.0 * Math.cos(theta), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keys.getKey(i))));
            }
            ++i;
        }
        double hh = plotArea.getHeight();
        double gap = hh * this.getInteriorGap();
        this.labelDistributor.distributeLabels((double)plotArea.getMinY() + gap, hh - 2.0 * gap);
        int i2 = 0;
        while (i2 < this.labelDistributor.getItemCount()) {
            this.drawRightLabel(canvas, state, this.labelDistributor.getPieLabelRecord(i2));
            ++i2;
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        if (this.dataset == null) {
            return result;
        }
        List keys = this.dataset.getKeys();
        int section = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable key : keys) {
            Number n = this.dataset.getValue(key);
            boolean include = true;
            if (n == null) {
                include = !this.ignoreNullValues;
            } else {
                double v = n.doubleValue();
                if (v == 0.0) {
                    include = !this.ignoreZeroValues;
                } else {
                    boolean bl = include = v > 0.0;
                }
            }
            if (include) {
                String label = this.legendLabelGenerator.generateSectionLabel(this.dataset, key);
                if (label != null) {
                    String description = label;
                    String toolTipText = null;
                    if (this.legendLabelToolTipGenerator != null) {
                        toolTipText = this.legendLabelToolTipGenerator.generateSectionLabel(this.dataset, key);
                    }
                    String urlText = null;
                    Paint black = new Paint(1);
                    black.setColor(-16777216);
                    Float outlineStroke = this.lookupSectionOutlineStroke(key);
                    LegendItem item = new LegendItem(label, description, toolTipText, urlText, true, shape, true, this.lookupSectionPaintType(key), true, this.lookupSectionOutlinePaintType(key), outlineStroke.floatValue(), false, (Shape)new LineShape(), 0.0f, (PaintType)new SolidColor(-16777216));
                    item.setDataset(this.getDataset());
                    item.setSeriesIndex(this.dataset.getIndex(key));
                    item.setSeriesKey(key);
                    result.add(item);
                }
                ++section;
                continue;
            }
            ++section;
        }
        return result;
    }

    public String getPlotType() {
        return "Pie_Plot";
    }

    protected RectShape getArcBounds(RectShape unexploded, RectShape exploded, double angle, double extent, double explodePercent) {
        if (explodePercent == 0.0) {
            return unexploded;
        }
        ArcShape arc1 = new ArcShape(unexploded, angle, extent / 2.0, true);
        PointF point1 = arc1.getEndPoint();
        ArcShape arc2 = new ArcShape(exploded, angle, extent / 2.0, true);
        PointF point2 = arc2.getEndPoint();
        double deltaX = (double)(point1.x - point2.x) * explodePercent;
        double deltaY = (double)(point1.y - point2.y) * explodePercent;
        return new RectShape((double)unexploded.getX() - deltaX, (double)unexploded.getY() - deltaY, (double)unexploded.getWidth(), (double)unexploded.getHeight());
    }

    protected void drawLeftLabel(Canvas canvas, PiePlotState state, PieLabelRecord record) {
        double anchorX = state.getLinkArea().getMinX();
        double targetX = anchorX - record.getGap();
        double targetY = record.getAllocatedY();
        if (this.labelLinksVisible) {
            double elbowY;
            double theta = record.getAngle();
            double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
            double linkY = state.getPieCenterY() + Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
            double elbowX = state.getPieCenterX() + Math.cos(theta) * (double)state.getLinkArea().getWidth() / 2.0;
            double anchorY = elbowY = state.getPieCenterY() + Math.sin(theta) * (double)state.getLinkArea().getHeight() / 2.0;
            Paint paint = PaintUtility.createPaint(1, this.labelLinkPaintType, this.labelLinkStroke, this.labelLinkEffect);
            PieLabelLinkStyle style = this.getLabelLinkStyle();
            if (style.equals(PieLabelLinkStyle.STANDARD)) {
                canvas.drawLine((float)linkX, (float)linkY, (float)elbowX, (float)elbowY, paint);
                canvas.drawLine((float)anchorX, (float)anchorY, (float)elbowX, (float)elbowY, paint);
                canvas.drawLine((float)anchorX, (float)anchorY, (float)targetX, (float)targetY, paint);
            } else if (style.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurveShape q = new QuadCurveShape();
                q.setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY);
                q.draw(canvas, paint);
            } else if (style.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurveShape c = new CubicCurveShape();
                c.setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY, linkX, linkY);
                c.draw(canvas, paint);
            }
        }
        TextBox tb = record.getLabel();
        tb.draw(canvas, (float)targetX, (float)targetY, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Canvas canvas, PiePlotState state, PieLabelRecord record) {
        double anchorX = state.getLinkArea().getMaxX();
        double targetX = anchorX + record.getGap();
        double targetY = record.getAllocatedY();
        if (this.labelLinksVisible) {
            double elbowY;
            double theta = record.getAngle();
            double linkX = state.getPieCenterX() + Math.cos(theta) * state.getPieWRadius() * record.getLinkPercent();
            double linkY = state.getPieCenterY() + Math.sin(theta) * state.getPieHRadius() * record.getLinkPercent();
            double elbowX = state.getPieCenterX() + Math.cos(theta) * (double)state.getLinkArea().getWidth() / 2.0;
            double anchorY = elbowY = state.getPieCenterY() + Math.sin(theta) * (double)state.getLinkArea().getHeight() / 2.0;
            PieLabelLinkStyle style = this.getLabelLinkStyle();
            Paint paint = PaintUtility.createPaint(1, this.labelLinkPaintType, this.labelLinkStroke, this.labelLinkEffect);
            if (style.equals(PieLabelLinkStyle.STANDARD)) {
                canvas.drawLine((float)linkX, (float)linkY, (float)elbowX, (float)elbowY, paint);
                canvas.drawLine((float)anchorX, (float)anchorY, (float)elbowX, (float)elbowY, paint);
                canvas.drawLine((float)anchorX, (float)anchorY, (float)targetX, (float)targetY, paint);
            } else if (style.equals(PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurveShape q = new QuadCurveShape();
                q.setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY);
                q.draw(canvas, paint);
            } else if (style.equals(PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurveShape c = new CubicCurveShape();
                c.setCurve(targetX, targetY, anchorX, anchorY, elbowX, elbowY, linkX, linkY);
                c.draw(canvas, paint);
            }
        }
        TextBox tb = record.getLabel();
        tb.draw(canvas, (float)targetX, (float)targetY, RectangleAnchor.LEFT);
    }

    public PaintType getSectionOutlinePaintType() {
        return this.sectionOutlinePaintType;
    }

    public Float getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public PathEffect getSectionOutlineEffect() {
        return this.sectionOutlineEffect;
    }

    public void setSectionOutlineEffect(PathEffect effect) {
        this.sectionOutlineEffect = effect;
    }

    public void setSectionOutlineStroke(int section, Float stroke) {
        Comparable key = this.getSectionKey(section);
        this.setSectionOutlineStroke(key, stroke);
    }

    public double getExplodePercent(int section) {
        Comparable key = this.getSectionKey(section);
        return this.getExplodePercent(key);
    }
}

