/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.block;

import android.graphics.Canvas;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.afree.chart.block.AbstractBlock;
import org.afree.chart.block.Arrangement;
import org.afree.chart.block.Block;
import org.afree.chart.block.BlockResult;
import org.afree.chart.block.BorderArrangement;
import org.afree.chart.block.EntityBlockParams;
import org.afree.chart.block.EntityBlockResult;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.Size2D;

public class BlockContainer
extends AbstractBlock
implements Block,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8199508075695195293L;
    private List blocks;
    private Arrangement arrangement;

    public BlockContainer() {
        this(new BorderArrangement());
    }

    public BlockContainer(Arrangement arrangement) {
        if (arrangement == null) {
            throw new IllegalArgumentException("Null 'arrangement' argument.");
        }
        this.arrangement = arrangement;
        this.blocks = new ArrayList();
    }

    public Arrangement getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(Arrangement arrangement) {
        if (arrangement == null) {
            throw new IllegalArgumentException("Null 'arrangement' argument.");
        }
        this.arrangement = arrangement;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public List getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public void add(Block block) {
        this.add(block, null);
    }

    public void add(Block block, Object key) {
        this.blocks.add(block);
        this.arrangement.add(block, key);
    }

    public void clear() {
        this.blocks.clear();
        this.arrangement.clear();
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        return this.arrangement.arrange(this, canvas, constraint);
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null);
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        EntityBlockParams ebp = null;
        StandardEntityCollection sec = null;
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
        }
        RectShape contentArea = area.clone();
        contentArea = this.trimMargin(contentArea);
        this.drawBorder(canvas, contentArea);
        contentArea = this.trimBorder(contentArea);
        contentArea = this.trimPadding(contentArea);
        for (Block block : this.blocks) {
            RectShape bounds = block.getBounds();
            RectShape drawArea = new RectShape(bounds.getX() + area.getX(), bounds.getY() + area.getY(), bounds.getWidth(), bounds.getHeight());
            Object r = block.draw(canvas, drawArea, params);
            if (sec == null || !(r instanceof EntityBlockResult)) continue;
            EntityBlockResult ebr = (EntityBlockResult)r;
            EntityCollection ec = ebr.getEntityCollection();
            sec.addAll(ec);
        }
        BlockResult result = null;
        if (sec != null) {
            result = new BlockResult();
            result.setEntityCollection(sec);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlockContainer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BlockContainer that = (BlockContainer)obj;
        if (!this.arrangement.equals(that.arrangement)) {
            return false;
        }
        return this.blocks.equals(that.blocks);
    }

    public Object clone() throws CloneNotSupportedException {
        BlockContainer clone = (BlockContainer)super.clone();
        return clone;
    }
}

